/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi.annotations;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.eclipse.jetty.annotations.ClassNameResolver;
import org.eclipse.jetty.osgi.boot.utils.BundleFileLocatorHelper;
import org.eclipse.jetty.util.resource.Resource;
import org.osgi.framework.Bundle;

public class AnnotationParser
extends org.eclipse.jetty.annotations.AnnotationParser {
    private Set<URI> _alreadyParsed = new HashSet<URI>();
    private Map<URI, Bundle> _uriToBundle = new HashMap<URI, Bundle>();
    private Map<Bundle, Resource> _resourceToBundle = new HashMap<Bundle, Resource>();
    private Map<Bundle, URI> _bundleToUri = new HashMap<Bundle, URI>();

    protected Resource indexBundle(Bundle bundle) throws Exception {
        File bundleFile = BundleFileLocatorHelper.DEFAULT.getBundleInstallLocation(bundle);
        Resource resource = Resource.newResource((URI)bundleFile.toURI());
        URI uri = resource.getURI();
        this._uriToBundle.put(uri, bundle);
        this._bundleToUri.put(bundle, uri);
        this._resourceToBundle.put(bundle, resource);
        return resource;
    }

    protected URI getURI(Bundle bundle) {
        return this._bundleToUri.get(bundle);
    }

    protected Resource getResource(Bundle bundle) {
        return this._resourceToBundle.get(bundle);
    }

    public void parse(URI[] uris, ClassNameResolver resolver) throws Exception {
        for (URI uri : uris) {
            Bundle associatedBundle = this._uriToBundle.get(uri);
            if (associatedBundle == null) {
                if (!this._alreadyParsed.add(uri)) continue;
                super.parse(new URI[]{uri}, resolver);
                continue;
            }
            this.parse(associatedBundle, resolver);
        }
    }

    protected void parse(Bundle bundle, ClassNameResolver resolver) throws Exception {
        Enumeration classes;
        URI uri = this._bundleToUri.get(bundle);
        if (!this._alreadyParsed.add(uri)) {
            return;
        }
        String bundleClasspath = (String)bundle.getHeaders().get("Bundle-ClassPath");
        if (bundleClasspath == null) {
            bundleClasspath = ".";
        }
        TreeSet<String> paths = new TreeSet<String>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                int paths2;
                int paths1 = new StringTokenizer(o1, "/", false).countTokens();
                if (paths1 == (paths2 = new StringTokenizer(o2, "/", false).countTokens())) {
                    return o1.compareTo(o2);
                }
                return paths2 - paths1;
            }
        });
        boolean hasDotPath = false;
        StringTokenizer tokenizer = new StringTokenizer(bundleClasspath, ",;", false);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken().trim();
            if (!token.startsWith("/")) {
                token = "/" + token;
            }
            if (token.equals("/.")) {
                hasDotPath = true;
                continue;
            }
            if (!token.endsWith(".jar") && !token.endsWith("/")) {
                paths.add(token + "/");
                continue;
            }
            paths.add(token);
        }
        if (bundle.getEntry("/.classpath") != null) {
            if (bundle.getEntry("/bin/") != null) {
                paths.add("/bin/");
            } else if (bundle.getEntry("/target/classes/") != null) {
                paths.add("/target/classes/");
            }
        }
        if ((classes = bundle.findEntries("/", "*.class", true)) == null) {
            return;
        }
        while (classes.hasMoreElements()) {
            URL classUrl = (URL)classes.nextElement();
            String path = classUrl.getPath();
            String name = null;
            for (String prefixPath : paths) {
                if (!path.startsWith(prefixPath)) continue;
                name = path.substring(prefixPath.length());
                break;
            }
            if (name == null && hasDotPath) {
                name = path.substring(1);
            }
            String shortName = name.replace('/', '.').substring(0, name.length() - 6);
            if (resolver != null && (resolver.isExcluded(shortName) || this.isParsed(shortName) && !resolver.shouldOverride(shortName))) continue;
            this.scanClass(classUrl.openStream());
        }
    }
}

