/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.deployer.core.internal;

import java.io.IOException;
import java.util.Map;
import org.eclipse.virgo.kernel.install.artifact.BundleInstallArtifact;
import org.eclipse.virgo.kernel.install.artifact.InstallArtifact;
import org.eclipse.virgo.kernel.install.environment.InstallEnvironment;
import org.eclipse.virgo.kernel.install.pipeline.stage.transform.Transformer;
import org.eclipse.virgo.nano.deployer.api.core.DeploymentException;
import org.eclipse.virgo.util.common.GraphNode;
import org.eclipse.virgo.util.osgi.manifest.BundleManifest;

final class BundleDeploymentPropertiesTransformer
implements Transformer {
    private static final String HEADER_PREFIX = "header:";

    BundleDeploymentPropertiesTransformer() {
    }

    @Override
    public void transform(GraphNode<InstallArtifact> installGraph, InstallEnvironment installEnvironment) throws DeploymentException {
        installGraph.visit((GraphNode.ExceptionThrowingDirectedAcyclicGraphVisitor)new Visitor());
    }

    private void doTransformBundleArtifact(BundleInstallArtifact value, Map<String, String> deploymentProperties) throws IOException {
        BundleManifest manifest = value.getBundleManifest();
        for (Map.Entry<String, String> entries : deploymentProperties.entrySet()) {
            String headerName = this.convertToHeaderName(entries.getKey());
            if (headerName == null) continue;
            manifest.setHeader(headerName, entries.getValue());
        }
    }

    private String convertToHeaderName(String propertyKey) {
        if (propertyKey.startsWith(HEADER_PREFIX)) {
            return propertyKey.substring(HEADER_PREFIX.length());
        }
        return null;
    }

    private final class Visitor
    implements GraphNode.ExceptionThrowingDirectedAcyclicGraphVisitor<InstallArtifact, DeploymentException> {
        private Visitor() {
        }

        public boolean visit(GraphNode<InstallArtifact> graph) throws DeploymentException {
            Map<String, String> deploymentProperties;
            InstallArtifact value = (InstallArtifact)graph.getValue();
            if (value instanceof BundleInstallArtifact && (deploymentProperties = ((BundleInstallArtifact)value).getDeploymentProperties()) != null && !deploymentProperties.isEmpty()) {
                try {
                    BundleDeploymentPropertiesTransformer.this.doTransformBundleArtifact((BundleInstallArtifact)value, deploymentProperties);
                }
                catch (Exception e) {
                    throw new DeploymentException("Unable to apply deployment for artifact '" + value.getName() + "'", (Throwable)e);
                }
            }
            return true;
        }
    }
}

