/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.web.internal.url;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;

final class DirTransformer {
    private static final String MANIFEST_VERSION_HEADER = "Manifest-Version: 1.0";
    private final DirTransformerCallback callback;

    DirTransformer(DirTransformerCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException("Callback must not be null");
        }
        this.callback = callback;
    }

    void transform(URL url, URL transformedUrl) throws IOException {
        this.transform(url, transformedUrl, false);
    }

    void transform(URL url, URL transformedUrl, boolean ensureManifestIsPresent) throws IOException {
        Path fromDirectory = Paths.get(url.getPath(), new String[0]);
        Path toDirectory = Paths.get(transformedUrl.getPath(), new String[0]);
        this.transformDir(fromDirectory, toDirectory);
        Path manifest = fromDirectory.resolve("META-INF/MANIFEST.MF");
        if (ensureManifestIsPresent && Files.notExists(manifest, new LinkOption[0])) {
            Path toFile = toDirectory.resolve("META-INF/MANIFEST.MF");
            Files.createDirectories(toFile.getParent(), new FileAttribute[0]);
            Throwable throwable = null;
            Object var9_10 = null;
            try (InputStream defaultManifestStream = this.getDefaultManifestStream();){
                this.callback.transformFile(defaultManifestStream, toFile);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    private void transformDir(Path fromDirectory, Path toDirectory) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (DirectoryStream<Path> fileList = Files.newDirectoryStream(fromDirectory);){
            for (Path fromFile : fileList) {
                Path toFile = toDirectory.resolve(fromFile.getFileName());
                if (!Files.isDirectory(fromFile, new LinkOption[0])) {
                    this.transformFile(fromFile, toFile);
                    continue;
                }
                this.transformDir(fromFile, toFile);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void transformFile(Path fromFile, Path toFile) throws IOException {
        boolean transformed = false;
        Throwable throwable = null;
        Object var5_6 = null;
        try (InputStream fis = Files.newInputStream(fromFile, new OpenOption[0]);){
            transformed = this.callback.transformFile(fis, toFile);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        if (!transformed) {
            Files.createDirectories(toFile.getParent(), new FileAttribute[0]);
            Files.copy(fromFile, toFile, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    private InputStream getDefaultManifestStream() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Throwable throwable = null;
        Object var3_4 = null;
        try (PrintWriter writer = new PrintWriter(baos);){
            writer.println(MANIFEST_VERSION_HEADER);
            writer.println();
            return new ByteArrayInputStream(baos.toByteArray());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    static interface DirTransformerCallback {
        public boolean transformFile(InputStream var1, Path var2) throws IOException;
    }
}

