/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.install.artifact.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.virgo.kernel.artifact.ArtifactSpecification;
import org.eclipse.virgo.kernel.artifact.plan.PlanDescriptor;
import org.eclipse.virgo.kernel.deployer.core.internal.AbortableSignalJunction;
import org.eclipse.virgo.kernel.install.artifact.ArtifactIdentity;
import org.eclipse.virgo.kernel.install.artifact.ArtifactStorage;
import org.eclipse.virgo.kernel.install.artifact.InstallArtifact;
import org.eclipse.virgo.kernel.install.artifact.PlanInstallArtifact;
import org.eclipse.virgo.kernel.install.artifact.ScopeServiceRepository;
import org.eclipse.virgo.kernel.install.artifact.internal.AbstractInstallArtifact;
import org.eclipse.virgo.kernel.install.artifact.internal.ArtifactStateMonitor;
import org.eclipse.virgo.kernel.install.artifact.internal.InstallArtifactRefreshHandler;
import org.eclipse.virgo.kernel.install.artifact.internal.PlanMemberCollector;
import org.eclipse.virgo.kernel.install.artifact.internal.PlanScoper;
import org.eclipse.virgo.kernel.install.artifact.internal.scoping.ArtifactIdentityScoper;
import org.eclipse.virgo.medic.eventlog.EventLogger;
import org.eclipse.virgo.medic.eventlog.LogEvent;
import org.eclipse.virgo.nano.core.AbortableSignal;
import org.eclipse.virgo.nano.deployer.api.core.DeployerLogEvents;
import org.eclipse.virgo.nano.deployer.api.core.DeploymentException;
import org.eclipse.virgo.nano.serviceability.NonNull;
import org.eclipse.virgo.nano.shim.scope.Scope;
import org.eclipse.virgo.nano.shim.scope.ScopeFactory;
import org.eclipse.virgo.util.common.GraphNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardPlanInstallArtifact
extends AbstractInstallArtifact
implements PlanInstallArtifact {
    private static final Logger LOGGER = LoggerFactory.getLogger(StandardPlanInstallArtifact.class);
    private final Object monitor = new Object();
    private final ScopeServiceRepository scopeServiceRepository;
    private final ScopeFactory scopeFactory;
    private final InstallArtifactRefreshHandler refreshHandler;
    private final boolean atomic;
    private final boolean scoped;
    private final PlanDescriptor.Provisioning provisioning;
    private final List<ArtifactSpecification> artifactSpecifications;
    protected final EventLogger eventLogger;
    private Scope applicationScope;

    protected StandardPlanInstallArtifact(@NonNull ArtifactIdentity artifactIdentity, boolean atomic, boolean scoped, @NonNull PlanDescriptor.Provisioning provisioning, @NonNull ArtifactStorage artifactStorage, @NonNull ArtifactStateMonitor artifactStateMonitor, @NonNull ScopeServiceRepository scopeServiceRepository, @NonNull ScopeFactory scopeFactory, @NonNull EventLogger eventLogger, @NonNull InstallArtifactRefreshHandler refreshHandler, String repositoryName, List<ArtifactSpecification> artifactSpecifications) throws DeploymentException {
        super(artifactIdentity, artifactStorage, artifactStateMonitor, repositoryName, eventLogger);
        this.policeNestedScopes(artifactIdentity, scoped, eventLogger);
        this.scopeServiceRepository = scopeServiceRepository;
        this.scopeFactory = scopeFactory;
        this.eventLogger = eventLogger;
        this.refreshHandler = refreshHandler;
        this.atomic = atomic;
        this.scoped = scoped;
        if (provisioning == PlanDescriptor.Provisioning.INHERIT) {
            throw new IllegalArgumentException("A plan's provisoning behaviour may not be set to INHERIT");
        }
        this.provisioning = provisioning;
        this.artifactSpecifications = artifactSpecifications;
    }

    private void policeNestedScopes(ArtifactIdentity artifactIdentity, boolean scoped, EventLogger eventLogger) throws DeploymentException {
        if (artifactIdentity.getScopeName() != null && scoped) {
            eventLogger.log((LogEvent)DeployerLogEvents.NESTED_SCOPES_NOT_SUPPORTED, new Object[]{artifactIdentity.getType(), ArtifactIdentityScoper.getUnscopedName(artifactIdentity), artifactIdentity.getVersion(), artifactIdentity.getScopeName()});
            throw new DeploymentException("Nested scope detected", true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final List<GraphNode<InstallArtifact>> getChildrenSnapshot() {
        ArrayList<GraphNode<InstallArtifact>> children = new ArrayList<GraphNode<InstallArtifact>>();
        Object object = this.monitor;
        synchronized (object) {
            children.addAll(this.getGraph().getChildren());
        }
        return children;
    }

    @Override
    protected final void doStart(AbortableSignal signal) throws DeploymentException {
        List<GraphNode<InstallArtifact>> children = this.getChildrenSnapshot();
        int numChildren = children.size();
        AbortableSignalJunction signalJunction = new AbortableSignalJunction(signal, numChildren);
        LOGGER.debug("Created {} that will notify {} to track start of {}", new Object[]{signalJunction, signal, this});
        List<AbortableSignal> subSignals = signalJunction.getSignals();
        int childIndex = 0;
        while (childIndex < numChildren && !signalJunction.failed()) {
            InstallArtifact childArtifact = (InstallArtifact)children.get(childIndex).getValue();
            AbortableSignal subSignal = subSignals.get(childIndex);
            LOGGER.debug("Starting {} with signal {} from {}", new Object[]{childArtifact, subSignal, signalJunction});
            childArtifact.start(subSignal);
            ++childIndex;
        }
    }

    @Override
    protected final void doStop() throws DeploymentException {
        DeploymentException firstFailure = null;
        for (GraphNode<InstallArtifact> child : this.getChildrenSnapshot()) {
            try {
                ((InstallArtifact)child.getValue()).stop();
            }
            catch (DeploymentException e) {
                firstFailure = e;
            }
        }
        if (firstFailure != null) {
            throw firstFailure;
        }
    }

    @Override
    protected final void doUninstall() throws DeploymentException {
        this.deScope();
        DeploymentException firstFailure = null;
        for (GraphNode<InstallArtifact> child : this.getChildrenSnapshot()) {
            this.getGraph().removeChild(child);
            if (this.inUse(child)) continue;
            try {
                ((InstallArtifact)child.getValue()).uninstall();
            }
            catch (DeploymentException e) {
                firstFailure = e;
            }
        }
        if (firstFailure != null) {
            throw firstFailure;
        }
    }

    private boolean inUse(GraphNode<InstallArtifact> child) {
        AbstractInstallArtifact installArtifact = (AbstractInstallArtifact)child.getValue();
        boolean isTopLevelDeployed = installArtifact.getTopLevelDeployed();
        return isTopLevelDeployed || !child.getParents().isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scope() throws DeploymentException {
        if (this.isScoped()) {
            List<InstallArtifact> scopeMembers = new PlanMemberCollector().collectPlanMembers(this);
            PlanScoper planScoper = new PlanScoper(scopeMembers, this.getName(), this.getVersion(), this.scopeServiceRepository, this.eventLogger);
            String scopeName = planScoper.getScopeName();
            Object object = this.monitor;
            synchronized (object) {
                this.applicationScope = this.scopeFactory.getApplicationScope(scopeName);
                planScoper.scope();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deScope() {
        Object object = this.monitor;
        synchronized (object) {
            if (this.applicationScope != null) {
                this.scopeFactory.destroyApplicationScope(this.applicationScope);
                this.scopeServiceRepository.clearScope(this.applicationScope.getScopeName());
                this.applicationScope = null;
            }
        }
    }

    @Override
    public boolean refreshScope() {
        return this.refreshHandler.refresh(this);
    }

    @Override
    public boolean refresh() throws DeploymentException {
        this.eventLogger.log((LogEvent)DeployerLogEvents.INSTALL_ARTIFACT_REFRESH_NOT_SUPPORTED, new Object[]{this.getType(), this.getName(), this.getVersion(), this.getType()});
        return false;
    }

    @Override
    public final boolean isAtomic() {
        return this.atomic;
    }

    @Override
    public final boolean isScoped() {
        return this.scoped;
    }

    @Override
    public PlanDescriptor.Provisioning getProvisioning() {
        return this.provisioning;
    }

    @Override
    public final List<ArtifactSpecification> getArtifactSpecifications() {
        return this.artifactSpecifications;
    }
}

