/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.nano.core.internal;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.virgo.medic.eventlog.EventLogger;
import org.eclipse.virgo.medic.eventlog.LogEvent;
import org.eclipse.virgo.nano.core.Shutdown;
import org.eclipse.virgo.nano.diagnostics.KernelLogEvents;
import org.eclipse.virgo.nano.serviceability.dump.DumpCoordinator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.framework.launch.Framework;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ShutdownManager
implements Shutdown {
    private static final int NORMAL_TERMINATION_EXIT_CODE = 0;
    private static final int GRACEFUL_TERMINATION_FAILURE_EXIT_CODE = 1;
    private static final Logger LOGGER = LoggerFactory.getLogger(ShutdownManager.class);
    private static final long SHUTDOWN_TIMEOUT = TimeUnit.SECONDS.toMillis(30L);
    private static final int STATE_RUNNING = 0;
    private static final int STATE_STOPPING = 1;
    private final AtomicInteger state;
    private final EventLogger eventLogger;
    private final Framework framework;
    private final Runtime runtime;
    private final Thread shutdownHook;

    public ShutdownManager(EventLogger eventLogger, Framework framework, Runtime runtime) {
        try {
            try {
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            this.state = new AtomicInteger(0);
            this.shutdownHook = new Thread(new Runnable(){
                {
                    try {
                        try {
                        }
                        catch (RuntimeException runtimeException) {
                            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                            throw runtimeException;
                        }
                        return;
                    }
                    catch (RuntimeException runtimeException) {
                        DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                        throw runtimeException;
                    }
                }

                @Override
                public void run() {
                    try {
                        try {
                            if (ShutdownManager.access$0(ShutdownManager.this)) {
                                ShutdownManager.access$1(ShutdownManager.this, false);
                            }
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                        }
                        return;
                    }
                    catch (RuntimeException runtimeException) {
                        DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                        throw runtimeException;
                    }
                }
            });
            this.eventLogger = eventLogger;
            this.framework = framework;
            this.runtime = runtime;
            runtime.addShutdownHook(this.shutdownHook);
            BundleContext bundleContext = framework.getBundleContext();
            bundleContext.addBundleListener((BundleListener)new ShutdownLoggingListener(this, null));
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public void shutdown() {
        try {
            this.doShutdown(true);
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void doShutdown(boolean solicitedShutdown) {
        try {
            FrameworkEvent shutdownResponse = null;
            try {
                this.framework.stop();
                shutdownResponse = this.framework.waitForStop(SHUTDOWN_TIMEOUT);
            }
            catch (BundleException ex) {
                LOGGER.error("Error during shutdown.", (Throwable)ex);
            }
            catch (InterruptedException ex) {
                LOGGER.error("Interrupted during shutdown.", (Throwable)ex);
            }
            if (this.isSuccessfulStopResponse(shutdownResponse)) {
                if (solicitedShutdown) {
                    this.initiateJvmTermination();
                }
            } else {
                this.eventLogger.log((LogEvent)KernelLogEvents.SHUTDOWN_HALTED, new Object[0]);
                this.haltJvm(1);
            }
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void initiateJvmTermination() {
        try {
            this.removeShutdownHook();
            this.exitJvm();
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public void immediateShutdown() {
        try {
            this.eventLogger.log((LogEvent)KernelLogEvents.IMMEDIATE_SHUTDOWN_INITIATED, new Object[0]);
            this.initiateJvmTermination();
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    protected void exitJvm() {
        try {
            System.exit(0);
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    protected void haltJvm(int status) {
        try {
            this.runtime.halt(status);
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private boolean isSuccessfulStopResponse(FrameworkEvent shutdownResponse) {
        try {
            return shutdownResponse != null && shutdownResponse.getType() == 64;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    final void removeShutdownHook() {
        try {
            if (this.compareAndSetHookStopping()) {
                this.runtime.removeShutdownHook(this.shutdownHook);
            }
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private boolean compareAndSetHookStopping() {
        try {
            return this.state.compareAndSet(0, 1);
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    static /* synthetic */ boolean access$0(ShutdownManager arg0) {
        try {
            return arg0.compareAndSetHookStopping();
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    static /* synthetic */ void access$1(ShutdownManager arg0, boolean arg1) {
        try {
            arg0.doShutdown(arg1);
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    static /* synthetic */ Framework access$2(ShutdownManager arg0) {
        try {
            return arg0.framework;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    static /* synthetic */ EventLogger access$3(ShutdownManager arg0) {
        try {
            return arg0.eventLogger;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private final class ShutdownLoggingListener
    implements SynchronousBundleListener {
        final /* synthetic */ ShutdownManager this$0;

        private ShutdownLoggingListener(ShutdownManager shutdownManager) {
            this.this$0 = shutdownManager;
            try {
                try {
                }
                catch (RuntimeException runtimeException) {
                    DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                    throw runtimeException;
                }
                try {
                }
                catch (RuntimeException runtimeException) {
                    DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                    throw runtimeException;
                }
                try {
                }
                catch (RuntimeException runtimeException) {
                    DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                    throw runtimeException;
                }
                return;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }

        public void bundleChanged(BundleEvent event) {
            try {
                BundleContext bundleContext = ShutdownManager.access$2(this.this$0).getBundleContext();
                if (256 == event.getType() && event.getBundle() == bundleContext.getBundle()) {
                    ShutdownManager.access$3(this.this$0).log((LogEvent)KernelLogEvents.SHUTDOWN_INITIATED, new Object[0]);
                    this.this$0.removeShutdownHook();
                }
                return;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }

        /* synthetic */ ShutdownLoggingListener(ShutdownManager shutdownManager, ShutdownLoggingListener shutdownLoggingListener) {
            ShutdownManager shutdownManager2 = shutdownManager;
            ShutdownLoggingListener ajc$aspectInstance = this;
            ajc$aspectInstance.this$0 = shutdownManager2;
            try {
                try {
                }
                catch (RuntimeException runtimeException) {
                    DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                    throw runtimeException;
                }
                try {
                }
                catch (RuntimeException runtimeException) {
                    DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                    throw runtimeException;
                }
                try {
                }
                catch (RuntimeException runtimeException) {
                    DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                    throw runtimeException;
                }
                return;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }
    }
}

