/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.snaps.core.internal;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.virgo.snaps.core.internal.deployer.SnapFactory;
import org.eclipse.virgo.util.osgi.manifest.VersionRange;
import org.eclipse.virgo.util.osgi.manifest.parse.HeaderDeclaration;
import org.eclipse.virgo.util.osgi.manifest.parse.HeaderParser;
import org.eclipse.virgo.util.osgi.manifest.parse.HeaderParserFactory;
import org.eclipse.virgo.util.osgi.manifest.parse.ParserLogger;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SnapHostDefinition {
    private static final Logger logger = LoggerFactory.getLogger(SnapHostDefinition.class);
    private final String symbolicName;
    private final VersionRange versionRange;

    private SnapHostDefinition(String symbolicName, VersionRange versionRange) {
        this.symbolicName = symbolicName;
        this.versionRange = versionRange;
    }

    public String getSymbolicName() {
        return this.symbolicName;
    }

    public VersionRange getVersionRange() {
        return this.versionRange;
    }

    public static Set<SnapHostDefinition> parse(String descriptor) {
        HeaderParser parser = SnapHostDefinition.createHeaderParser();
        List header = parser.parseHeader(descriptor);
        if (header == null) {
            logger.error("Invalid Snap-Host header '{}'", (Object)descriptor);
            throw new IllegalArgumentException("Invalid Snap-Host header '" + descriptor + "'");
        }
        HashSet<SnapHostDefinition> hostDefinitions = new HashSet<SnapHostDefinition>();
        for (HeaderDeclaration declaration : header) {
            String factoryName = (String)declaration.getNames().get(0);
            String rangeString = (String)declaration.getAttributes().get("version");
            hostDefinitions.add(SnapHostDefinition.createSnapHostDefinition(factoryName, rangeString));
        }
        return hostDefinitions;
    }

    public static SnapHostDefinition fromServiceReference(ServiceReference<SnapFactory> snapFactoryReference) {
        String factoryName = (String)snapFactoryReference.getProperty("snap.factory.host.name");
        if (factoryName == null) {
            logger.error("Missing service property '{}'", (Object)"snap.factory.host.name");
            throw new IllegalArgumentException("Missing service property 'snap.factory.host.name'");
        }
        String rangeString = (String)snapFactoryReference.getProperty("snap.factory.host.range");
        return SnapHostDefinition.createSnapHostDefinition(factoryName, rangeString);
    }

    private static SnapHostDefinition createSnapHostDefinition(String factoryName, String rangeString) {
        VersionRange range = VersionRange.NATURAL_NUMBER_RANGE;
        if (rangeString != null) {
            range = new VersionRange(rangeString);
        }
        logger.info("Creating a SnapHostDefinition for factory '{}' and range '{}'", (Object)factoryName, (Object)range);
        return new SnapHostDefinition(factoryName, range);
    }

    private static HeaderParser createHeaderParser() {
        return HeaderParserFactory.newHeaderParser((ParserLogger)new ParserLogger(){

            public String[] errorReports() {
                return new String[0];
            }

            public void outputErrorMsg(Exception re, String item) {
                logger.error(item, (Throwable)re);
            }
        });
    }
}

