/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.buf;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;

public class ByteBufferUtils {
    private static final StringManager sm = StringManager.getManager("org.apache.tomcat.util.buf");
    private static final Log log = LogFactory.getLog(ByteBufferUtils.class);
    private static final Method cleanerMethod;
    private static final Method cleanMethod;

    private ByteBufferUtils() {
    }

    public static ByteBuffer expand(ByteBuffer in, int newSize) {
        ByteBuffer out;
        if (in.capacity() >= newSize) {
            return in;
        }
        boolean direct = false;
        if (in.isDirect()) {
            out = ByteBuffer.allocateDirect(newSize);
            direct = true;
        } else {
            out = ByteBuffer.allocate(newSize);
        }
        in.flip();
        out.put(in);
        if (direct) {
            ByteBufferUtils.cleanDirectBuffer(in);
        }
        return out;
    }

    public static void cleanDirectBuffer(ByteBuffer buf) {
        if (cleanMethod != null) {
            try {
                cleanMethod.invoke(cleanerMethod.invoke((Object)buf, new Object[0]), new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException exception) {
                // empty catch block
            }
        }
    }

    static {
        ByteBuffer tempBuffer = ByteBuffer.allocateDirect(0);
        Method cleanerMethodLocal = null;
        Method cleanMethodLocal = null;
        try {
            cleanerMethodLocal = tempBuffer.getClass().getMethod("cleaner", new Class[0]);
            cleanerMethodLocal.setAccessible(true);
            Object cleanerObject = cleanerMethodLocal.invoke((Object)tempBuffer, new Object[0]);
            cleanMethodLocal = cleanerObject instanceof Runnable ? Runnable.class.getMethod("run", new Class[0]) : cleanerObject.getClass().getMethod("clean", new Class[0]);
            cleanMethodLocal.invoke(cleanerObject, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            log.warn((Object)sm.getString("byteBufferUtils.cleaner"), (Throwable)e);
            cleanerMethodLocal = null;
            cleanMethodLocal = null;
        }
        cleanerMethod = cleanerMethodLocal;
        cleanMethod = cleanMethodLocal;
    }
}

