/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.transport.nio;

import java.io.IOException;
import java.net.ServerSocket;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.sql.Timestamp;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.catalina.tribes.io.ObjectReader;
import org.apache.catalina.tribes.transport.AbstractRxTask;
import org.apache.catalina.tribes.transport.ReceiverBase;
import org.apache.catalina.tribes.transport.RxTaskPool;
import org.apache.catalina.tribes.transport.nio.NioReplicationTask;
import org.apache.catalina.tribes.util.StringManager;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class NioReceiver
extends ReceiverBase
implements Runnable {
    private static final Log log = LogFactory.getLog(NioReceiver.class);
    protected static final StringManager sm = StringManager.getManager("org.apache.catalina.tribes.transport");
    private static final String info = "NioReceiver/1.0";
    private volatile boolean running = false;
    private AtomicReference<Selector> selector = new AtomicReference();
    private ServerSocketChannel serverChannel = null;
    private DatagramChannel datagramChannel = null;
    protected LinkedList<Runnable> events = new LinkedList();
    protected long lastCheck = System.currentTimeMillis();

    public String getInfo() {
        return info;
    }

    @Override
    public void stop() {
        this.stopListening();
        super.stop();
    }

    @Override
    public void start() throws IOException {
        super.start();
        try {
            this.setPool(new RxTaskPool(this.getMaxThreads(), this.getMinThreads(), this));
        }
        catch (Exception x) {
            log.fatal((Object)"ThreadPool can initilzed. Listener not started", (Throwable)x);
            if (x instanceof IOException) {
                throw (IOException)x;
            }
            throw new IOException(x.getMessage());
        }
        try {
            this.getBind();
            this.bind();
            Thread t = new Thread((Runnable)this, "NioReceiver");
            t.setDaemon(true);
            t.start();
        }
        catch (Exception x) {
            log.fatal((Object)"Unable to start cluster receiver", (Throwable)x);
            if (x instanceof IOException) {
                throw (IOException)x;
            }
            throw new IOException(x.getMessage());
        }
    }

    @Override
    public AbstractRxTask createRxTask() {
        NioReplicationTask thread = new NioReplicationTask(this, this);
        thread.setUseBufferPool(this.getUseBufferPool());
        thread.setRxBufSize(this.getRxBufSize());
        thread.setOptions(this.getWorkerThreadOptions());
        return thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bind() throws IOException {
        this.serverChannel = ServerSocketChannel.open();
        ServerSocket serverSocket = this.serverChannel.socket();
        Class<Selector> clazz = Selector.class;
        synchronized (Selector.class) {
            this.selector.set(Selector.open());
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.bind(serverSocket, this.getPort(), this.getAutoBind());
            this.serverChannel.configureBlocking(false);
            this.serverChannel.register(this.selector.get(), 16);
            if (this.getUdpPort() > 0) {
                this.datagramChannel = DatagramChannel.open();
                this.configureDatagraChannel();
                this.bindUdp(this.datagramChannel.socket(), this.getUdpPort(), this.getAutoBind());
            }
            return;
        }
    }

    private void configureDatagraChannel() throws IOException {
        this.datagramChannel.configureBlocking(false);
        this.datagramChannel.socket().setSendBufferSize(this.getUdpTxBufSize());
        this.datagramChannel.socket().setReceiveBufferSize(this.getUdpRxBufSize());
        this.datagramChannel.socket().setReuseAddress(this.getSoReuseAddress());
        this.datagramChannel.socket().setSoTimeout(this.getTimeout());
        this.datagramChannel.socket().setTrafficClass(this.getSoTrafficClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEvent(Runnable event) {
        Selector selector = this.selector.get();
        if (selector != null) {
            LinkedList<Runnable> linkedList = this.events;
            synchronized (linkedList) {
                this.events.add(event);
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("Adding event to selector:" + event));
            }
            if (this.isListening()) {
                selector.wakeup();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void events() {
        if (this.events.size() == 0) {
            return;
        }
        LinkedList<Runnable> linkedList = this.events;
        synchronized (linkedList) {
            Runnable r = null;
            while (this.events.size() > 0 && (r = this.events.removeFirst()) != null) {
                try {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Processing event in selector:" + r));
                    }
                    r.run();
                }
                catch (Exception x) {
                    log.error((Object)"", (Throwable)x);
                }
            }
            this.events.clear();
        }
    }

    public static void cancelledKey(SelectionKey key) {
        block11: {
            block10: {
                block9: {
                    ObjectReader reader = (ObjectReader)key.attachment();
                    if (reader != null) {
                        reader.setCancelled(true);
                        reader.finish();
                    }
                    key.cancel();
                    key.attach(null);
                    if (key.channel() instanceof SocketChannel) {
                        try {
                            ((SocketChannel)key.channel()).socket().close();
                        }
                        catch (IOException e) {
                            if (!log.isDebugEnabled()) break block9;
                            log.debug((Object)"", (Throwable)e);
                        }
                    }
                }
                if (key.channel() instanceof DatagramChannel) {
                    try {
                        ((DatagramChannel)key.channel()).socket().close();
                    }
                    catch (Exception e) {
                        if (!log.isDebugEnabled()) break block10;
                        log.debug((Object)"", (Throwable)e);
                    }
                }
            }
            try {
                key.channel().close();
            }
            catch (IOException e) {
                if (!log.isDebugEnabled()) break block11;
                log.debug((Object)"", (Throwable)e);
            }
        }
    }

    protected void socketTimeouts() {
        Set<SelectionKey> keys;
        long now = System.currentTimeMillis();
        if (now - this.lastCheck < this.getSelectorTimeout()) {
            return;
        }
        Selector tmpsel = this.selector.get();
        Set<SelectionKey> set = keys = this.isListening() && tmpsel != null ? tmpsel.keys() : null;
        if (keys == null) {
            return;
        }
        for (SelectionKey key : keys) {
            try {
                if (key.interestOps() != 0) continue;
                ObjectReader ka = (ObjectReader)key.attachment();
                if (ka != null) {
                    long delta = now - ka.getLastAccess();
                    if (delta <= (long)this.getTimeout() || ka.isAccessed()) continue;
                    if (log.isWarnEnabled()) {
                        log.warn((Object)("Channel key is registered, but has had no interest ops for the last " + this.getTimeout() + " ms. (cancelled:" + ka.isCancelled() + "):" + key + " last access:" + new Timestamp(ka.getLastAccess()) + " Possible cause: all threads used, perform thread dump"));
                    }
                    ka.setLastAccess(now);
                    continue;
                }
                NioReceiver.cancelledKey(key);
            }
            catch (CancelledKeyException ckx) {
                NioReceiver.cancelledKey(key);
            }
        }
        this.lastCheck = System.currentTimeMillis();
    }

    protected void listen() throws Exception {
        if (this.doListen()) {
            log.warn((Object)"ServerSocketChannel already started");
            return;
        }
        this.setListen(true);
        Selector selector = this.selector.get();
        if (selector != null && this.datagramChannel != null) {
            ObjectReader oreader = new ObjectReader(65535);
            this.registerChannel(selector, this.datagramChannel, 1, oreader);
        }
        while (this.doListen() && selector != null) {
            try {
                this.events();
                this.socketTimeouts();
                int n = selector.select(this.getSelectorTimeout());
                if (n == 0) continue;
                Iterator<SelectionKey> it = selector.selectedKeys().iterator();
                while (it != null && it.hasNext()) {
                    SelectionKey key = it.next();
                    if (key.isAcceptable()) {
                        ServerSocketChannel server = (ServerSocketChannel)key.channel();
                        SocketChannel channel = server.accept();
                        channel.socket().setReceiveBufferSize(this.getTxBufSize());
                        channel.socket().setSendBufferSize(this.getTxBufSize());
                        channel.socket().setTcpNoDelay(this.getTcpNoDelay());
                        channel.socket().setKeepAlive(this.getSoKeepAlive());
                        channel.socket().setOOBInline(this.getOoBInline());
                        channel.socket().setReuseAddress(this.getSoReuseAddress());
                        channel.socket().setSoLinger(this.getSoLingerOn(), this.getSoLingerTime());
                        channel.socket().setSoTimeout(this.getTimeout());
                        ObjectReader attach = new ObjectReader(channel);
                        this.registerChannel(selector, channel, 1, attach);
                    }
                    if (key.isReadable()) {
                        this.readDataFromSocket(key);
                    } else {
                        key.interestOps(key.interestOps() & 0xFFFFFFFB);
                    }
                    it.remove();
                }
            }
            catch (ClosedSelectorException cse) {
            }
            catch (CancelledKeyException nx) {
                log.warn((Object)"Replication client disconnected, error when polling key. Ignoring client.");
            }
            catch (Throwable t) {
                if (t instanceof ThreadDeath) {
                    throw (ThreadDeath)t;
                }
                if (t instanceof VirtualMachineError) {
                    throw (VirtualMachineError)t;
                }
                log.error((Object)"Unable to process request in NioReceiver", t);
            }
        }
        this.serverChannel.close();
        if (this.datagramChannel != null) {
            block16: {
                try {
                    this.datagramChannel.close();
                }
                catch (Exception iox) {
                    if (!log.isDebugEnabled()) break block16;
                    log.debug((Object)"Unable to close datagram channel.", (Throwable)iox);
                }
            }
            this.datagramChannel = null;
        }
        this.closeSelector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopListening() {
        this.setListen(false);
        Selector selector = this.selector.get();
        if (selector != null) {
            try {
                selector.wakeup();
                for (int count = 0; this.running && count < 50; ++count) {
                    Thread.sleep(100L);
                }
                if (this.running) {
                    log.warn((Object)sm.getString("NioReceiver.stop.threadRunning"));
                }
                this.closeSelector();
            }
            catch (Exception x) {
                log.error((Object)"Unable to close cluster receiver selector.", (Throwable)x);
            }
            finally {
                this.selector.set(null);
            }
        }
    }

    private void closeSelector() throws IOException {
        Selector selector = this.selector.getAndSet(null);
        if (selector == null) {
            return;
        }
        try {
            for (SelectionKey key : selector.keys()) {
                key.channel().close();
                key.attach(null);
                key.cancel();
            }
        }
        catch (IOException ignore) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"Unable to cleanup on selector close.", (Throwable)ignore);
            }
        }
        catch (ClosedSelectorException closedSelectorException) {
            // empty catch block
        }
        selector.close();
    }

    protected void registerChannel(Selector selector, SelectableChannel channel, int ops, Object attach) throws Exception {
        if (channel == null) {
            return;
        }
        channel.configureBlocking(false);
        channel.register(selector, ops, attach);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.running = true;
        try {
            this.listen();
        }
        catch (Exception x) {
            log.error((Object)"Unable to run replication listener.", (Throwable)x);
        }
        finally {
            this.running = false;
        }
    }

    protected void readDataFromSocket(SelectionKey key) throws Exception {
        NioReplicationTask task = (NioReplicationTask)this.getTaskPool().getRxTask();
        if (task == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No TcpReplicationThread available");
            }
        } else {
            task.serviceChannel(key);
            this.getExecutor().execute(task);
        }
    }
}

