/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import org.apache.openejb.assembler.classic.AppInfo;
import org.apache.openejb.assembler.classic.Assembler;
import org.apache.openejb.assembler.classic.event.ContainerSystemPostCreate;
import org.apache.openejb.assembler.classic.event.ContainerSystemPreDestroy;
import org.apache.openejb.config.ConfigurationFactory;
import org.apache.openejb.config.DeploymentsResolver;
import org.apache.openejb.config.sys.Deployments;
import org.apache.openejb.loader.FileUtils;
import org.apache.openejb.loader.Files;
import org.apache.openejb.loader.Options;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.observer.Observes;
import org.apache.openejb.util.Duration;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

public class AutoDeployer {
    private static final Logger logger = Logger.getInstance(LogCategory.OPENEJB, AutoDeployer.class);
    private final ConfigurationFactory factory;
    private final long pollIntervalMillis;
    private final Map<String, FileInfo> files = new HashMap<String, FileInfo>();
    private final Timer timer;
    private final List<Deployments> deployments = new ArrayList<Deployments>();

    public AutoDeployer(ConfigurationFactory factory, List<Deployments> deployments) {
        Options options = SystemInstance.get().getOptions();
        Duration interval = (Duration)options.get("openejb.autodeploy.interval", (Object)new Duration(2L, TimeUnit.SECONDS));
        if (interval.getUnit() == null) {
            interval.setUnit(TimeUnit.SECONDS);
        }
        this.factory = factory;
        this.deployments.addAll(deployments);
        this.pollIntervalMillis = interval.getUnit().toMillis(interval.getTime());
        this.timer = new Timer(this.getClass().getSimpleName());
    }

    public synchronized boolean fileAdded(File file) {
        logger.info("Auto-Deploying: " + file.getAbsolutePath());
        try {
            AppInfo appInfo = this.factory.configureApplication(file);
            appInfo.paths.add(file.getAbsolutePath());
            appInfo.paths.add(appInfo.path);
            for (String path : appInfo.paths) {
                logger.info("Auto-Deploy: Path " + path);
            }
            this.getAssembler().createApplication(appInfo);
        }
        catch (Exception e) {
            logger.error("Auto-Deploy Failed: " + file.getAbsolutePath(), e);
        }
        return true;
    }

    private Assembler getAssembler() {
        return (Assembler)SystemInstance.get().getComponent(Assembler.class);
    }

    public synchronized boolean fileRemoved(File file) {
        String path = file.getAbsolutePath();
        Collection<AppInfo> apps = this.getAssembler().getDeployedApplications();
        for (AppInfo app : apps) {
            if (!app.paths.contains(path)) continue;
            logger.info("Auto-Undeploying: " + app.appId + " - " + file.getAbsolutePath());
            try {
                this.getAssembler().destroyApplication(app);
                for (String location : app.paths) {
                    File delete = new File(location);
                    Files.remove((File)delete);
                    logger.info("Auto-Undeploy: Delete " + location);
                }
                break;
            }
            catch (Exception e) {
                logger.error("Auto-Undeploy Failed: " + file.getAbsolutePath(), e);
                break;
            }
        }
        return true;
    }

    public void fileUpdated(File file) {
        this.fileRemoved(file);
        this.fileAdded(file);
    }

    private Logger getLogger() {
        return logger;
    }

    public void observe(@Observes ContainerSystemPostCreate postCreate) {
        this.start();
    }

    public void observe(@Observes ContainerSystemPreDestroy preDestroy) {
        this.stop();
    }

    public synchronized void stop() {
        this.timer.cancel();
    }

    public void start() {
        this.initialize();
        this.getLogger().debug("Scanner running.  Polling every " + this.pollIntervalMillis + " milliseconds.");
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                try {
                    AutoDeployer.this.scan();
                }
                catch (Exception e) {
                    AutoDeployer.this.getLogger().error("Scan failed.", e);
                }
            }
        }, this.pollIntervalMillis, this.pollIntervalMillis);
    }

    private void initialize() {
        this.getLogger().debug("Doing initial scan of Deployments");
        for (File file : this.list()) {
            if (!file.canRead()) continue;
            FileInfo now = this.newInfo(file);
            now.setChanging(false);
        }
    }

    private FileInfo newInfo(File child) {
        FileInfo fileInfo = child.isDirectory() ? new DirectoryInfo(child) : new FileInfo(child);
        this.files.put(fileInfo.getPath(), fileInfo);
        return fileInfo;
    }

    public void scan() {
        List<File> files = this.list();
        HashSet<String> missingFilesList = new HashSet<String>(this.files.keySet());
        for (File file : files) {
            missingFilesList.remove(file.getAbsolutePath());
            if (!file.canRead()) {
                this.getLogger().debug("not readable " + file.getName());
                continue;
            }
            FileInfo oldStatus = this.oldInfo(file);
            FileInfo newStatus = this.newInfo(file);
            newStatus.diff(oldStatus);
            if (oldStatus == null) {
                this.getLogger().debug("File Discovered: " + newStatus);
                continue;
            }
            if (newStatus.isChanging()) {
                this.getLogger().debug("File Changing: " + newStatus);
                continue;
            }
            if (oldStatus.isNewFile()) {
                this.getLogger().info("New File: " + newStatus);
                newStatus.setNewFile(!this.fileAdded(file));
                continue;
            }
            if (!oldStatus.isChanging()) continue;
            this.getLogger().info("Updated File: " + newStatus);
            this.fileUpdated(file);
            missingFilesList.remove(oldStatus.getPath());
        }
        for (String path : missingFilesList) {
            this.getLogger().info("File removed: " + path);
            if (!this.fileRemoved(new File(path))) continue;
            this.files.remove(path);
        }
    }

    private List<File> list() {
        ArrayList<File> files = new ArrayList<File>();
        FileUtils base = SystemInstance.get().getBase();
        for (Deployments deployment : this.deployments) {
            DeploymentsResolver.loadFrom(deployment, base, files);
        }
        return files;
    }

    private FileInfo oldInfo(File file) {
        return this.files.get(file.getAbsolutePath());
    }

    private static class DirectoryInfo
    extends FileInfo {
        public DirectoryInfo(File dir) {
            super(dir.getAbsolutePath(), 0L, DirectoryInfo.getLastModifiedInDir(dir));
        }

        private static long getLastModifiedInDir(File dir) {
            assert (dir != null);
            long value = dir.lastModified();
            File[] children = dir.listFiles();
            if (children != null) {
                for (File child : children) {
                    long test;
                    if (!child.canRead() || (test = child.isDirectory() ? DirectoryInfo.getLastModifiedInDir(child) : child.lastModified()) <= value) continue;
                    value = test;
                }
            }
            return value;
        }
    }

    private static class FileInfo
    implements Serializable {
        private final String path;
        private long size;
        private long modified;
        private boolean newFile;
        private boolean changing;

        public FileInfo(File file) {
            this(file.getAbsolutePath(), file.length(), file.lastModified());
        }

        public FileInfo(String path, long size, long modified) {
            assert (path != null);
            this.path = path;
            this.size = size;
            this.modified = modified;
            this.newFile = true;
            this.changing = true;
        }

        public String getPath() {
            return this.path;
        }

        public long getSize() {
            return this.size;
        }

        public void setSize(long size) {
            this.size = size;
        }

        public long getModified() {
            return this.modified;
        }

        public void setModified(long modified) {
            this.modified = modified;
        }

        public boolean isNewFile() {
            return this.newFile;
        }

        public void setNewFile(boolean newFile) {
            this.newFile = newFile;
        }

        public boolean isChanging() {
            return this.changing;
        }

        public void setChanging(boolean changing) {
            this.changing = changing;
        }

        public boolean isSame(FileInfo info) {
            assert (info != null);
            if (!this.path.equals(info.path)) {
                throw new IllegalArgumentException("Should only be used to compare two files representing the same path!");
            }
            return this.size == info.size && this.modified == info.modified;
        }

        public String toString() {
            return this.path;
        }

        public void diff(FileInfo old) {
            if (old != null) {
                this.changing = !this.isSame(old);
                this.newFile = old.newFile;
            }
        }
    }
}

