/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.authentication;

import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import java.util.Properties;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.eclipse.virgo.kernel.authentication.CredentialStore;
import org.eclipse.virgo.kernel.authentication.PropertiesFileCredentialStoreFactory;
import org.eclipse.virgo.kernel.authentication.User;

public final class KernelLoginModule
implements LoginModule {
    public static final String FILE_LOCATION = "org.eclipse.virgo.kernel.authentication.file";
    private final CredentialStore credentialStore;
    private volatile Subject subject;
    private volatile CallbackHandler callbackHandler;
    private volatile User user;
    private volatile boolean authenticationResult;

    public KernelLoginModule() {
        this.credentialStore = PropertiesFileCredentialStoreFactory.create(this.getProperties());
    }

    KernelLoginModule(CredentialStore credentialStore) {
        this.credentialStore = credentialStore;
    }

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
    }

    @Override
    public boolean login() throws LoginException {
        NameCallback nameCallback = new NameCallback("username");
        PasswordCallback passwordCallback = new PasswordCallback("password", false);
        try {
            this.callbackHandler.handle(new Callback[]{nameCallback, passwordCallback});
        }
        catch (UnsupportedCallbackException unsupportedCallbackException) {
            throw new FailedLoginException("Unable to get username and password");
        }
        catch (IOException iOException) {
            throw new FailedLoginException("Unable to get username and password");
        }
        this.user = this.credentialStore.getUser(nameCallback.getName());
        this.authenticationResult = this.user.authenticate(new String(passwordCallback.getPassword()));
        if (this.authenticationResult) {
            return true;
        }
        throw new FailedLoginException("Credentials did not match");
    }

    @Override
    public boolean commit() throws LoginException {
        if (!this.authenticationResult) {
            this.user = null;
            return false;
        }
        this.user.addPrincipals(this.subject);
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        this.user = null;
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        this.user.removePrincipals(this.subject);
        this.subject = null;
        this.user = null;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Properties getProperties() {
        Properties properties;
        String fileLocation = System.getProperty(FILE_LOCATION);
        if (fileLocation == null) {
            throw new IllegalArgumentException(String.format("System property '%s' must be set to use the %s JAAS Login Module", FILE_LOCATION, this.getClass().getCanonicalName()));
        }
        FileReader reader = null;
        try {
            reader = new FileReader(fileLocation);
            Properties properties2 = new Properties();
            properties2.load(reader);
            properties = properties2;
            if (reader == null) return properties;
        }
        catch (IOException e) {
            try {
                throw new IllegalArgumentException(String.format("Unable to load properties file from '%s'", fileLocation), e);
            }
            catch (Throwable throwable) {
                if (reader == null) throw throwable;
                try {
                    ((Reader)reader).close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        try {
            ((Reader)reader).close();
            return properties;
        }
        catch (IOException iOException) {}
        return properties;
    }
}

