/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.eventadmin.impl.handler;

import java.util.ArrayList;
import org.apache.felix.eventadmin.impl.handler.BlackList;
import org.apache.felix.eventadmin.impl.handler.Filters;
import org.apache.felix.eventadmin.impl.handler.HandlerTasks;
import org.apache.felix.eventadmin.impl.handler.TopicHandlerFilters;
import org.apache.felix.eventadmin.impl.security.TopicPermissions;
import org.apache.felix.eventadmin.impl.tasks.HandlerTask;
import org.apache.felix.eventadmin.impl.tasks.HandlerTaskImpl;
import org.apache.felix.eventadmin.impl.util.LogWrapper;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class BlacklistingHandlerTasks
implements HandlerTasks {
    private final BlackList m_blackList;
    private final BundleContext m_context;
    private final TopicHandlerFilters m_topicHandlerFilters;
    private final Filters m_filters;
    private final TopicPermissions m_topicPermissions;
    private final EventHandler m_nullEventHandler = new EventHandler(){

        public void handleEvent(Event event) {
        }
    };
    static /* synthetic */ Class class$org$osgi$service$event$EventHandler;

    public BlacklistingHandlerTasks(BundleContext context, BlackList blackList, TopicHandlerFilters topicHandlerFilters, Filters filters, TopicPermissions topicPermissions) {
        this.checkNull(context, "Context");
        this.checkNull(blackList, "BlackList");
        this.checkNull(topicHandlerFilters, "TopicHandlerFilters");
        this.checkNull(filters, "Filters");
        this.checkNull(topicPermissions, "TopicPermissions");
        this.m_context = context;
        this.m_blackList = blackList;
        this.m_topicHandlerFilters = topicHandlerFilters;
        this.m_filters = filters;
        this.m_topicPermissions = topicPermissions;
    }

    public HandlerTask[] createHandlerTasks(Event event) {
        ArrayList<HandlerTaskImpl> result = new ArrayList<HandlerTaskImpl>();
        ServiceReference[] handlerRefs = null;
        try {
            handlerRefs = this.m_context.getServiceReferences((class$org$osgi$service$event$EventHandler == null ? (class$org$osgi$service$event$EventHandler = BlacklistingHandlerTasks.class$("org.osgi.service.event.EventHandler")) : class$org$osgi$service$event$EventHandler).getName(), this.m_topicHandlerFilters.createFilterForTopic(event.getTopic()));
        }
        catch (InvalidSyntaxException e) {
            LogWrapper.getLogger().log(2, "Invalid EVENT_TOPIC [" + event.getTopic() + "]", e);
        }
        if (null == handlerRefs) {
            handlerRefs = new ServiceReference[]{};
        }
        for (int i = 0; i < handlerRefs.length; ++i) {
            if (this.m_blackList.contains(handlerRefs[i]) || !handlerRefs[i].getBundle().hasPermission(this.m_topicPermissions.createTopicPermission(event.getTopic()))) continue;
            try {
                if (!event.matches(this.m_filters.createFilter((String)handlerRefs[i].getProperty("event.filter"), Filters.TRUE_FILTER))) continue;
                result.add(new HandlerTaskImpl(handlerRefs[i], event, this));
                continue;
            }
            catch (InvalidSyntaxException e) {
                LogWrapper.getLogger().log(handlerRefs[i], 2, "Invalid EVENT_FILTER - Blacklisting ServiceReference [" + handlerRefs[i] + " | Bundle(" + handlerRefs[i].getBundle() + ")]", e);
                this.m_blackList.add(handlerRefs[i]);
            }
        }
        return result.toArray(new HandlerTaskImpl[result.size()]);
    }

    public void blackList(ServiceReference handlerRef) {
        this.m_blackList.add(handlerRef);
        LogWrapper.getLogger().log(2, "Blacklisting ServiceReference [" + handlerRef + " | Bundle(" + handlerRef.getBundle() + ")] due to timeout!");
    }

    public EventHandler getEventHandler(ServiceReference handlerRef) {
        Object result = this.m_blackList.contains(handlerRef) ? null : this.m_context.getService(handlerRef);
        return (EventHandler)(null != result ? result : this.m_nullEventHandler);
    }

    public void ungetEventHandler(EventHandler handler, ServiceReference handlerRef) {
        if (this.m_nullEventHandler != handler && !this.m_blackList.contains(handlerRef) && null != handlerRef.getBundle()) {
            this.m_context.ungetService(handlerRef);
        }
    }

    private void checkNull(Object object, String name) {
        if (null == object) {
            throw new NullPointerException(name + " may not be null");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

