/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.ui.editors;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.ui.PDELabelProvider;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.virgo.ide.bundlor.ui.BundlorUiPlugin;
import org.eclipse.virgo.ide.export.BundleExportWizard;
import org.eclipse.virgo.ide.jdt.internal.core.classpath.ServerClasspathContainerUpdateJob;
import org.eclipse.virgo.ide.manifest.internal.core.BundleManifestManager;
import org.eclipse.virgo.ide.ui.ServerIdeUiPlugin;
import org.eclipse.virgo.ide.ui.StatusHandler;
import org.eclipse.virgo.ide.ui.editors.BundleExecutionEnvironmentSection;
import org.eclipse.virgo.ide.ui.editors.BundleGeneralInfoSection;
import org.eclipse.virgo.ide.ui.editors.BundleManifestEditor;
import org.eclipse.virgo.ide.ui.editors.IBundleManifestSaveListener;
import org.eclipse.virgo.ide.ui.editors.ManifestEditorUtils;

public class BundleOverviewPage
extends PDEFormPage
implements IHyperlinkListener,
IBundleManifestSaveListener {
    public static final String PAGE_ID = "bundle_overview";
    private BundleGeneralInfoSection fInfoSection;
    private static final String BUNDLE_CONTENT_SECTION_TEXT = "<form><p>The content of the bundle is made up of two sections:</p><li style=\"image\" value=\"page\" bindent=\"5\"><a href=\"dependencies\">Dependencies</a>: lists all the bundles required on this bundle's classpath to compile and run.</li><li style=\"image\" value=\"page\" bindent=\"5\"><a href=\"runtime\">Runtime</a>: lists the packages that this bundle exports to other bundles.</li></form>";
    private static final String BUNDLE_ACTION_SECTION_TEXT = "<form><p>Perform common actions on the bundle:</p><li style=\"image\" value=\"dependencies\" bindent=\"5\"><a href=\"refreshdependencies\">Refresh Bundle Dependencies</a>: refresh the Bundle Classpath Container to reflect changes in the MANIFEST.MF file.</li><li style=\"image\" value=\"export\" bindent=\"5\"><a href=\"exportbundle\">Export Bundle</a>: export the contents of the Bundle to a deployable JAR.</li></form>";
    private static final String MANIFEST_ERRORS = "Overview: Please correct one or more errors in the manifest";
    protected ScrolledForm form = null;
    protected IResource resource = null;

    public BundleOverviewPage(FormEditor editor) {
        super(editor, PAGE_ID, "Overview");
    }

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        IPluginModelBase model = (IPluginModelBase)((BundleManifestEditor)this.getEditor()).getAggregateModel();
        this.resource = model.getUnderlyingResource();
        this.form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        this.form.setImage(ServerIdeUiPlugin.getImage("full/obj16/osgi_obj.gif"));
        this.form.setText(PDEUIMessages.ManifestEditor_OverviewPage_title);
        this.fillBody(managedForm, toolkit);
        this.updateFormText();
    }

    public void manifestSaved() {
        if (this.resource != null) {
            this.updateFormText();
        }
    }

    protected void updateFormText() {
        if (this.resource != null) {
            try {
                Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, null);
                IMarker[] markers = this.resource.findMarkers(null, true, 0);
                if (ManifestEditorUtils.hasErrorSeverityMarker(markers)) {
                    this.form.setText(MANIFEST_ERRORS);
                    this.form.setImage(ServerIdeUiPlugin.getImage("full/obj16/manifest_error.png"));
                } else {
                    this.form.setText(PDEUIMessages.ManifestEditor_OverviewPage_title);
                    this.form.setImage(ServerIdeUiPlugin.getImage("full/obj16/osgi_obj.gif"));
                }
            }
            catch (OperationCanceledException e) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.virgo.ide.ui", "Could not update page title text", (Throwable)e));
            }
            catch (InterruptedException e) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.virgo.ide.ui", "Could not update page title text", (Throwable)e));
            }
            catch (CoreException e) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.virgo.ide.ui", "Could not update page title text", (Throwable)e));
            }
        }
    }

    private void fillBody(IManagedForm managedForm, FormToolkit toolkit) {
        Composite body = managedForm.getForm().getBody();
        body.setLayout((Layout)FormLayoutFactory.createFormTableWrapLayout((boolean)true, (int)2));
        Composite left = toolkit.createComposite(body);
        left.setLayout((Layout)FormLayoutFactory.createFormPaneTableWrapLayout((boolean)false, (int)1));
        left.setLayoutData((Object)new TableWrapData(256));
        this.fInfoSection = new BundleGeneralInfoSection(this, left);
        managedForm.addPart((IFormPart)this.fInfoSection);
        managedForm.addPart((IFormPart)new BundleExecutionEnvironmentSection(this, left));
        Composite right = toolkit.createComposite(body);
        right.setLayout((Layout)FormLayoutFactory.createFormPaneTableWrapLayout((boolean)false, (int)1));
        right.setLayoutData((Object)new TableWrapData(128));
        this.createBundleActionSection(managedForm, right, toolkit);
        this.createBundleContentSection(managedForm, right, toolkit);
    }

    private void createBundleContentSection(IManagedForm managedForm, Composite parent, FormToolkit toolkit) {
        String sectionTitle = "Bundle Content";
        Section section = this.createStaticSection(toolkit, parent, sectionTitle);
        Composite container = this.createStaticSectionClient(toolkit, (Composite)section);
        FormText text = this.createClient(container, BUNDLE_CONTENT_SECTION_TEXT, true, toolkit);
        PDELabelProvider lp = PDEPlugin.getDefault().getLabelProvider();
        text.setImage("page", lp.get(PDEPluginImages.DESC_PAGE_OBJ, 8));
        text.addHyperlinkListener((IHyperlinkListener)this);
        section.setClient((Control)container);
    }

    private void createBundleActionSection(IManagedForm managedForm, Composite parent, FormToolkit toolkit) {
        String sectionTitle = "Bundle Actions";
        Section section = this.createStaticSection(toolkit, parent, sectionTitle);
        Composite container = this.createStaticSectionClient(toolkit, (Composite)section);
        FormText noteText = this.createClient(container, "<form><p>OSGi dependency meta data in the MANIFEST.MF file can automatically be updated based on dependencies expressed in source code artifacts.</p><p>Java source files, Spring XML configuration, JPA persistence.xml and Hibernate .hbm mapping files will be analysed. The process will create Import-Package and Export-Package headers.</p><li style=\"image\" value=\"manifest\" bindent=\"5\"><a href=\"generate\">Update MANIFEST.MF</a>: automatically generate MANIFEST.MF file based on dependencies in source code artifacts.</li></form>", true, toolkit);
        noteText.setImage("manifest", ServerIdeUiPlugin.getImage("full/obj16/osgi_obj.gif"));
        noteText.addHyperlinkListener((IHyperlinkListener)this);
        Button button = toolkit.createButton(container, "Automatically update MANIFEST.MF file in background.", 32);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

                    protected void execute(IProgressMonitor monitor) throws CoreException, InterruptedException {
                        IProject project = (this).BundleOverviewPage.this.resource.getProject();
                        IProjectDescription description = project.getDescription();
                        try {
                            List<ICommand> cmds = Arrays.asList(description.getBuildSpec());
                            ArrayList<ICommand> newCmds = new ArrayList<ICommand>(cmds);
                            if (BundlorUiPlugin.isBundlorBuilding((IResource)project)) {
                                for (ICommand config : cmds) {
                                    if (!config.getBuilderName().equals("org.eclipse.virgo.ide.bundlor.core.builder")) continue;
                                    newCmds.remove(config);
                                }
                            } else {
                                ICommand command = project.getDescription().newCommand();
                                command.setBuilderName("org.eclipse.virgo.ide.bundlor.core.builder");
                                newCmds.add(command);
                            }
                            if (!cmds.equals(newCmds)) {
                                description.setBuildSpec(newCmds.toArray(new ICommand[0]));
                                project.setDescription(description, monitor);
                            }
                        }
                        catch (CoreException coreException) {
                            // empty catch block
                        }
                    }
                };
                try {
                    PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)PDEPlugin.getActiveWorkbenchWindow(), (IRunnableWithProgress)op, (ISchedulingRule)PDEPlugin.getWorkspace().getRoot());
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        TableWrapData data = new TableWrapData(256);
        data.indent = 5;
        button.setLayoutData((Object)data);
        boolean building = this.resource != null && BundlorUiPlugin.isBundlorBuilding((IResource)this.resource.getProject());
        button.setSelection(building);
        toolkit.createLabel(container, "");
        FormText text = this.createClient(container, BUNDLE_ACTION_SECTION_TEXT, true, toolkit);
        PDELabelProvider lp = PDEPlugin.getDefault().getLabelProvider();
        text.setImage("page", lp.get(PDEPluginImages.DESC_PAGE_OBJ, 8));
        text.setImage("dependencies", JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.jar_lsrc_obj.gif"));
        text.addHyperlinkListener((IHyperlinkListener)this);
        section.setClient((Control)container);
    }

    protected final Section createStaticSection(FormToolkit toolkit, Composite parent, String text) {
        Section section = toolkit.createSection(parent, 256);
        section.clientVerticalSpacing = 6;
        section.setText(text);
        section.setLayout((Layout)FormLayoutFactory.createClearTableWrapLayout((boolean)false, (int)1));
        TableWrapData data = new TableWrapData(256);
        section.setLayoutData((Object)data);
        return section;
    }

    protected Composite createStaticSectionClient(FormToolkit toolkit, Composite parent) {
        Composite container = toolkit.createComposite(parent, 0);
        container.setLayout((Layout)FormLayoutFactory.createSectionClientTableWrapLayout((boolean)false, (int)1));
        TableWrapData data = new TableWrapData(256);
        container.setLayoutData((Object)data);
        return container;
    }

    protected final FormText createClient(Composite section, String content, boolean parseTags, FormToolkit toolkit) {
        FormText text = toolkit.createFormText(section, true);
        try {
            text.setText(content, parseTags, false);
        }
        catch (SWTException e) {
            text.setText(e.getMessage(), false, false);
        }
        return text;
    }

    public void linkActivated(HyperlinkEvent e) {
        if (e.getHref().equals("dependencies")) {
            this.getEditor().setActivePage("bundle_dependencies");
        } else if (e.getHref().equals("runtime")) {
            this.getEditor().setActivePage("bundle_runtime");
        } else if (e.getHref().equals("refreshdependencies")) {
            WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor monitor) throws CoreException, InterruptedException {
                    ServerClasspathContainerUpdateJob.scheduleClasspathContainerUpdateJob((IJavaProject)JavaCore.create((IProject)BundleOverviewPage.this.resource.getProject()), (Set)BundleManifestManager.IMPORTS_CHANGED);
                }
            };
            try {
                PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)PDEPlugin.getActiveWorkbenchWindow(), (IRunnableWithProgress)op, (ISchedulingRule)PDEPlugin.getWorkspace().getRoot());
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (InterruptedException interruptedException) {}
        } else if (e.getHref().equals("generate")) {
            BundlorUiPlugin.runBundlorOnProject((IJavaProject)JavaCore.create((IProject)this.resource.getProject()));
        } else if (e.getHref().equals("exportbundle")) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    BundleExportWizard wizard = new BundleExportWizard();
                    WizardDialog dialog = new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)wizard);
                    wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)new StructuredSelection(new Object[]{JavaCore.create((IProject)BundleOverviewPage.this.resource.getProject())}));
                    dialog.open();
                }
            });
        }
    }

    public void linkEntered(HyperlinkEvent e) {
    }

    public void linkExited(HyperlinkEvent e) {
    }

    public BundleGeneralInfoSection getBundleGeneralInfoSection() {
        return this.fInfoSection;
    }
}

