/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.runtime.internal.ui.filters;

import java.util.HashSet;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.navigator.ICommonFilterDescriptor;
import org.eclipse.ui.navigator.INavigatorFilterService;
import org.eclipse.virgo.ide.runtime.internal.ui.ServerUiImages;
import org.eclipse.virgo.ide.runtime.ui.views.ArtefactCommonView;

public class FilterAction
extends Action {
    ArtefactCommonView navigator;
    String id;

    public void run() {
        INavigatorFilterService activationService = this.navigator.getNavigatorContentService().getFilterService();
        ICommonFilterDescriptor[] visibleFilterDescriptors = activationService.getVisibleFilterDescriptors();
        HashSet<String> activeIDs = new HashSet<String>();
        ICommonFilterDescriptor[] iCommonFilterDescriptorArray = visibleFilterDescriptors;
        int n = visibleFilterDescriptors.length;
        int n2 = 0;
        while (n2 < n) {
            ICommonFilterDescriptor filterDescriptor = iCommonFilterDescriptorArray[n2];
            String filterID = filterDescriptor.getId();
            boolean active = activationService.isActive(filterID);
            if (active) {
                activeIDs.add(filterID);
            }
            ++n2;
        }
        if (this.isChecked()) {
            activeIDs.remove(this.id);
        } else {
            activeIDs.add(this.id);
        }
        String[] ids = activeIDs.toArray(new String[activeIDs.size()]);
        activationService.activateFilterIdsAndUpdateViewer(ids);
    }

    private FilterAction(ArtefactCommonView viewer, String id, ImageDescriptor image) {
        super("", 2);
        ICommonFilterDescriptor[] descriptors;
        this.navigator = viewer;
        this.id = id;
        ICommonFilterDescriptor[] iCommonFilterDescriptorArray = descriptors = viewer.getNavigatorContentService().getFilterService().getVisibleFilterDescriptors();
        int n = descriptors.length;
        int n2 = 0;
        while (n2 < n) {
            ICommonFilterDescriptor descriptor = iCommonFilterDescriptorArray[n2];
            if (descriptor.getId().equals(id)) {
                this.setText("Show " + descriptor.getName());
                this.setDescription("Show " + descriptor.getDescription());
                this.setToolTipText("Show " + descriptor.getName() + " in the list of artifacts.");
                break;
            }
            ++n2;
        }
        this.setImageDescriptor(image);
        this.setDisabledImageDescriptor(image);
        INavigatorFilterService activationService = this.navigator.getNavigatorContentService().getFilterService();
        boolean active = activationService.isActive(id);
        this.setChecked(!active);
    }

    public static FilterAction[] createSet(ArtefactCommonView viewer) {
        return new FilterAction[]{FilterAction.createBundleFilter(viewer), FilterAction.createLibraryFilter(viewer)};
    }

    public static FilterAction createBundleFilter(ArtefactCommonView viewer) {
        return new FilterAction(viewer, "org.eclipse.virgo.ide.runtime.ui.filterBundles", JavaPluginImages.DESC_OBJS_EXTJAR);
    }

    public static FilterAction createLibraryFilter(ArtefactCommonView viewer) {
        return new FilterAction(viewer, "org.eclipse.virgo.ide.runtime.ui.filterLibraries", ServerUiImages.DESC_OBJ_VIRGO_LIB);
    }
}

