/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.patternlanguage.emf.ui.codemining;

import com.google.inject.Inject;
import java.util.Objects;
import java.util.stream.StreamSupport;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.codemining.ICodeMining;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.viatra.query.patternlanguage.emf.services.EMFPatternLanguageGrammarAccess;
import org.eclipse.viatra.query.patternlanguage.emf.types.EMFTypeInferrer;
import org.eclipse.viatra.query.patternlanguage.emf.types.EMFTypeSystem;
import org.eclipse.viatra.query.patternlanguage.emf.ui.EMFPatternLanguageUIPlugin;
import org.eclipse.viatra.query.patternlanguage.emf.vql.Expression;
import org.eclipse.viatra.query.patternlanguage.emf.vql.Parameter;
import org.eclipse.viatra.query.patternlanguage.emf.vql.Pattern;
import org.eclipse.viatra.query.patternlanguage.emf.vql.PatternCall;
import org.eclipse.viatra.query.patternlanguage.emf.vql.ValueReference;
import org.eclipse.viatra.query.patternlanguage.emf.vql.Variable;
import org.eclipse.viatra.query.runtime.emf.types.EClassTransitiveInstancesKey;
import org.eclipse.viatra.query.runtime.emf.types.EDataTypeInSlotsKey;
import org.eclipse.viatra.query.runtime.matchers.context.IInputKey;
import org.eclipse.viatra.query.runtime.matchers.context.common.JavaTransitiveInstancesKey;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.codemining.AbstractXtextCodeMiningProvider;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.IAcceptor;

public class EMFPatternLanguageCodeMiningProvider
extends AbstractXtextCodeMiningProvider {
    @Inject
    EMFPatternLanguageGrammarAccess grammar;
    @Inject
    EMFTypeInferrer typeInferrer;
    @Inject
    EMFTypeSystem typeSystem;
    boolean isMiningEnabled = false;
    IPropertyChangeListener listener = event -> {
        if (Objects.equals(event.getProperty(), "org.eclipse.viatra.query.vql.codemining")) {
            this.isMiningEnabled = (Boolean)event.getNewValue();
        }
    };
    private final IPreferenceStore preferenceStore = EMFPatternLanguageUIPlugin.getInstance().getPreferenceStore();

    public EMFPatternLanguageCodeMiningProvider() {
        this.preferenceStore.addPropertyChangeListener(this.listener);
        this.isMiningEnabled = this.preferenceStore.getBoolean("org.eclipse.viatra.query.vql.codemining");
    }

    protected void createCodeMinings(IDocument document, XtextResource resource, CancelIndicator indicator, IAcceptor<? super ICodeMining> acceptor) {
        if (!this.isMiningEnabled) {
            return;
        }
        TreeIterator it = ((EObject)resource.getContents().get(0)).eAllContents();
        while (it.hasNext()) {
            EObject obj = (EObject)it.next();
            if (obj instanceof Parameter) {
                this.createCodeMinings((Parameter)obj, acceptor);
            }
            if (obj instanceof PatternCall) {
                this.createCodeMinings((PatternCall)obj, acceptor);
                it.prune();
            }
            if (!indicator.isCanceled()) continue;
            return;
        }
    }

    protected void createCodeMinings(PatternCall call, IAcceptor<? super ICodeMining> acceptor) {
        RuleCall paramCall1 = this.grammar.getPatternCallAccess().getParametersValueReferenceParserRuleCall_4_0_0();
        RuleCall paramCall2 = this.grammar.getPatternCallAccess().getParametersValueReferenceParserRuleCall_4_1_1_0();
        Pattern calledPattern = call.getPatternRef();
        if (calledPattern != null && !calledPattern.eIsProxy() && call.getParameters().size() >= 2 && call.getParameters().size() == calledPattern.getParameters().size()) {
            int i = 0;
            while (i < call.getParameters().size()) {
                ValueReference actualValue = (ValueReference)call.getParameters().get(i);
                Variable parameter = (Variable)calledPattern.getParameters().get(i);
                StreamSupport.stream(NodeModelUtils.findActualNodeFor((EObject)actualValue).getAsTreeIterable().spliterator(), false).filter(n -> Objects.equals(paramCall1, n.getGrammarElement()) || Objects.equals(paramCall2, n.getGrammarElement())).findFirst().ifPresent(child -> acceptor.accept((Object)this.createNewLineContentCodeMining(child.getOffset(), parameter.getName() + " -> ")));
                ++i;
            }
        }
    }

    protected void createCodeMinings(Parameter parameter, IAcceptor<? super ICodeMining> acceptor) {
        RuleCall nameCall = this.grammar.getParameterAccess().getNameIDTerminalRuleCall_1_0();
        if (parameter.getType() == null) {
            IInputKey inferredType = this.typeInferrer.getInferredType((Expression)parameter);
            if (inferredType == null) {
                return;
            }
            ICompositeNode node = NodeModelUtils.findActualNodeFor((EObject)parameter);
            StreamSupport.stream(node.getAsTreeIterable().spliterator(), false).filter(n -> Objects.equals(nameCall, n.getGrammarElement())).findFirst().ifPresent(child -> acceptor.accept((Object)this.createNewLineContentCodeMining(child.getEndOffset(), " : " + this.calculateTypeString(inferredType))));
        }
    }

    private String calculateTypeString(IInputKey input) {
        if (input instanceof EClassTransitiveInstancesKey) {
            return ((EClass)((EClassTransitiveInstancesKey)input).getEmfKey()).getName();
        }
        if (input instanceof EDataTypeInSlotsKey) {
            EDataType datatype = (EDataType)((EDataTypeInSlotsKey)input).getEmfKey();
            if (datatype instanceof EEnum) {
                return datatype.getName();
            }
            return "java " + this.typeSystem.getJavaClassName((EDataTypeInSlotsKey)input);
        }
        if (input instanceof JavaTransitiveInstancesKey) {
            return "java " + (String)((JavaTransitiveInstancesKey)input).getWrappedKey();
        }
        return null;
    }

    public void dispose() {
        this.preferenceStore.removePropertyChangeListener(this.listener);
        super.dispose();
    }
}

