/*******************************************************************************
 * Copyright (c) 2010-2018, Zoltan Ujhelyi, Istvan Rath and Daniel Varro
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-v20.html.
 * 
 * SPDX-License-Identifier: EPL-2.0
 *
 * This file was generated from GeneratorModel.xtext
 *******************************************************************************/
package org.eclipse.viatra.query.tooling.generator.model.ide.contentassist.antlr;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Map;
import org.eclipse.viatra.query.tooling.generator.model.ide.contentassist.antlr.internal.InternalGeneratorModelParser;
import org.eclipse.viatra.query.tooling.generator.model.services.GeneratorModelGrammarAccess;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.ide.editor.contentassist.antlr.AbstractContentAssistParser;

public class GeneratorModelParser extends AbstractContentAssistParser {

	@Singleton
	public static final class NameMappings {
		
		private final Map<AbstractElement, String> mappings;
		
		@Inject
		public NameMappings(GeneratorModelGrammarAccess grammarAccess) {
			ImmutableMap.Builder<AbstractElement, String> builder = ImmutableMap.builder();
			init(builder, grammarAccess);
			this.mappings = builder.build();
		}
		
		public String getRuleName(AbstractElement element) {
			return mappings.get(element);
		}
		
		private static void init(ImmutableMap.Builder<AbstractElement, String> builder, GeneratorModelGrammarAccess grammarAccess) {
			builder.put(grammarAccess.getViatraQueryGeneratorModelAccess().getGroup(), "rule__ViatraQueryGeneratorModel__Group__0");
			builder.put(grammarAccess.getGeneratorModelReferenceAccess().getGroup(), "rule__GeneratorModelReference__Group__0");
			builder.put(grammarAccess.getConfigurationAccess().getGroup(), "rule__Configuration__Group__0");
			builder.put(grammarAccess.getConfigurationAccess().getGroup_1(), "rule__Configuration__Group_1__0");
			builder.put(grammarAccess.getPropertyAccess().getGroup(), "rule__Property__Group__0");
			builder.put(grammarAccess.getViatraQueryGeneratorModelAccess().getGenmodelsAssignment_0(), "rule__ViatraQueryGeneratorModel__GenmodelsAssignment_0");
			builder.put(grammarAccess.getViatraQueryGeneratorModelAccess().getConfigurationAssignment_1(), "rule__ViatraQueryGeneratorModel__ConfigurationAssignment_1");
			builder.put(grammarAccess.getGeneratorModelReferenceAccess().getGenmodelAssignment_1(), "rule__GeneratorModelReference__GenmodelAssignment_1");
			builder.put(grammarAccess.getConfigurationAccess().getNameAssignment_0(), "rule__Configuration__NameAssignment_0");
			builder.put(grammarAccess.getConfigurationAccess().getPropertyAssignment_1_1(), "rule__Configuration__PropertyAssignment_1_1");
			builder.put(grammarAccess.getPropertyAccess().getKeyAssignment_0(), "rule__Property__KeyAssignment_0");
			builder.put(grammarAccess.getPropertyAccess().getValueAssignment_2(), "rule__Property__ValueAssignment_2");
		}
	}
	
	@Inject
	private NameMappings nameMappings;

	@Inject
	private GeneratorModelGrammarAccess grammarAccess;

	@Override
	protected InternalGeneratorModelParser createParser() {
		InternalGeneratorModelParser result = new InternalGeneratorModelParser(null);
		result.setGrammarAccess(grammarAccess);
		return result;
	}

	@Override
	protected String getRuleName(AbstractElement element) {
		return nameMappings.getRuleName(element);
	}

	@Override
	protected String[] getInitialHiddenTokens() {
		return new String[] { "RULE_WS", "RULE_ML_COMMENT", "RULE_SL_COMMENT" };
	}

	public GeneratorModelGrammarAccess getGrammarAccess() {
		return this.grammarAccess;
	}

	public void setGrammarAccess(GeneratorModelGrammarAccess grammarAccess) {
		this.grammarAccess = grammarAccess;
	}
	
	public NameMappings getNameMappings() {
		return nameMappings;
	}
	
	public void setNameMappings(NameMappings nameMappings) {
		this.nameMappings = nameMappings;
	}
}
