/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.testing.snapshot;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum InputSpecification implements Enumerator
{
    UNSET(-1, "Unset", "Unset"),
    RESOURCE_SET(0, "ResourceSet", "ResourceSet"),
    RESOURCE(1, "Resource", "Resource"),
    EOBJECT(2, "EObject", "EObject");

    public static final int UNSET_VALUE = -1;
    public static final int RESOURCE_SET_VALUE = 0;
    public static final int RESOURCE_VALUE = 1;
    public static final int EOBJECT_VALUE = 2;
    private static final InputSpecification[] VALUES_ARRAY;
    public static final List<InputSpecification> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new InputSpecification[]{UNSET, RESOURCE_SET, RESOURCE, EOBJECT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static InputSpecification get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            InputSpecification result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static InputSpecification getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            InputSpecification result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static InputSpecification get(int value) {
        switch (value) {
            case -1: {
                return UNSET;
            }
            case 0: {
                return RESOURCE_SET;
            }
            case 1: {
                return RESOURCE;
            }
            case 2: {
                return EOBJECT;
            }
        }
        return null;
    }

    private InputSpecification(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

