/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.patternlanguage.emf.sirius.wizard;

import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.Objects;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.sirius.business.api.componentization.ViewpointRegistry;
import org.eclipse.sirius.business.api.dialect.command.CreateRepresentationCommand;
import org.eclipse.sirius.business.api.modelingproject.ModelingProject;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.tools.api.command.semantic.AddSemanticResourceCommand;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.ui.business.api.session.EditingSessionEvent;
import org.eclipse.sirius.ui.business.api.session.IEditingSession;
import org.eclipse.sirius.ui.business.api.session.SessionUIManager;
import org.eclipse.sirius.ui.business.api.viewpoint.ViewpointSelection;
import org.eclipse.sirius.ui.business.api.viewpoint.ViewpointSelectionCallback;
import org.eclipse.sirius.ui.business.internal.commands.ChangeViewpointSelectionCommand;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.viatra.query.patternlanguage.emf.sirius.wizard.NewVgqlFileConfigurationPage;
import org.eclipse.viatra.query.patternlanguage.emf.ui.EMFPatternLanguageUIPlugin;
import org.eclipse.viatra.query.patternlanguage.metamodel.vgql.PatternPackage;
import org.eclipse.viatra.query.patternlanguage.metamodel.vgql.VgqlFactory;

public class NewVgqlFileWizard
extends Wizard
implements INewWizard {
    private static final String NEW_EMF_INC_QUERY_QUERY_DEFINITION_FILE = "Create a new VIATRA Query Definition file.";
    private NewVgqlFileConfigurationPage page1;
    private ISelection selection;
    private final IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();

    public NewVgqlFileWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.page1 = new NewVgqlFileConfigurationPage();
        this.page1.init((IStructuredSelection)this.selection);
        this.page1.setDescription(NEW_EMF_INC_QUERY_QUERY_DEFINITION_FILE);
        this.addPage((IWizardPage)this.page1);
        this.setForcePreviousAndNextButtons(false);
    }

    public boolean performFinish() {
        final String containerName = this.page1.getContainerName();
        final String fileName = this.page1.getFileName();
        final String packageName = this.page1.getPackageText().replaceAll("\\.", "/");
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        monitor.beginTask("Creating " + fileName, 1);
                        NewVgqlFileWizard.this.createVgqlFile(containerName, fileName, packageName, monitor);
                        monitor.worked(1);
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(false, false, op);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            EMFPatternLanguageUIPlugin.getInstance().logException("Cannot create Query Definition file: " + realException.getMessage(), realException);
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)realException.getMessage());
            return false;
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }

    private IFile createVgqlFile(String containerName, String fileName, String packageName, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)7);
        IResource containerResource = this.root.findMember((IPath)new Path(containerName));
        IPath filePath = containerResource.getFullPath().append(packageName).append(fileName);
        IFile file = this.root.getFile(filePath);
        String fullPath = filePath.toString();
        URI fileURI = URI.createPlatformResourceURI((String)fullPath, (boolean)false);
        URI representationURI = (URI)((ModelingProject)ModelingProject.asModelingProject((IProject)containerResource.getProject()).get()).getMainRepresentationsFileURI((IProgressMonitor)subMonitor.split(1)).get();
        final Session session = SessionManager.INSTANCE.getSession(representationURI, (IProgressMonitor)subMonitor.split(1));
        TransactionalEditingDomain ted = session.getTransactionalEditingDomain();
        Resource resource = ted.createResource(fileURI.toString());
        PatternPackage pkg = this.createPackage(packageName, ted, resource);
        AddSemanticResourceCommand addResourceCommand = new AddSemanticResourceCommand(session, fileURI, (IProgressMonitor)subMonitor.split(1));
        ted.getCommandStack().execute((Command)addResourceCommand);
        containerResource.refreshLocal(0, (IProgressMonitor)subMonitor.split(1));
        ViewpointRegistry.getInstance().getViewpoints().stream().filter(vp -> Objects.equals(vp.getName(), "vp_vql_editor")).findFirst().ifPresent(vp -> ted.getCommandStack().execute((Command)new RecordingCommand(ted, (Viewpoint)vp, pkg, subMonitor, fileName){
            private final /* synthetic */ Viewpoint val$vp;
            private final /* synthetic */ PatternPackage val$pkg;
            private final /* synthetic */ SubMonitor val$subMonitor;
            private final /* synthetic */ String val$fileName;
            {
                this.val$vp = viewpoint;
                this.val$pkg = patternPackage;
                this.val$subMonitor = subMonitor;
                this.val$fileName = string;
                super($anonymous0);
            }

            protected void doExecute() {
                session.createView(this.val$vp, Collections.singletonList(this.val$pkg), (IProgressMonitor)this.val$subMonitor.split(1));
                new ChangeViewpointSelectionCommand(session, (ViewpointSelection.Callback)new ViewpointSelectionCallback(), Collections.singleton(this.val$vp), Collections.emptySet(), (IProgressMonitor)this.val$subMonitor.split(1)).execute();
                this.val$vp.getOwnedRepresentations().stream().filter(rep -> Objects.equals("dd_vql_model_diagram", rep.getName())).findFirst().ifPresent(repDescriptor -> {
                    CreateRepresentationCommand createRepresentationCommand = new CreateRepresentationCommand(session, repDescriptor, (EObject)this.val$pkg, this.val$fileName, (IProgressMonitor)this.val$subMonitor.split(1));
                    IEditingSession editingSession = SessionUIManager.INSTANCE.getUISession(session);
                    editingSession.notify(EditingSessionEvent.REPRESENTATION_ABOUT_TO_BE_CREATED_BEFORE_OPENING);
                    session.getTransactionalEditingDomain().getCommandStack().execute((Command)createRepresentationCommand);
                    editingSession.notify(EditingSessionEvent.REPRESENTATION_CREATED_BEFORE_OPENING);
                    DRepresentation representation = createRepresentationCommand.getCreatedRepresentation();
                    DialectUIManager.INSTANCE.openEditor(session, representation, (IProgressMonitor)this.val$subMonitor.split(1));
                });
            }
        }));
        session.save((IProgressMonitor)subMonitor.split(1));
        return file;
    }

    private PatternPackage createPackage(String packageName, TransactionalEditingDomain ted, final Resource resource) {
        final PatternPackage pkg = VgqlFactory.eINSTANCE.createPatternPackage();
        if (packageName != null && !packageName.isEmpty()) {
            pkg.setPackageName(packageName.replace("/", "."));
        }
        ted.getCommandStack().execute((Command)new RecordingCommand(ted){

            protected void doExecute() {
                resource.getContents().add((Object)pkg);
            }
        });
        return pkg;
    }
}

