/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.dse.evolutionary.parentselectors;

import java.util.List;
import java.util.Random;
import org.eclipse.viatra.dse.evolutionary.interfaces.IParentSelectionStrategy;
import org.eclipse.viatra.dse.objectives.TrajectoryFitness;

public class CrowdedTournementParentSelector
implements IParentSelectionStrategy {
    private Random rnd;
    private List<TrajectoryFitness> parentPopulation;

    @Override
    public void init(List<TrajectoryFitness> actualParentPopulation) {
        this.parentPopulation = actualParentPopulation;
        this.rnd = new Random();
    }

    @Override
    public TrajectoryFitness getNextParent() {
        int index1 = this.rnd.nextInt(this.parentPopulation.size());
        int index2 = this.rnd.nextInt(this.parentPopulation.size());
        while (index2 == index1) {
            index2 = this.rnd.nextInt(this.parentPopulation.size());
        }
        TrajectoryFitness parentCandidate1 = this.parentPopulation.get(index1);
        TrajectoryFitness parentCandidate2 = this.parentPopulation.get(index2);
        if (parentCandidate1.rank < parentCandidate2.rank) {
            return parentCandidate1;
        }
        if (parentCandidate1.rank > parentCandidate2.rank) {
            return parentCandidate2;
        }
        if (parentCandidate2.crowdingDistance > parentCandidate1.crowdingDistance) {
            return parentCandidate2;
        }
        return parentCandidate1;
    }

    @Override
    public IParentSelectionStrategy createNew() {
        return new CrowdedTournementParentSelector();
    }
}

