/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.dse.objectives;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import org.eclipse.viatra.dse.objectives.Fitness;
import org.eclipse.viatra.dse.objectives.IObjective;
import org.eclipse.viatra.dse.objectives.TrajectoryFitness;
import org.eclipse.viatra.query.runtime.matchers.util.Preconditions;

public class ObjectiveComparatorHelper {
    private IObjective[][] leveledObjectives;
    private List<TrajectoryFitness> trajectoryFitnesses = new ArrayList<TrajectoryFitness>();
    private Random random = new Random();
    private boolean computeCrowdingDistance = false;

    public ObjectiveComparatorHelper(IObjective[][] leveledObjectives) {
        this.leveledObjectives = leveledObjectives;
    }

    public void setComputeCrowdingDistance(boolean computeCrowdingDistance) {
        this.computeCrowdingDistance = computeCrowdingDistance;
    }

    public int compare(Fitness o1, Fitness o2) {
        int i = 0;
        while (i < this.leveledObjectives.length) {
            block7: {
                boolean o1HasBetterFitness = false;
                boolean o2HasBetterFitness = false;
                IObjective[] iObjectiveArray = this.leveledObjectives[i];
                int n = iObjectiveArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IObjective objective = iObjectiveArray[n2];
                    String objectiveName = objective.getName();
                    int sgn = objective.getComparator().compare((Double)o1.get(objectiveName), (Double)o2.get(objectiveName));
                    if (sgn < 0) {
                        o2HasBetterFitness = true;
                    }
                    if (sgn > 0) {
                        o1HasBetterFitness = true;
                    }
                    if (!o1HasBetterFitness || !o2HasBetterFitness) {
                        ++n2;
                        continue;
                    }
                    break block7;
                }
                if (o2HasBetterFitness && !o1HasBetterFitness) {
                    return -1;
                }
                if (!o2HasBetterFitness && o1HasBetterFitness) {
                    return 1;
                }
            }
            ++i;
        }
        return 0;
    }

    public void addTrajectoryFitness(TrajectoryFitness trajectoryFitness) {
        this.trajectoryFitnesses.add(trajectoryFitness);
    }

    public void clearTrajectoryFitnesses() {
        this.trajectoryFitnesses.clear();
    }

    public List<TrajectoryFitness> getTrajectoryFitnesses() {
        return this.trajectoryFitnesses;
    }

    public TrajectoryFitness getRandomBest() {
        List<TrajectoryFitness> paretoFront = this.getParetoFront();
        int randomIndex = this.random.nextInt(paretoFront.size());
        return paretoFront.get(randomIndex);
    }

    public List<TrajectoryFitness> getParetoFront() {
        return this.getFronts().get(0);
    }

    public List<? extends List<TrajectoryFitness>> getFronts() {
        Preconditions.checkArgument((!this.trajectoryFitnesses.isEmpty() ? 1 : 0) != 0, (String)"No trajectory fitnesses were added.");
        ArrayList fronts = new ArrayList();
        HashMap dominatedInstances = new HashMap();
        HashMap<TrajectoryFitness, Integer> dominatingInstances = new HashMap<TrajectoryFitness, Integer>();
        for (TrajectoryFitness TrajectoryFitnessP : this.trajectoryFitnesses) {
            List<TrajectoryFitness> firstDominationFront;
            dominatedInstances.put(TrajectoryFitnessP, new ArrayList());
            dominatingInstances.put(TrajectoryFitnessP, 0);
            for (TrajectoryFitness TrajectoryFitnessQ : this.trajectoryFitnesses) {
                int dominates = this.compare(TrajectoryFitnessP.fitness, TrajectoryFitnessQ.fitness);
                if (dominates > 0) {
                    ((ArrayList)dominatedInstances.get(TrajectoryFitnessP)).add(TrajectoryFitnessQ);
                    continue;
                }
                if (dominates >= 0) continue;
                dominatingInstances.put(TrajectoryFitnessP, (Integer)dominatingInstances.get(TrajectoryFitnessP) + 1);
            }
            if ((Integer)dominatingInstances.get(TrajectoryFitnessP) != 0) continue;
            TrajectoryFitnessP.rank = 1;
            if (fronts.isEmpty()) {
                firstDominationFront = new ArrayList<TrajectoryFitness>();
                ((ArrayList)firstDominationFront).add(TrajectoryFitnessP);
                fronts.add(firstDominationFront);
                continue;
            }
            firstDominationFront = (List)fronts.get(0);
            firstDominationFront.add(TrajectoryFitnessP);
        }
        int i = 1;
        while (fronts.size() == i) {
            ArrayList<TrajectoryFitness> nextDominationFront = new ArrayList<TrajectoryFitness>();
            for (TrajectoryFitness TrajectoryFitnessP : (ArrayList)fronts.get(i - 1)) {
                for (TrajectoryFitness TrajectoryFitnessQ : (ArrayList)dominatedInstances.get(TrajectoryFitnessP)) {
                    dominatingInstances.put(TrajectoryFitnessQ, (Integer)dominatingInstances.get(TrajectoryFitnessQ) - 1);
                    if ((Integer)dominatingInstances.get(TrajectoryFitnessQ) != 0) continue;
                    TrajectoryFitnessQ.rank = i + 1;
                    nextDominationFront.add(TrajectoryFitnessQ);
                }
            }
            ++i;
            if (nextDominationFront.isEmpty()) continue;
            if (this.computeCrowdingDistance) {
                ObjectiveComparatorHelper.crowdingDistanceAssignment(nextDominationFront, this.leveledObjectives);
            }
            fronts.add(nextDominationFront);
        }
        return fronts;
    }

    public static void crowdingDistanceAssignment(List<TrajectoryFitness> front, IObjective[][] leveledObjectives) {
        for (TrajectoryFitness InstanceData : front) {
            InstanceData.crowdingDistance = 0.0;
        }
        IObjective[][] iObjectiveArray = leveledObjectives;
        int n = leveledObjectives.length;
        int n2 = 0;
        while (n2 < n) {
            IObjective[] objectives;
            IObjective[] iObjectiveArray2 = objectives = iObjectiveArray[n2];
            int n3 = objectives.length;
            int n4 = 0;
            while (n4 < n3) {
                IObjective objective = iObjectiveArray2[n4];
                String m = objective.getName();
                TrajectoryFitness[] sortedFront = front.toArray(new TrajectoryFitness[0]);
                Arrays.sort(sortedFront, (o1, o2) -> objective.getComparator().compare((Double)o1.fitness.get(m), (Double)o2.fitness.get(m)));
                sortedFront[0].crowdingDistance = Double.POSITIVE_INFINITY;
                sortedFront[sortedFront.length - 1].crowdingDistance = Double.POSITIVE_INFINITY;
                if (sortedFront[0].fitness.get(m) != sortedFront[sortedFront.length - 1].fitness.get(m)) {
                    int i = 1;
                    while (i < sortedFront.length - 1) {
                        double newCrowdingDistance = sortedFront[i].crowdingDistance;
                        sortedFront[i].crowdingDistance = newCrowdingDistance += ((Double)sortedFront[i + 1].fitness.get(m) - (Double)sortedFront[i - 1].fitness.get(m)) / ((Double)sortedFront[sortedFront.length - 1].fitness.get(m) - (Double)sortedFront[0].fitness.get(m));
                        ++i;
                    }
                }
                ++n4;
            }
            ++n2;
        }
    }
}

