/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.rete.network;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.viatra.query.runtime.matchers.context.IPosetComparator;
import org.eclipse.viatra.query.runtime.matchers.tuple.ITuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.TupleMask;
import org.eclipse.viatra.query.runtime.matchers.util.Clearable;
import org.eclipse.viatra.query.runtime.rete.network.CommunicationGroup;
import org.eclipse.viatra.query.runtime.rete.network.CommunicationTracker;
import org.eclipse.viatra.query.runtime.rete.network.Direction;
import org.eclipse.viatra.query.runtime.rete.network.Mailbox;
import org.eclipse.viatra.query.runtime.rete.network.MessageKind;
import org.eclipse.viatra.query.runtime.rete.network.MonotonicityAwareReceiver;
import org.eclipse.viatra.query.runtime.rete.network.Receiver;
import org.eclipse.viatra.query.runtime.rete.network.ReteContainer;

public class MonotonicityAwareMailbox
implements Mailbox {
    protected MessageIndexer monotoneQueue;
    protected MessageIndexer antiMonotoneQueue;
    protected MessageIndexer monotoneBuffer;
    protected MessageIndexer antiMonotoneBuffer;
    protected boolean deliveringMonotone;
    protected boolean deliveringAntiMonotone;
    protected final MonotonicityAwareReceiver receiver;
    protected final ReteContainer container;
    protected final CommunicationTracker tracker;
    protected final TupleMask groupMask;
    protected CommunicationGroup currentGroup = null;

    public MonotonicityAwareMailbox(MonotonicityAwareReceiver receiver, ReteContainer container) {
        this.receiver = receiver;
        this.container = container;
        this.tracker = container.getTracker();
        this.groupMask = receiver.getCoreMask();
        this.monotoneQueue = new MessageIndexer();
        this.antiMonotoneQueue = new MessageIndexer();
        this.monotoneBuffer = new MessageIndexer();
        this.antiMonotoneBuffer = new MessageIndexer();
        this.deliveringMonotone = false;
        this.deliveringAntiMonotone = false;
    }

    protected MessageIndexer getActiveMonotoneQueue() {
        if (this.deliveringMonotone) {
            return this.monotoneBuffer;
        }
        return this.monotoneQueue;
    }

    protected MessageIndexer getActiveAntiMonotoneQueue() {
        if (this.deliveringAntiMonotone) {
            return this.antiMonotoneBuffer;
        }
        return this.antiMonotoneQueue;
    }

    @Override
    public void postMessage(Direction direction, Tuple update) {
        MessageIndexer monotoneQueue = this.getActiveMonotoneQueue();
        MessageIndexer antiMonotoneQueue = this.getActiveAntiMonotoneQueue();
        boolean wasPresentAsMonotone = monotoneQueue.getCount(update) != 0;
        boolean wasPresentAsAntiMonotone = antiMonotoneQueue.getCount(update) != 0;
        TupleMask coreMask = this.receiver.getCoreMask();
        assert (!wasPresentAsMonotone || !wasPresentAsAntiMonotone);
        if (direction == Direction.INSERT) {
            if (wasPresentAsAntiMonotone) {
                antiMonotoneQueue.insert(update);
            } else {
                monotoneQueue.insert(update);
                if (!wasPresentAsMonotone) {
                    Set<Tuple> counterParts = this.tryFindCounterPart(update, false, true);
                    for (Tuple counterPart : counterParts) {
                        int count = antiMonotoneQueue.getCount(counterPart);
                        assert (count < 0);
                        antiMonotoneQueue.update(counterPart, -count);
                        monotoneQueue.update(counterPart, count);
                    }
                }
            }
        } else if (wasPresentAsAntiMonotone) {
            antiMonotoneQueue.delete(update);
        } else if (wasPresentAsMonotone) {
            monotoneQueue.delete(update);
            HashSet<Tuple> candidates = new HashSet<Tuple>();
            Tuple key = coreMask.transform((ITuple)update);
            for (Map.Entry<Tuple, Integer> entry : monotoneQueue.getTuplesByGroup(key).entrySet()) {
                Tuple candidate;
                Set<Tuple> counterParts;
                if (entry.getValue() >= 0 || !(counterParts = this.tryFindCounterPart(candidate = entry.getKey(), true, false)).isEmpty()) continue;
                candidates.add(candidate);
            }
            for (Tuple candidate : candidates) {
                int count = monotoneQueue.getCount(candidate);
                assert (count < 0);
                monotoneQueue.update(candidate, -count);
                antiMonotoneQueue.update(candidate, count);
            }
        } else {
            Set<Tuple> counterParts = this.tryFindCounterPart(update, true, false);
            if (counterParts.isEmpty()) {
                antiMonotoneQueue.delete(update);
            } else {
                monotoneQueue.delete(update);
            }
        }
        if (this.container != null) {
            if (antiMonotoneQueue.isEmpty()) {
                this.currentGroup.notifyLostAllMessages(this, MessageKind.ANTI_MONOTONE);
            } else {
                this.currentGroup.notifyHasMessage(this, MessageKind.ANTI_MONOTONE);
            }
            if (monotoneQueue.isEmpty()) {
                this.currentGroup.notifyLostAllMessages(this, MessageKind.MONOTONE);
            } else {
                this.currentGroup.notifyHasMessage(this, MessageKind.MONOTONE);
            }
        }
    }

    protected Set<Tuple> tryFindCounterPart(Tuple first, boolean findPositiveCounterPart, boolean findAllCounterParts) {
        MessageIndexer monotoneQueue = this.getActiveMonotoneQueue();
        MessageIndexer antiMonotoneQueue = this.getActiveAntiMonotoneQueue();
        TupleMask coreMask = this.receiver.getCoreMask();
        TupleMask posetMask = this.receiver.getPosetMask();
        IPosetComparator posetComparator = this.receiver.getPosetComparator();
        HashSet<Tuple> result = new HashSet<Tuple>();
        Tuple firstKey = coreMask.transform((ITuple)first);
        Tuple firstValue = posetMask.transform((ITuple)first);
        if (findPositiveCounterPart) {
            for (Map.Entry<Tuple, Integer> entry : monotoneQueue.getTuplesByGroup(firstKey).entrySet()) {
                Tuple secondValue = posetMask.transform((ITuple)entry.getKey());
                if (entry.getValue() <= 0 || !posetComparator.isLessOrEqual(firstValue, secondValue)) continue;
                result.add(entry.getKey());
                if (findAllCounterParts) continue;
                return result;
            }
        } else {
            for (Map.Entry<Tuple, Integer> entry : antiMonotoneQueue.getTuplesByGroup(firstKey).entrySet()) {
                Tuple secondValue = posetMask.transform((ITuple)entry.getKey());
                if (!posetComparator.isLessOrEqual(secondValue, firstValue)) continue;
                result.add(entry.getKey());
                if (findAllCounterParts) continue;
                return result;
            }
        }
        return result;
    }

    @Override
    public void deliverAll(MessageKind kind) {
        if (kind == MessageKind.ANTI_MONOTONE) {
            this.deliveringAntiMonotone = true;
            for (Tuple group : this.antiMonotoneQueue.getGroups()) {
                for (Map.Entry<Tuple, Integer> entry : this.antiMonotoneQueue.getTuplesByGroup(group).entrySet()) {
                    Tuple update = entry.getKey();
                    int count = entry.getValue();
                    assert (count < 0);
                    int i = 0;
                    while (i < Math.abs(count)) {
                        this.receiver.update(Direction.REVOKE, update, false);
                        ++i;
                    }
                }
            }
            this.deliveringAntiMonotone = false;
            MessageIndexer tmp = this.antiMonotoneQueue;
            this.antiMonotoneQueue = this.antiMonotoneBuffer;
            this.antiMonotoneBuffer = tmp;
            this.antiMonotoneBuffer.clear();
        } else if (kind == MessageKind.MONOTONE) {
            this.deliveringMonotone = true;
            for (Tuple group : this.monotoneQueue.getGroups()) {
                for (Map.Entry<Tuple, Integer> entry : this.monotoneQueue.getTuplesByGroup(group).entrySet()) {
                    Tuple update = entry.getKey();
                    int count = entry.getValue();
                    assert (count != 0);
                    Direction direction = count < 0 ? Direction.REVOKE : Direction.INSERT;
                    int i = 0;
                    while (i < Math.abs(count)) {
                        this.receiver.update(direction, update, true);
                        ++i;
                    }
                }
            }
            this.deliveringMonotone = false;
            MessageIndexer tmp = this.monotoneQueue;
            this.monotoneQueue = this.monotoneBuffer;
            this.monotoneBuffer = tmp;
            this.monotoneBuffer.clear();
        }
    }

    public String toString() {
        return "MONO_MBOX (" + this.receiver + ") " + this.monotoneQueue + " " + this.antiMonotoneQueue;
    }

    @Override
    public Receiver getReceiver() {
        return this.receiver;
    }

    public void clear() {
        this.monotoneQueue.clear();
        this.antiMonotoneQueue.clear();
        this.monotoneBuffer.clear();
        this.antiMonotoneBuffer.clear();
    }

    @Override
    public CommunicationGroup getCurrentGroup() {
        return this.currentGroup;
    }

    @Override
    public void setCurrentGroup(CommunicationGroup currentGroup) {
        this.currentGroup = currentGroup;
    }

    protected class MessageIndexer
    implements Clearable {
        protected final Map<Tuple, Map<Tuple, Integer>> indexer = new LinkedHashMap<Tuple, Map<Tuple, Integer>>();

        public Map<Tuple, Integer> getTuplesByGroup(Tuple group) {
            Map<Tuple, Integer> valueMap = this.indexer.get(group);
            if (valueMap == null) {
                return Collections.emptyMap();
            }
            return Collections.unmodifiableMap(valueMap);
        }

        public int getCount(Tuple update) {
            Tuple group = MonotonicityAwareMailbox.this.groupMask.transform((ITuple)update);
            Integer count = this.getTuplesByGroup(group).get(update);
            if (count == null) {
                return 0;
            }
            return count;
        }

        public Set<Tuple> getGroups() {
            return Collections.unmodifiableSet(this.indexer.keySet());
        }

        public void insert(Tuple update) {
            this.update(update, 1);
        }

        public void delete(Tuple update) {
            this.update(update, -1);
        }

        public void update(Tuple update, int delta) {
            Integer oldCount;
            int newCount;
            Tuple group = MonotonicityAwareMailbox.this.groupMask.transform((ITuple)update);
            Map<Tuple, Integer> valueMap = this.indexer.get(group);
            if (valueMap == null) {
                valueMap = new HashMap<Tuple, Integer>();
                this.indexer.put(group, valueMap);
            }
            if ((newCount = ((oldCount = valueMap.get(update)) == null ? 0 : oldCount) + delta) == 0) {
                valueMap.remove(update);
                if (valueMap.isEmpty()) {
                    this.indexer.remove(group);
                }
            } else {
                valueMap.put(update, newCount);
            }
        }

        public boolean isEmpty() {
            return this.indexer.isEmpty();
        }

        public void clear() {
            this.indexer.clear();
        }
    }
}

