/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.layout.algorithms;

import org.eclipse.gef4.geometry.planar.Point;
import org.eclipse.gef4.geometry.planar.Rectangle;
import org.eclipse.gef4.layout.LayoutAlgorithm;
import org.eclipse.gef4.layout.algorithms.AlgorithmHelper;
import org.eclipse.gef4.layout.algorithms.TreeLayoutAlgorithm;
import org.eclipse.gef4.layout.interfaces.EntityLayout;
import org.eclipse.gef4.layout.interfaces.LayoutContext;

public class RadialLayoutAlgorithm
implements LayoutAlgorithm {
    private static final double MAX_DEGREES = Math.PI * 2;
    private double startDegree = 0.0;
    private double endDegree = Math.PI * 2;
    private LayoutContext context;
    private boolean resize = false;
    private TreeLayoutAlgorithm treeLayout = new TreeLayoutAlgorithm();

    public void applyLayout(boolean clean) {
        if (!clean) {
            return;
        }
        this.treeLayout.internalApplyLayout();
        EntityLayout[] entities = this.context.getEntities();
        Rectangle bounds = this.context.getBounds();
        this.computeRadialPositions(entities, bounds);
        if (this.resize) {
            AlgorithmHelper.maximizeSizes(entities);
        }
        int insets = 4;
        bounds.setX(bounds.getX() + (double)insets);
        bounds.setY(bounds.getY() + (double)insets);
        bounds.setWidth(bounds.getWidth() - (double)(2 * insets));
        bounds.setHeight(bounds.getHeight() - (double)(2 * insets));
        AlgorithmHelper.fitWithinBounds(entities, bounds, this.resize);
    }

    private void computeRadialPositions(EntityLayout[] entities, Rectangle bounds) {
        Rectangle layoutBounds = AlgorithmHelper.getLayoutBounds(entities, false);
        layoutBounds.setX(bounds.getX());
        layoutBounds.setWidth(bounds.getWidth());
        int i = 0;
        while (i < entities.length) {
            Point location = entities[i].getLocation();
            double percenttheta = (location.x - layoutBounds.getX()) / layoutBounds.getWidth();
            double distance = (location.y - layoutBounds.getY()) / layoutBounds.getHeight();
            double theta = this.startDegree + Math.abs(this.endDegree - this.startDegree) * percenttheta;
            location.x = distance * Math.cos(theta);
            location.y = distance * Math.sin(theta);
            entities[i].setLocation(location.x, location.y);
            ++i;
        }
    }

    public void setLayoutContext(LayoutContext context) {
        this.context = context;
        this.treeLayout.setLayoutContext(context);
    }

    public LayoutContext getLayoutContext() {
        return this.context;
    }

    public void setRangeToLayout(double startDegree, double endDegree) {
        this.startDegree = startDegree;
        this.endDegree = endDegree;
    }

    public boolean isResizing() {
        return this.resize;
    }

    public void setResizing(boolean resizing) {
        this.resize = resizing;
        this.treeLayout.setResizing(this.resize);
    }
}

