/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.set.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import net.jcip.annotations.Immutable;
import org.eclipse.collections.api.LazyLongIterable;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.bag.primitive.MutableLongBag;
import org.eclipse.collections.api.block.function.primitive.LongToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectLongToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.LongPredicate;
import org.eclipse.collections.api.block.procedure.primitive.LongIntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.api.set.primitive.ImmutableLongSet;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.bag.mutable.primitive.LongHashBag;
import org.eclipse.collections.impl.factory.primitive.LongSets;
import org.eclipse.collections.impl.iterator.UnmodifiableLongIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyLongIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.LongArrayList;
import org.eclipse.collections.impl.set.mutable.UnifiedSet;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
final class ImmutableLongSingletonSet
implements ImmutableLongSet,
Serializable {
    private static final long serialVersionUID = 1L;
    private final long element;

    ImmutableLongSingletonSet(long element) {
        this.element = element;
    }

    public ImmutableLongSet newWith(long element) {
        return LongSets.immutable.with(new long[]{this.element, element});
    }

    public ImmutableLongSet newWithout(long element) {
        return this.element == element ? LongSets.immutable.with() : this;
    }

    public ImmutableLongSet newWithAll(LongIterable elements) {
        return LongHashSet.newSet(elements).with(this.element).toImmutable();
    }

    public ImmutableLongSet newWithoutAll(LongIterable elements) {
        return elements.contains(this.element) ? LongSets.immutable.with() : this;
    }

    public int size() {
        return 1;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean notEmpty() {
        return true;
    }

    public boolean contains(long value) {
        return this.element == value;
    }

    public boolean containsAll(LongIterable source) {
        LongIterator iterator = source.longIterator();
        while (iterator.hasNext()) {
            if (this.element == iterator.next()) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(long ... source) {
        for (long value : source) {
            if (this.element == value) continue;
            return false;
        }
        return true;
    }

    public void forEach(LongProcedure procedure) {
        this.each(procedure);
    }

    public void each(LongProcedure procedure) {
        procedure.value(this.element);
    }

    public ImmutableLongSet select(LongPredicate predicate) {
        return predicate.accept(this.element) ? LongHashSet.newSetWith(this.element).toImmutable() : new LongHashSet().toImmutable();
    }

    public ImmutableLongSet reject(LongPredicate predicate) {
        return predicate.accept(this.element) ? new LongHashSet().toImmutable() : LongHashSet.newSetWith(this.element).toImmutable();
    }

    public <V> ImmutableSet<V> collect(LongToObjectFunction<? extends V> function) {
        return UnifiedSet.newSetWith(function.valueOf(this.element)).toImmutable();
    }

    public MutableLongList toList() {
        return LongArrayList.newListWith(this.element);
    }

    public int sizeDistinct() {
        return 1;
    }

    public int occurrencesOf(long item) {
        return this.element == item ? 1 : 0;
    }

    public void forEachWithOccurrences(LongIntProcedure longIntProcedure) {
        longIntProcedure.value(this.element, 1);
    }

    public long detectIfNone(LongPredicate predicate, long ifNone) {
        return predicate.accept(this.element) ? this.element : ifNone;
    }

    public int count(LongPredicate predicate) {
        return predicate.accept(this.element) ? 1 : 0;
    }

    public boolean anySatisfy(LongPredicate predicate) {
        return predicate.accept(this.element);
    }

    public long sum() {
        return this.element;
    }

    public long min() {
        return this.element;
    }

    public long max() {
        return this.element;
    }

    public long maxIfEmpty(long defaultValue) {
        return this.element;
    }

    public long minIfEmpty(long defaultValue) {
        return this.element;
    }

    public double average() {
        return this.element;
    }

    public double median() {
        return this.element;
    }

    public long[] toSortedArray() {
        return new long[]{this.element};
    }

    public MutableLongList toSortedList() {
        return LongArrayList.newListWith(this.element);
    }

    public boolean noneSatisfy(LongPredicate predicate) {
        return !predicate.accept(this.element);
    }

    public boolean allSatisfy(LongPredicate predicate) {
        return predicate.accept(this.element);
    }

    public <T> T injectInto(T injectedValue, ObjectLongToObjectFunction<? super T, ? extends T> function) {
        return (T)function.valueOf(injectedValue, this.element);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LongSet)) {
            return false;
        }
        LongSet set = (LongSet)obj;
        if (set.size() != 1) {
            return false;
        }
        return set.contains(this.element);
    }

    public int hashCode() {
        return (int)(this.element ^ this.element >>> 32);
    }

    public MutableLongSet toSet() {
        return LongHashSet.newSetWith(this.element);
    }

    public MutableLongBag toBag() {
        return LongHashBag.newBagWith(this.element);
    }

    public LongSet freeze() {
        return this;
    }

    public ImmutableLongSet toImmutable() {
        return this;
    }

    public LazyLongIterable asLazy() {
        return new LazyLongIterableAdapter((LongIterable)this);
    }

    public long[] toArray() {
        return new long[]{this.element};
    }

    public String toString() {
        return '[' + this.makeString() + ']';
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(String.valueOf(this.element));
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public LongIterator longIterator() {
        return new UnmodifiableLongIterator((LongIterator)LongHashSet.newSetWith(this.element).longIterator());
    }
}

