/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.bag.immutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.eclipse.collections.api.LazyLongIterable;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.bag.primitive.ImmutableLongBag;
import org.eclipse.collections.api.bag.primitive.LongBag;
import org.eclipse.collections.api.bag.primitive.MutableLongBag;
import org.eclipse.collections.api.block.function.primitive.LongToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectLongToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.LongPredicate;
import org.eclipse.collections.api.block.procedure.primitive.LongIntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.bag.mutable.primitive.LongHashBag;
import org.eclipse.collections.impl.block.procedure.checked.primitive.CheckedLongIntProcedure;
import org.eclipse.collections.impl.iterator.UnmodifiableLongIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ImmutableLongHashBag
implements ImmutableLongBag,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableLongBag delegate;

    private ImmutableLongHashBag(long[] newElements) {
        this.checkOptimizedSize(newElements.length);
        this.delegate = LongHashBag.newBagWith(newElements);
    }

    private void checkOptimizedSize(int length) {
        if (length <= 1) {
            throw new IllegalArgumentException("Use LongBags.immutable.with() to instantiate an optimized collection");
        }
    }

    public static ImmutableLongHashBag newBagWith(long ... elements) {
        return new ImmutableLongHashBag(elements);
    }

    public ImmutableLongBag newWith(long element) {
        return LongHashBag.newBag((LongBag)this.delegate).with(element).toImmutable();
    }

    public ImmutableLongBag newWithout(long element) {
        LongHashBag hashBag = LongHashBag.newBag((LongBag)this.delegate);
        hashBag.remove(element);
        return hashBag.toImmutable();
    }

    public ImmutableLongBag newWithAll(LongIterable elements) {
        LongHashBag bag = LongHashBag.newBag((LongBag)this.delegate);
        bag.addAll(elements);
        return bag.toImmutable();
    }

    public ImmutableLongBag newWithoutAll(LongIterable elements) {
        LongHashBag bag = LongHashBag.newBag((LongBag)this.delegate);
        bag.removeAll(elements);
        return bag.toImmutable();
    }

    public int size() {
        return this.delegate.size();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public boolean notEmpty() {
        return this.delegate.notEmpty();
    }

    public boolean contains(long value) {
        return this.delegate.contains(value);
    }

    public boolean containsAll(LongIterable source) {
        return this.delegate.containsAll(source);
    }

    public boolean containsAll(long ... elements) {
        return this.delegate.containsAll(elements);
    }

    public void forEach(LongProcedure procedure) {
        this.each(procedure);
    }

    public void each(LongProcedure procedure) {
        this.delegate.forEach(procedure);
    }

    public ImmutableLongBag select(LongPredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableLongBag reject(LongPredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    public <V> ImmutableBag<V> collect(LongToObjectFunction<? extends V> function) {
        return this.delegate.collect(function).toImmutable();
    }

    public MutableLongList toList() {
        return this.delegate.toList();
    }

    public int sizeDistinct() {
        return this.delegate.sizeDistinct();
    }

    public int occurrencesOf(long item) {
        return this.delegate.occurrencesOf(item);
    }

    public void forEachWithOccurrences(LongIntProcedure longIntProcedure) {
        this.delegate.forEachWithOccurrences(longIntProcedure);
    }

    public long detectIfNone(LongPredicate predicate, long ifNone) {
        return this.delegate.detectIfNone(predicate, ifNone);
    }

    public int count(LongPredicate predicate) {
        return this.delegate.count(predicate);
    }

    public boolean anySatisfy(LongPredicate predicate) {
        return this.delegate.anySatisfy(predicate);
    }

    public long sum() {
        return this.delegate.sum();
    }

    public long min() {
        return this.delegate.min();
    }

    public long max() {
        return this.delegate.max();
    }

    public long maxIfEmpty(long defaultValue) {
        return this.delegate.maxIfEmpty(defaultValue);
    }

    public long minIfEmpty(long defaultValue) {
        return this.delegate.minIfEmpty(defaultValue);
    }

    public double average() {
        return this.delegate.average();
    }

    public double median() {
        return this.delegate.median();
    }

    public long[] toSortedArray() {
        return this.delegate.toSortedArray();
    }

    public MutableLongList toSortedList() {
        return this.delegate.toSortedList();
    }

    public boolean noneSatisfy(LongPredicate predicate) {
        return this.delegate.noneSatisfy(predicate);
    }

    public boolean allSatisfy(LongPredicate predicate) {
        return this.delegate.allSatisfy(predicate);
    }

    public <T> T injectInto(T injectedValue, ObjectLongToObjectFunction<? super T, ? extends T> function) {
        return (T)this.delegate.injectInto(injectedValue, function);
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public MutableLongSet toSet() {
        return this.delegate.toSet();
    }

    public MutableLongBag toBag() {
        return this.delegate.toBag();
    }

    public ImmutableLongBag toImmutable() {
        return this;
    }

    public LazyLongIterable asLazy() {
        return this.delegate.asLazy();
    }

    public long[] toArray() {
        return this.delegate.toArray();
    }

    public String toString() {
        return this.delegate.toString();
    }

    public String makeString() {
        return this.delegate.makeString();
    }

    public String makeString(String separator) {
        return this.delegate.makeString(separator);
    }

    public String makeString(String start, String separator, String end) {
        return this.delegate.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable) {
        this.delegate.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator) {
        this.delegate.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.delegate.appendString(appendable, start, separator, end);
    }

    public LongIterator longIterator() {
        return new UnmodifiableLongIterator((LongIterator)this.delegate.longIterator());
    }

    private Object writeReplace() {
        return new ImmutableLongBagSerializationProxy((LongBag)this);
    }

    protected static class ImmutableLongBagSerializationProxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private LongBag bag;

        public ImmutableLongBagSerializationProxy() {
        }

        protected ImmutableLongBagSerializationProxy(LongBag bag) {
            this.bag = bag;
        }

        public void writeExternal(final ObjectOutput out) throws IOException {
            out.writeInt(this.bag.sizeDistinct());
            try {
                this.bag.forEachWithOccurrences((LongIntProcedure)new CheckedLongIntProcedure(){

                    public void safeValue(long item, int count) throws IOException {
                        out.writeLong(item);
                        out.writeInt(count);
                    }
                });
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw e;
            }
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int size = in.readInt();
            LongHashBag deserializedBag = new LongHashBag();
            for (int i = 0; i < size; ++i) {
                deserializedBag.addOccurrences(in.readLong(), in.readInt());
            }
            this.bag = deserializedBag;
        }

        protected Object readResolve() {
            return this.bag.toImmutable();
        }
    }
}

