/*
 * Copyright (c) 2015 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.impl.stack.mutable.primitive;

import java.io.Serializable;

import org.eclipse.collections.api.ShortIterable;
import org.eclipse.collections.api.LazyShortIterable;
import org.eclipse.collections.api.bag.primitive.MutableShortBag;
import org.eclipse.collections.api.block.function.primitive.ShortToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectShortToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.ShortPredicate;
import org.eclipse.collections.api.block.procedure.primitive.ShortProcedure;
import org.eclipse.collections.api.iterator.ShortIterator;
import org.eclipse.collections.api.list.primitive.ShortList;
import org.eclipse.collections.api.list.primitive.MutableShortList;
import org.eclipse.collections.api.set.primitive.MutableShortSet;
import org.eclipse.collections.api.stack.MutableStack;
import org.eclipse.collections.api.stack.primitive.ImmutableShortStack;
import org.eclipse.collections.api.stack.primitive.MutableShortStack;
import org.eclipse.collections.impl.factory.primitive.ShortStacks;
import org.eclipse.collections.impl.iterator.UnmodifiableShortIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyShortIterableAdapter;
import net.jcip.annotations.NotThreadSafe;

/**
 * This file was automatically generated from template file unmodifiablePrimitiveStack.stg.
 *
 * @since 3.1.
 */
@NotThreadSafe
public final class UnmodifiableShortStack
        implements MutableShortStack, Serializable
{
    private static final long serialVersionUID = 1L;

    private final MutableShortStack stack;

    UnmodifiableShortStack(MutableShortStack stack)
    {
        this.stack = stack;
    }

    public void push(short item)
    {
        throw new UnsupportedOperationException("Cannot call push() on " + this.getClass().getSimpleName());
    }

    public short pop()
    {
        throw new UnsupportedOperationException("Cannot call pop() on " + this.getClass().getSimpleName());
    }

    public ShortList pop(int count)
    {
        throw new UnsupportedOperationException("Cannot call pop() on " + this.getClass().getSimpleName());
    }

    public short peek()
    {
        return this.stack.peek();
    }

    public ShortList peek(int count)
    {
        return this.stack.peek(count);
    }

    public short peekAt(int index)
    {
        return this.stack.peekAt(index);
    }

    public int size()
    {
        return this.stack.size();
    }

    public boolean isEmpty()
    {
        return this.stack.isEmpty();
    }

    public boolean notEmpty()
    {
        return this.stack.notEmpty();
    }

    public void clear()
    {
        throw new UnsupportedOperationException("Cannot call clear() on " + this.getClass().getSimpleName());
    }

    public boolean contains(short value)
    {
        return this.stack.contains(value);
    }

    public boolean containsAll(short... source)
    {
        return this.stack.containsAll(source);
    }

    public boolean containsAll(ShortIterable source)
    {
        return this.stack.containsAll(source);
    }

    public ShortIterator shortIterator()
    {
        return new UnmodifiableShortIterator(this.stack.shortIterator());
    }

    public void forEach(ShortProcedure procedure)
    {
        this.each(procedure);
    }

    /**
     * @since 7.0.
     */
    public void each(ShortProcedure procedure)
    {
        this.stack.forEach(procedure);
    }

    public int count(ShortPredicate predicate)
    {
        return this.stack.count(predicate);
    }

    public boolean anySatisfy(ShortPredicate predicate)
    {
        return this.stack.anySatisfy(predicate);
    }

    public boolean allSatisfy(ShortPredicate predicate)
    {
        return this.stack.allSatisfy(predicate);
    }

    public boolean noneSatisfy(ShortPredicate predicate)
    {
        return this.stack.noneSatisfy(predicate);
    }

    public short detectIfNone(ShortPredicate predicate, short ifNone)
    {
        return this.stack.detectIfNone(predicate, ifNone);
    }

    public MutableShortStack select(ShortPredicate predicate)
    {
        return this.stack.select(predicate);
    }

    public MutableShortStack reject(ShortPredicate predicate)
    {
        return this.stack.reject(predicate);
    }

    public <V> MutableStack<V> collect(ShortToObjectFunction<? extends V> function)
    {
        return this.stack.collect(function);
    }

    public long sum()
    {
        return this.stack.sum();
    }

    public short max()
    {
        return this.stack.max();
    }

    public short min()
    {
        return this.stack.min();
    }

    public short minIfEmpty(short defaultValue)
    {
        return this.stack.minIfEmpty(defaultValue);
    }

    public short maxIfEmpty(short defaultValue)
    {
        return this.stack.maxIfEmpty(defaultValue);
    }

    public double average()
    {
        return this.stack.average();
    }

    public double median()
    {
        return this.stack.median();
    }

    public MutableShortList toSortedList()
    {
        return this.stack.toSortedList();
    }

    public short[] toSortedArray()
    {
        return this.stack.toSortedArray();
    }

    public short[] toArray()
    {
        return this.stack.toArray();
    }

    @Override
    public String toString()
    {
        return this.stack.toString();
    }

    public String makeString()
    {
        return this.stack.makeString();
    }

    public String makeString(String separator)
    {
        return this.stack.makeString(separator);
    }

    public String makeString(String start, String separator, String end)
    {
        return this.stack.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable)
    {
        this.stack.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator)
    {
        this.stack.appendString(appendable, separator);
    }

    public void appendString(
            Appendable appendable,
            String start,
            String separator,
            String end)
    {
        this.stack.appendString(appendable, start, separator, end);
    }

    public MutableShortList toList()
    {
        return this.stack.toList();
    }

    public MutableShortSet toSet()
    {
        return this.stack.toSet();
    }

    public MutableShortBag toBag()
    {
        return this.stack.toBag();
    }

    @Override
    public boolean equals(Object otherStack)
    {
        return this.stack.equals(otherStack);
    }

    @Override
    public int hashCode()
    {
        return this.stack.hashCode();
    }

    public LazyShortIterable asLazy()
    {
        return new LazyShortIterableAdapter(this);
    }

    public MutableShortStack asUnmodifiable()
    {
        return this;
    }

    public MutableShortStack asSynchronized()
    {
        return new SynchronizedShortStack(this);
    }

    public ImmutableShortStack toImmutable()
    {
        return ShortStacks.immutable.withAllReversed(this);
    }

    public <T> T injectInto(T injectedValue, ObjectShortToObjectFunction<? super T, ? extends T> function)
    {
        return this.stack.injectInto(injectedValue, function);
    }
}
