/*
 * Copyright (c) 2015 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.impl.map.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;

import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.LazyLongIterable;
import org.eclipse.collections.api.LazyIntIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.primitive.MutableLongBag;
import org.eclipse.collections.api.block.function.primitive.LongToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectLongToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.LongPredicate;
import org.eclipse.collections.api.block.predicate.primitive.IntLongPredicate;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.block.procedure.primitive.IntLongProcedure;
import org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import org.eclipse.collections.api.collection.ImmutableCollection;
import org.eclipse.collections.api.collection.primitive.ImmutableLongCollection;
import org.eclipse.collections.api.collection.primitive.MutableLongCollection;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.api.map.primitive.IntLongMap;
import org.eclipse.collections.api.map.primitive.ImmutableIntLongMap;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.api.tuple.primitive.IntLongPair;
import org.eclipse.collections.impl.bag.mutable.primitive.LongHashBag;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableLongCollection;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.primitive.IntLongMaps;
import org.eclipse.collections.impl.factory.primitive.IntLists;
import org.eclipse.collections.impl.iterator.UnmodifiableLongIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyLongIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.LongArrayList;
import org.eclipse.collections.impl.map.mutable.primitive.IntLongHashMap;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.IntHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableIntSet;
import org.eclipse.collections.impl.tuple.primitive.PrimitiveTuples;

/**
 * ImmutableIntLongSingletonMap is an optimization for {@link ImmutableIntLongMap} of size 1.
 * This file was automatically generated from template file immutablePrimitivePrimitiveSingletonMap.stg.
 * @since 4.0.
 */
final class ImmutableIntLongSingletonMap implements ImmutableIntLongMap, Serializable
{
    private static final long serialVersionUID = 1L;
    private static final long EMPTY_VALUE = 0L;
    private final int key1;
    private final long value1;

    ImmutableIntLongSingletonMap(int key1, long value1)
    {
        this.key1 = key1;
        this.value1 = value1;
    }

    public long get(int key)
    {
        return this.getIfAbsent(key, EMPTY_VALUE);
    }

    public long getIfAbsent(int key, long ifAbsent)
    {
        return this.key1 == key ? this.value1 : ifAbsent;
    }

    public long getOrThrow(int key)
    {
        if (this.key1 == key)
        {
            return this.value1;
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public boolean containsKey(int key)
    {
        return this.key1 == key;
    }

    public boolean containsValue(long value)
    {
        return this.value1 == value;
    }

    public void forEachValue(LongProcedure procedure)
    {
        procedure.value(this.value1);
    }

    public void forEachKey(IntProcedure procedure)
    {
        procedure.value(this.key1);
    }

    public void forEachKeyValue(IntLongProcedure procedure)
    {
        procedure.value(this.key1, this.value1);
    }

    public LazyIntIterable keysView()
    {
        return IntLists.immutable.of(this.key1).asLazy();
    }

    public RichIterable<IntLongPair> keyValuesView()
    {
        return Lists.immutable.of(PrimitiveTuples.pair(this.key1, this.value1)).asLazy();
    }

    public ImmutableIntLongMap select(IntLongPredicate predicate)
    {
        return predicate.accept(this.key1, this.value1) ? IntLongHashMap.newWithKeysValues(this.key1, this.value1).toImmutable()
                : new IntLongHashMap().toImmutable();
    }

    public ImmutableIntLongMap reject(IntLongPredicate predicate)
    {
        return predicate.accept(this.key1, this.value1) ? new IntLongHashMap().toImmutable()
                : IntLongHashMap.newWithKeysValues(this.key1, this.value1).toImmutable();
    }

    public <T> T injectInto(T injectedValue, ObjectLongToObjectFunction<? super T, ? extends T> function)
    {
        return function.valueOf(injectedValue, this.value1);
    }

    public ImmutableIntLongMap toImmutable()
    {
        return this;
    }

    public LongIterator longIterator()
    {
        return new UnmodifiableLongIterator(IntLongHashMap.newWithKeysValues(this.key1, this.value1).longIterator());
    }

    public void forEach(LongProcedure procedure)
    {
        this.each(procedure);
    }

    /**
     * @since 7.0.
     */
    public void each(LongProcedure procedure)
    {
        procedure.value(this.value1);
    }

    public int count(LongPredicate predicate)
    {
        return predicate.accept(this.value1) ? 1 : 0;
    }

    public long sum()
    {
        return this.value1;
    }

    public long min()
    {
        return this.value1;
    }

    public long max()
    {
        return this.value1;
    }

    public long maxIfEmpty(long defaultValue)
    {
        return this.value1;
    }

    public long minIfEmpty(long defaultValue)
    {
        return this.value1;
    }

    public double average()
    {
        return this.value1;
    }

    public double median()
    {
        return this.value1;
    }

    public long[] toSortedArray()
    {
        return new long[]{this.value1};
    }

    public MutableLongList toSortedList()
    {
        return LongArrayList.newListWith(this.value1);
    }

    public boolean anySatisfy(LongPredicate predicate)
    {
        return predicate.accept(this.value1);
    }

    public boolean allSatisfy(LongPredicate predicate)
    {
        return predicate.accept(this.value1);
    }

    public boolean noneSatisfy(LongPredicate predicate)
    {
        return !predicate.accept(this.value1);
    }

    public ImmutableLongCollection select(LongPredicate predicate)
    {
        return predicate.accept(this.value1) ? LongArrayList.newListWith(this.value1).toImmutable() : new LongArrayList().toImmutable();
    }

    public ImmutableLongCollection reject(LongPredicate predicate)
    {
        return predicate.accept(this.value1) ? new LongArrayList().toImmutable() : LongArrayList.newListWith(this.value1).toImmutable();
    }

    public long detectIfNone(LongPredicate predicate, long ifNone)
    {
        return predicate.accept(this.value1) ? this.value1 : ifNone;
    }

    public <V> ImmutableCollection<V> collect(LongToObjectFunction<? extends V> function)
    {
        return Lists.immutable.of(function.valueOf(this.value1));
    }

    public long[] toArray()
    {
        return new long[]{this.value1};
    }

    public boolean contains(long value)
    {
        return this.value1 == value;
    }

    public boolean containsAll(long... source)
    {
        for (long value : source)
        {
            if (this.value1 != value)
            {
                return false;
            }
        }
        return true;
    }

    public boolean containsAll(LongIterable source)
    {
        for (LongIterator iterator = source.longIterator(); iterator.hasNext(); )
        {
            if (this.value1 != iterator.next())
            {
                return false;
            }
        }
        return true;
    }

    public MutableLongList toList()
    {
        return LongArrayList.newListWith(this.value1);
    }

    public MutableLongSet toSet()
    {
        return LongHashSet.newSetWith(this.value1);
    }

    public MutableLongBag toBag()
    {
        return LongHashBag.newBagWith(this.value1);
    }

    public LazyLongIterable asLazy()
    {
        return new LazyLongIterableAdapter(this);
    }

    public ImmutableIntLongMap newWithKeyValue(int key, long value)
    {
        return IntLongMaps.immutable.withAll(IntLongHashMap.newWithKeysValues(this.key1, this.value1, key, value));
    }

    public ImmutableIntLongMap newWithoutKey(int key)
    {
        return this.key1 == key ? IntLongMaps.immutable.with() : this;
    }

    public ImmutableIntLongMap newWithoutAllKeys(IntIterable keys)
    {
        return keys.contains(this.key1) ? IntLongMaps.immutable.with() : this;
    }

    public int size()
    {
        return 1;
    }

    public boolean isEmpty()
    {
        return false;
    }

    public boolean notEmpty()
    {
        return true;
    }

    public MutableIntSet keySet()
    {
        return UnmodifiableIntSet.of(IntHashSet.newSetWith(this.key1));
    }

    public MutableLongCollection values()
    {
        return UnmodifiableLongCollection.of(LongArrayList.newListWith(this.value1));
    }

    @Override
    public boolean equals(Object obj)
    {
        if (obj == this)
        {
            return true;
        }
        if (!(obj instanceof IntLongMap))
        {
            return false;
        }
        IntLongMap map = (IntLongMap) obj;
        if (map.size() != 1)
        {
            return false;
        }
        return map.containsKey(this.key1) && this.value1 == map.getOrThrow(this.key1);
    }

    @Override
    public int hashCode()
    {
        return this.key1 ^ (int) (this.value1 ^ this.value1 >>> 32);
    }

    @Override
    public String toString()
    {
        return "{" + this.key1 + "=" + this.value1 + "}";
    }

    public String makeString()
    {
        return this.makeString(", ");
    }

    public String makeString(String separator)
    {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end)
    {
        Appendable stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return stringBuilder.toString();
    }

    public void appendString(Appendable appendable)
    {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator)
    {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        try
        {
            appendable.append(start);
            appendable.append(String.valueOf(this.value1));
            appendable.append(end);
        }
        catch (IOException e)
        {
            throw new RuntimeException(e);
        }
    }
}
