/*
 * Copyright (c) 2015 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.impl.list.mutable.primitive;

import org.eclipse.collections.api.ShortIterable;
import org.eclipse.collections.api.LazyShortIterable;
import org.eclipse.collections.api.block.function.primitive.ShortToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectShortIntToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.ShortPredicate;
import org.eclipse.collections.api.block.procedure.primitive.ShortIntProcedure;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.list.primitive.ShortList;
import org.eclipse.collections.api.list.primitive.ImmutableShortList;
import org.eclipse.collections.api.list.primitive.MutableShortList;
import org.eclipse.collections.impl.collection.mutable.primitive.AbstractUnmodifiableShortCollection;
import org.eclipse.collections.impl.factory.primitive.ShortLists;
import org.eclipse.collections.impl.lazy.primitive.LazyShortIterableAdapter;
import org.eclipse.collections.impl.lazy.primitive.ReverseShortIterable;
import net.jcip.annotations.NotThreadSafe;

/**
 * This file was automatically generated from template file unmodifiablePrimitiveList.stg.
 *
 * @since 3.1.
 */
@NotThreadSafe
public final class UnmodifiableShortList
        extends AbstractUnmodifiableShortCollection
        implements MutableShortList
{
    private static final long serialVersionUID = 1L;

    UnmodifiableShortList(MutableShortList list)
    {
        super(list);
    }

    private MutableShortList getMutableShortList()
    {
        return (MutableShortList) this.getShortCollection();
    }

    public short get(int index)
    {
        return this.getMutableShortList().get(index);
    }

    public short getFirst()
    {
        return this.getMutableShortList().getFirst();
    }

    public short getLast()
    {
        return this.getMutableShortList().getLast();
    }

    public int indexOf(short value)
    {
        return this.getMutableShortList().indexOf(value);
    }

    public int lastIndexOf(short value)
    {
        return this.getMutableShortList().lastIndexOf(value);
    }

    public void addAtIndex(int index, short element)
    {
        throw new UnsupportedOperationException("Cannot call addAtIndex() on " + this.getClass().getSimpleName());
    }

    public boolean addAllAtIndex(int index, short... source)
    {
        throw new UnsupportedOperationException("Cannot call addAllAtIndex() on " + this.getClass().getSimpleName());
    }

    public boolean addAllAtIndex(int index, ShortIterable source)
    {
        throw new UnsupportedOperationException("Cannot call addAllAtIndex() on " + this.getClass().getSimpleName());
    }

    public short removeAtIndex(int index)
    {
        throw new UnsupportedOperationException("Cannot call removeAtIndex() on " + this.getClass().getSimpleName());
    }

    public short set(int index, short element)
    {
        throw new UnsupportedOperationException("Cannot call set() on " + this.getClass().getSimpleName());
    }

    @Override
    public UnmodifiableShortList with(short element)
    {
        throw new UnsupportedOperationException("Cannot call with() on " + this.getClass().getSimpleName());
    }

    @Override
    public UnmodifiableShortList without(short element)
    {
        throw new UnsupportedOperationException("Cannot call without() on " + this.getClass().getSimpleName());
    }

    @Override
    public UnmodifiableShortList withAll(ShortIterable elements)
    {
        throw new UnsupportedOperationException("Cannot call withAll() on " + this.getClass().getSimpleName());
    }

    @Override
    public UnmodifiableShortList withoutAll(ShortIterable elements)
    {
        throw new UnsupportedOperationException("Cannot call withoutAll() on " + this.getClass().getSimpleName());
    }

    @Override
    public MutableShortList select(ShortPredicate predicate)
    {
        return this.getMutableShortList().select(predicate);
    }

    @Override
    public MutableShortList reject(ShortPredicate predicate)
    {
        return this.getMutableShortList().reject(predicate);
    }

    @Override
    public <V> MutableList<V> collect(ShortToObjectFunction<? extends V> function)
    {
        return this.getMutableShortList().collect(function);
    }

    public MutableShortList sortThis()
    {
        throw new UnsupportedOperationException("Cannot call sortThis() on " + this.getClass().getSimpleName());
    }

    public int binarySearch(short value)
    {
        return this.getMutableShortList().binarySearch(value);
    }

    public long dotProduct(ShortList list)
    {
        return this.getMutableShortList().dotProduct(list);
    }

    @Override
    public boolean equals(Object otherList)
    {
        return this.getMutableShortList().equals(otherList);
    }

    @Override
    public int hashCode()
    {
        return this.getMutableShortList().hashCode();
    }

    @Override
    public MutableShortList asUnmodifiable()
    {
        return this;
    }

    @Override
    public MutableShortList asSynchronized()
    {
        return new SynchronizedShortList(this);
    }

    @Override
    public ImmutableShortList toImmutable()
    {
        int size = this.size();
        if (size == 0)
        {
            return ShortLists.immutable.with();
        }
        if (size == 1)
        {
            return ShortLists.immutable.with(this.getFirst());
        }
        return ShortLists.immutable.with(this.toArray());
    }

    public MutableShortList reverseThis()
    {
        throw new UnsupportedOperationException("Cannot call reverseThis() on " + this.getClass().getSimpleName());
    }

    public MutableShortList toReversed()
    {
        return this.getMutableShortList().toReversed();
    }

    public void forEachWithIndex(ShortIntProcedure procedure)
    {
        this.getMutableShortList().forEachWithIndex(procedure);
    }

    public LazyShortIterable asReversed()
    {
        return ReverseShortIterable.adapt(this);
    }

    public <T> T injectIntoWithIndex(T injectedValue, ObjectShortIntToObjectFunction<? super T, ? extends T> function)
    {
        return this.getMutableShortList().injectIntoWithIndex(injectedValue, function);
    }

    /**
     * @since 6.0.
     */
    public MutableShortList distinct()
    {
        return this.getMutableShortList().distinct();
    }

    public MutableShortList subList(int fromIndex, int toIndex)
    {
        throw new UnsupportedOperationException("subList not yet implemented!");
    }
}
