/*
 * Copyright (c) 2015 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.api.map.primitive;

import org.eclipse.collections.api.DoubleIterable;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.function.primitive.BooleanFunction;
import org.eclipse.collections.api.block.function.primitive.ByteFunction;
import org.eclipse.collections.api.block.function.primitive.CharFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.block.function.primitive.FloatFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.function.primitive.LongFunction;
import org.eclipse.collections.api.block.function.primitive.ShortFunction;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.predicate.primitive.DoubleObjectPredicate;
import org.eclipse.collections.api.collection.ImmutableCollection;
import org.eclipse.collections.api.collection.primitive.ImmutableBooleanCollection;
import org.eclipse.collections.api.collection.primitive.ImmutableByteCollection;
import org.eclipse.collections.api.collection.primitive.ImmutableCharCollection;
import org.eclipse.collections.api.collection.primitive.ImmutableDoubleCollection;
import org.eclipse.collections.api.collection.primitive.ImmutableFloatCollection;
import org.eclipse.collections.api.collection.primitive.ImmutableIntCollection;
import org.eclipse.collections.api.collection.primitive.ImmutableLongCollection;
import org.eclipse.collections.api.collection.primitive.ImmutableShortCollection;

/**
 * This file was automatically generated from template file immutablePrimitiveObjectMap.stg.
 *
 * @since 3.0.
 */
public interface ImmutableDoubleObjectMap<V> extends DoubleObjectMap<V>
{
    ImmutableDoubleObjectMap<V> tap(Procedure<? super V> procedure);

    ImmutableDoubleObjectMap<V> select(DoubleObjectPredicate<? super V> predicate);

    ImmutableDoubleObjectMap<V> reject(DoubleObjectPredicate<? super V> predicate);

    ImmutableCollection<V> select(Predicate<? super V> predicate);

    <P> ImmutableCollection<V> selectWith(Predicate2<? super V, ? super P> predicate, P parameter);

    ImmutableCollection<V> reject(Predicate<? super V> predicate);

    <VV> ImmutableCollection<VV> collect(Function<? super V, ? extends VV> function);

    ImmutableBooleanCollection collectBoolean(BooleanFunction<? super V> booleanFunction);

    ImmutableByteCollection collectByte(ByteFunction<? super V> byteFunction);

    ImmutableCharCollection collectChar(CharFunction<? super V> charFunction);

    ImmutableDoubleCollection collectDouble(DoubleFunction<? super V> doubleFunction);

    ImmutableFloatCollection collectFloat(FloatFunction<? super V> floatFunction);

    ImmutableIntCollection collectInt(IntFunction<? super V> intFunction);

    ImmutableLongCollection collectLong(LongFunction<? super V> longFunction);

    ImmutableShortCollection collectShort(ShortFunction<? super V> shortFunction);

    <P, VV> ImmutableCollection<VV> collectWith(Function2<? super V, ? super P, ? extends VV> function, P parameter);

    ImmutableDoubleObjectMap<V> newWithKeyValue(double key, V value);

    ImmutableDoubleObjectMap<V> newWithoutKey(double key);

    ImmutableDoubleObjectMap<V> newWithoutAllKeys(DoubleIterable keys);
}
