/*
 * Copyright (c) 2015 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.api.factory.map.primitive;

import org.eclipse.collections.api.map.primitive.ImmutableObjectLongMap;
import org.eclipse.collections.api.map.primitive.ObjectLongMap;

/**
 * A factory which creates instances of type {@link ImmutableObjectLongMap}.
 * This file was automatically generated from template file immutableObjectPrimitiveMapFactory.stg.
 *
 * @since 4.0.
 */
public interface ImmutableObjectLongMapFactory
{
    /**
     * @since 6.0
     */
    <K> ImmutableObjectLongMap<K> empty();

    /**
     * Same as {@link #empty()}.
     */
    <K> ImmutableObjectLongMap<K> of();

    /**
     * Same as {@link #empty()}.
     */
    <K> ImmutableObjectLongMap<K> with();

    /**
     * Same as {@link #with(Object, long)}.
     */
    <K> ImmutableObjectLongMap<K> of(K key, long value);

    <K> ImmutableObjectLongMap<K> with(K key, long value);

    /**
     * Same as {@link #withAll(ObjectLongMap)}.
     */
    <K> ImmutableObjectLongMap<K> ofAll(ObjectLongMap<? extends K> map);

    <K> ImmutableObjectLongMap<K> withAll(ObjectLongMap<? extends K> map);
}
