/*
 * Decompiled with CFR 0.152.
 */
package systems.uom.ucum.spi;

import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.measure.format.QuantityFormat;
import javax.measure.format.UnitFormat;
import javax.measure.spi.FormatService;
import systems.uom.ucum.format.UCUMFormat;
import tech.units.indriya.format.EBNFUnitFormat;
import tech.units.indriya.format.FormatBehavior;
import tech.units.indriya.format.NumberDelimiterQuantityFormat;
import tech.units.indriya.format.SimpleQuantityFormat;

public final class UCUMFormatService
implements FormatService {
    private static final String UNIT_FORMAT_KEY_CASE_SENSITIVE = "UCUM_CS";
    private static final String UNIT_FORMAT_KEY_CASE_INSENSITIVE = "UCUM_CI";
    private static final String UNIT_FORMAT_KEY_PRINT = "UCUM_PRINT";
    private static final String DEFAULT_UNIT_FORMAT = "UCUM_CS";
    private final Map<String, UnitFormat> unitFormats = new HashMap<String, UnitFormat>();
    private final Map<String, String> unitFormatAliases = new HashMap<String, String>();
    private static final String DEFAULT_QUANTITY_FORMAT = "Simple";
    private static final NumberDelimiterQuantityFormat EBNF_QUANTITY_FORMAT = new NumberDelimiterQuantityFormat.Builder().setNumberFormat(NumberFormat.getInstance(Locale.ROOT)).setUnitFormat((UnitFormat)EBNFUnitFormat.getInstance()).build();
    private final Map<String, QuantityFormat> quantityFormats = new HashMap<String, QuantityFormat>();

    public UCUMFormatService() {
        this.quantityFormats.put(DEFAULT_QUANTITY_FORMAT, (QuantityFormat)SimpleQuantityFormat.getInstance());
        this.quantityFormats.put("NumberDelimiter", (QuantityFormat)NumberDelimiterQuantityFormat.getInstance());
        this.quantityFormats.put("EBNF", (QuantityFormat)EBNF_QUANTITY_FORMAT);
        this.quantityFormats.put("Local", (QuantityFormat)NumberDelimiterQuantityFormat.getInstance((FormatBehavior)FormatBehavior.LOCALE_SENSITIVE));
        this.unitFormats.put("UCUM_CS", (UnitFormat)UCUMFormat.getInstance(UCUMFormat.Variant.CASE_SENSITIVE));
        this.unitFormats.put(UNIT_FORMAT_KEY_CASE_INSENSITIVE, (UnitFormat)UCUMFormat.getInstance(UCUMFormat.Variant.CASE_INSENSITIVE));
        this.unitFormats.put(UNIT_FORMAT_KEY_PRINT, (UnitFormat)UCUMFormat.getInstance(UCUMFormat.Variant.PRINT));
        this.unitFormatAliases.put("UCUM", "UCUM_CS");
        this.unitFormatAliases.put(UCUMFormat.Variant.CASE_SENSITIVE.name(), "UCUM_CS");
        this.unitFormatAliases.put(UCUMFormat.Variant.CASE_INSENSITIVE.name(), UNIT_FORMAT_KEY_CASE_INSENSITIVE);
        this.unitFormatAliases.put(UCUMFormat.Variant.PRINT.name(), UNIT_FORMAT_KEY_PRINT);
        this.unitFormatAliases.put("CS", "UCUM_CS");
        this.unitFormatAliases.put("C/S", "UCUM_CS");
        this.unitFormatAliases.put("CASE SENSITIVE", "UCUM_CS");
        this.unitFormatAliases.put("CI", UNIT_FORMAT_KEY_CASE_INSENSITIVE);
        this.unitFormatAliases.put("C/I", UNIT_FORMAT_KEY_CASE_INSENSITIVE);
        this.unitFormatAliases.put("CASE INSENSITIVE", UNIT_FORMAT_KEY_CASE_INSENSITIVE);
    }

    public UnitFormat getUnitFormat(String key) {
        Objects.requireNonNull(key, "Format name or alias required");
        String alias = this.unitFormatAliases.get(key.toUpperCase());
        if (alias != null && alias.length() > 0) {
            return this.unitFormats.get(alias);
        }
        return this.unitFormats.get(key.toUpperCase());
    }

    public UnitFormat getUnitFormat() {
        return this.getUnitFormat("UCUM_CS");
    }

    public Set<String> getAvailableFormatNames() {
        return this.unitFormats.keySet();
    }

    public QuantityFormat getQuantityFormat(String name) {
        return this.quantityFormats.get(name);
    }

    public QuantityFormat getQuantityFormat() {
        return this.getQuantityFormat(DEFAULT_QUANTITY_FORMAT);
    }

    public Set<String> getAvailableFormatNames(FormatService.FormatType type) {
        switch (type) {
            case QUANTITY_FORMAT: {
                return this.quantityFormats.keySet();
            }
        }
        return this.unitFormats.keySet();
    }

    public UnitFormat getUnitFormat(String name, String variant) {
        StringBuilder sb = new StringBuilder(name);
        if (null != variant && !variant.isEmpty()) {
            sb.append("_");
            sb.append(variant);
        }
        return this.getUnitFormat(sb.toString());
    }
}

