/*
 * Decompiled with CFR 0.152.
 */
package tec.uom.se.format;

import java.io.IOException;
import java.text.NumberFormat;
import java.text.ParsePosition;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.format.ParserException;
import javax.measure.format.UnitFormat;
import tec.uom.se.AbstractUnit;
import tec.uom.se.ComparableQuantity;
import tec.uom.se.format.QuantityFormat;
import tec.uom.se.quantity.Quantities;

class NumberSpaceQuantityFormat
extends QuantityFormat {
    private static final String SEPARATOR = " ";
    private final NumberFormat numberFormat;
    private final UnitFormat unitFormat;
    private static final long serialVersionUID = 1L;

    NumberSpaceQuantityFormat(NumberFormat numberFormat, UnitFormat unitFormat) {
        this.numberFormat = numberFormat;
        this.unitFormat = unitFormat;
    }

    static int getFractionDigitsCount(double d) {
        if (d >= 1.0) {
            d -= (double)((long)d);
        }
        if (d == 0.0) {
            return 0;
        }
        d *= 10.0;
        int count = 1;
        while (d - (double)((long)d) != 0.0) {
            d *= 10.0;
            ++count;
        }
        return count;
    }

    @Override
    public Appendable format(Quantity<?> quantity, Appendable dest) throws IOException {
        int fract = 0;
        if (quantity != null && quantity.getValue() != null) {
            fract = NumberSpaceQuantityFormat.getFractionDigitsCount(quantity.getValue().doubleValue());
        }
        if (fract > 1) {
            this.numberFormat.setMaximumFractionDigits(fract + 1);
        }
        dest.append(this.numberFormat.format(quantity.getValue()));
        if (quantity.getUnit().equals(AbstractUnit.ONE)) {
            return dest;
        }
        dest.append(SEPARATOR);
        return this.unitFormat.format(quantity.getUnit(), dest);
    }

    @Override
    public ComparableQuantity<?> parse(CharSequence csq, ParsePosition cursor) throws IllegalArgumentException, ParserException {
        String str = csq.toString();
        Number number = this.numberFormat.parse(str, cursor);
        if (number == null) {
            throw new IllegalArgumentException("Number cannot be parsed");
        }
        String[] parts = str.split(SEPARATOR);
        if (parts.length < 2) {
            throw new IllegalArgumentException("No Unit found");
        }
        Unit unit = this.unitFormat.parse((CharSequence)parts[1]);
        return Quantities.getQuantity(number, unit);
    }

    @Override
    ComparableQuantity<?> parse(CharSequence csq, int index) throws IllegalArgumentException, ParserException {
        return this.parse(csq, new ParsePosition(index));
    }

    @Override
    public ComparableQuantity<?> parse(CharSequence csq) throws IllegalArgumentException, ParserException {
        return this.parse(csq, 0);
    }
}

