/*
 * Decompiled with CFR 0.152.
 */
package tec.uom.se.quantity;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Objects;
import javax.measure.Quantity;
import javax.measure.Unit;
import tec.uom.se.AbstractQuantity;
import tec.uom.se.ComparableQuantity;
import tec.uom.se.quantity.NumberQuantity;

final class FloatQuantity<Q extends Quantity<Q>>
extends AbstractQuantity<Q> {
    private static final long serialVersionUID = 5992028803791009345L;
    final float value;

    public FloatQuantity(float value, Unit<Q> unit) {
        super(unit);
        this.value = value;
    }

    @Override
    public Float getValue() {
        return Float.valueOf(this.value);
    }

    @Override
    public double doubleValue(Unit<Q> unit) {
        return super.getUnit().equals(unit) ? (double)this.value : super.getUnit().getConverterTo(unit).convert((double)this.value);
    }

    @Override
    public long longValue(Unit<Q> unit) {
        double result = this.doubleValue(unit);
        if (result < -9.223372036854776E18 || result > 9.223372036854776E18) {
            throw new ArithmeticException("Overflow (" + result + ")");
        }
        return (long)result;
    }

    @Override
    public Quantity<Q> add(ComparableQuantity<Q> that) {
        Quantity converted = that.to(this.getUnit());
        return NumberQuantity.of(this.value + converted.getValue().floatValue(), this.getUnit());
    }

    @Override
    public ComparableQuantity<Q> subtract(ComparableQuantity<Q> that) {
        Quantity converted = that.to(this.getUnit());
        return NumberQuantity.of(this.value - converted.getValue().floatValue(), this.getUnit());
    }

    @Override
    public ComparableQuantity<?> multiply(ComparableQuantity<?> that) {
        return new FloatQuantity<Q>(this.value * that.getValue().floatValue(), this.getUnit().multiply(that.getUnit()));
    }

    @Override
    public ComparableQuantity<Q> multiply(Number that) {
        return NumberQuantity.of(this.value * that.floatValue(), this.getUnit().multiply(that.doubleValue()));
    }

    @Override
    public ComparableQuantity<?> divide(ComparableQuantity<?> that) {
        return new FloatQuantity<Q>(this.value / that.getValue().floatValue(), this.getUnit().divide(that.getUnit()));
    }

    @Override
    public ComparableQuantity<Q> inverse() {
        return NumberQuantity.of(1.0f / this.value, this.getUnit().inverse());
    }

    @Override
    public ComparableQuantity<Q> divide(Number that) {
        return NumberQuantity.of(this.value / that.floatValue(), this.getUnit());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof Quantity) {
            Quantity that = (Quantity)obj;
            return Objects.equals(this.getUnit(), that.getUnit()) && AbstractQuantity.Equalizer.hasEquality(Float.valueOf(this.value), that.getValue());
        }
        return false;
    }

    @Override
    public ComparableQuantity<Q> add(Quantity<Q> that) {
        return null;
    }

    @Override
    public ComparableQuantity<Q> subtract(Quantity<Q> that) {
        return null;
    }

    @Override
    public ComparableQuantity<?> divide(Quantity<?> that) {
        return null;
    }

    @Override
    public ComparableQuantity<?> multiply(Quantity<?> multiplier) {
        return null;
    }

    @Override
    public boolean isBig() {
        return false;
    }

    @Override
    public BigDecimal decimalValue(Unit<Q> unit, MathContext ctx) throws ArithmeticException {
        return BigDecimal.valueOf(this.value);
    }
}

