/*
 * Decompiled with CFR 0.152.
 */
package tec.uom.se;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.measure.UnitConverter;
import tec.uom.se.function.Converter;

public abstract class AbstractConverter
implements UnitConverter,
Converter<Number, Number>,
Serializable {
    private static final long serialVersionUID = 5790242858468427131L;
    protected static final double PI = Math.PI;
    public static final AbstractConverter IDENTITY = new Identity();

    protected AbstractConverter() {
    }

    public AbstractConverter concatenate(AbstractConverter that) {
        return that == IDENTITY ? this : new Pair(this, that);
    }

    public boolean isIdentity() {
        return false;
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public abstract AbstractConverter inverse();

    public UnitConverter concatenate(UnitConverter converter) {
        return converter == IDENTITY ? this : new Pair(this, converter);
    }

    public List<? extends UnitConverter> getConversionSteps() {
        ArrayList<AbstractConverter> converters = new ArrayList<AbstractConverter>();
        converters.add(this);
        return converters;
    }

    @Override
    public Number convert(Number value) {
        if (value instanceof BigDecimal) {
            return this.convert((BigDecimal)value, MathContext.DECIMAL128);
        }
        if (value != null) {
            return this.convert(value.doubleValue());
        }
        throw new IllegalArgumentException("Value cannot be null");
    }

    @Override
    public abstract double convert(double var1);

    public abstract BigDecimal convert(BigDecimal var1, MathContext var2) throws ArithmeticException;

    public static final class Pair
    extends AbstractConverter
    implements Serializable {
        private static final long serialVersionUID = -123063827821728331L;
        private final UnitConverter left;
        private final UnitConverter right;

        public Pair(UnitConverter left, UnitConverter right) {
            if (left == null || right == null) {
                throw new IllegalArgumentException("Converters cannot be null");
            }
            this.left = left;
            this.right = right;
        }

        public boolean isLinear() {
            return this.left.isLinear() && this.right.isLinear();
        }

        @Override
        public boolean isIdentity() {
            return false;
        }

        public List<UnitConverter> getConversionSteps() {
            ArrayList<UnitConverter> steps = new ArrayList<UnitConverter>();
            List leftCompound = this.left.getConversionSteps();
            List rightCompound = this.right.getConversionSteps();
            steps.addAll(leftCompound);
            steps.addAll(rightCompound);
            return steps;
        }

        @Override
        public Pair inverse() {
            return new Pair(this.right.inverse(), this.left.inverse());
        }

        @Override
        public double convert(double value) {
            return this.left.convert(this.right.convert(value));
        }

        @Override
        public BigDecimal convert(BigDecimal value, MathContext ctx) {
            if (this.right instanceof AbstractConverter) {
                return ((AbstractConverter)this.left).convert(((AbstractConverter)this.right).convert(value, ctx), ctx);
            }
            return (BigDecimal)this.left.convert(this.right.convert((Number)value));
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof Pair) {
                Pair that = (Pair)obj;
                return Objects.equals(this.left, that.left) && Objects.equals(this.right, that.right);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.left, this.right);
        }

        public UnitConverter getLeft() {
            return this.left;
        }

        public UnitConverter getRight() {
            return this.right;
        }
    }

    private static final class Identity
    extends AbstractConverter {
        private static final long serialVersionUID = -4460463244427587361L;

        private Identity() {
        }

        @Override
        public boolean isIdentity() {
            return true;
        }

        @Override
        public Identity inverse() {
            return this;
        }

        @Override
        public double convert(double value) {
            return value;
        }

        @Override
        public BigDecimal convert(BigDecimal value, MathContext ctx) {
            return value;
        }

        @Override
        public UnitConverter concatenate(UnitConverter converter) {
            return converter;
        }

        @Override
        public boolean equals(Object cvtr) {
            return cvtr instanceof Identity;
        }

        @Override
        public int hashCode() {
            return 0;
        }

        public boolean isLinear() {
            return true;
        }
    }
}

