/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.editors.quickdiff;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.source.ILineDiffInfo;
import org.eclipse.jface.text.source.ILineDiffer;
import org.eclipse.ui.internal.editors.quickdiff.QuickDiffMessages;
import org.eclipse.ui.internal.editors.quickdiff.QuickDiffRestoreAction;
import org.eclipse.ui.texteditor.ITextEditor;

public class RevertBlockAction
extends QuickDiffRestoreAction {
    private static final String PREFIX = "RevertBlockAction.";
    private int fLine;

    public RevertBlockAction(ITextEditor editor, boolean isRulerAction) {
        super(QuickDiffMessages.getResourceBundle(), PREFIX, editor, isRulerAction);
    }

    @Override
    public boolean computeEnablement() {
        if (!super.computeEnablement()) {
            return false;
        }
        this.fLine = this.getLastLine();
        if (this.fLine == -1) {
            return false;
        }
        ILineDiffer differ = this.getDiffer();
        if (differ == null) {
            return false;
        }
        ILineDiffInfo info = differ.getLineInfo(this.fLine);
        if (info == null || info.getChangeType() == 0) {
            return false;
        }
        boolean hasBlock = false;
        if (this.fLine > 0) {
            info = differ.getLineInfo(this.fLine - 1);
            boolean bl = hasBlock = info != null && info.hasChanges();
        }
        if (!hasBlock) {
            info = differ.getLineInfo(this.fLine + 1);
            boolean bl = hasBlock = info != null && info.hasChanges();
        }
        return hasBlock;
    }

    @Override
    public void runCompoundChange() {
        if (!this.isEnabled()) {
            return;
        }
        ILineDiffer differ = this.getDiffer();
        if (differ != null) {
            try {
                differ.revertBlock(this.fLine);
            }
            catch (BadLocationException e) {
                this.setStatus(e.getMessage());
            }
        }
    }
}

