/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.internal.axis;

import java.text.Format;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swtchart.Chart;
import org.eclipse.swtchart.IAxis;
import org.eclipse.swtchart.internal.axis.Axis;
import org.eclipse.swtchart.internal.axis.AxisTick;

public class AxisPositionMarker
implements PaintListener {
    private static final int NOT_SET = -1;
    private static final int TRIANGLE_DELTA = 3;
    private static final int OFFSET_RECTANGLE_X = 8;
    private static final int OFFSET_RECTANGLE_Y = 2;
    private static final int OFFSET_TEXT_X = 4;
    private static final int OFFSET_TEXT_Y = 2;
    private static final int OFFSET_SPACE_Y = 5;
    private static final int OFFSET_LINE_Y = 2;
    private static final int ARC_WIDTH = 5;
    private static final int ARC_HEIGHT = 3;
    private Chart chart;
    private Axis axis;
    private Rectangle bounds;
    private int x = -1;
    private int y = -1;
    private boolean draw = false;

    public AxisPositionMarker(Chart chart, Axis axis) {
        this.chart = chart;
        this.axis = axis;
        this.chart.addPaintListener(this);
    }

    public void setBounds(int x, int y, int width, int height) {
        this.bounds = new Rectangle(x, y, width, height);
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public boolean isDraw() {
        return this.draw;
    }

    public void setDraw(boolean draw) {
        this.draw = draw;
    }

    public void update(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void reset() {
        this.x = -1;
        this.y = -1;
    }

    public void paintControl(PaintEvent e) {
        if (this.draw && this.axis.getTick().isVisible() && this.isActive()) {
            GC gc = e.gc;
            Color foreground = gc.getForeground();
            Color background = gc.getBackground();
            gc.setForeground(e.display.getSystemColor(1));
            gc.setBackground(e.display.getSystemColor(16));
            Font font = gc.getFont();
            AxisTick axisTick = this.axis.getTick();
            Format axisFormat = axisTick.getFormat();
            gc.setFont(axisTick.getFont());
            if (this.axis.isHorizontalAxis()) {
                this.drawPositionMarkerX(e.gc, axisFormat);
            } else {
                this.drawPositionMarkerY(e.gc, axisFormat);
            }
            gc.setForeground(foreground);
            gc.setBackground(background);
            gc.setFont(font);
        }
        this.reset();
    }

    private boolean isActive() {
        return this.x > -1 && this.y > -1;
    }

    private void drawPositionMarkerX(GC gc, Format format) {
        String textValue = this.getTextValue(format, this.getValueX());
        Point textExtend = this.getTextExtend(gc, textValue);
        if (this.axis.getPosition() == IAxis.Position.Primary) {
            this.drawPrimaryMarkerX(gc, textValue, textExtend);
        } else {
            this.drawSecondardMarkerX(gc, textValue, textExtend);
        }
    }

    private void drawPositionMarkerY(GC gc, Format format) {
        String textValue = this.getTextValue(format, this.getValueY());
        Point textExtend = this.getTextExtend(gc, textValue);
        if (this.axis.getPosition() == IAxis.Position.Primary) {
            this.drawPrimaryMarkerY(gc, textValue, textExtend);
        } else {
            this.drawSecondaryMarkerY(gc, textValue, textExtend);
        }
    }

    private void drawPrimaryMarkerX(GC gc, String textValue, Point textExtend) {
        int offsetX = textExtend.x / 2;
        int positionX = this.bounds.x + this.x - offsetX;
        int positionY = this.bounds.y + 8;
        this.drawTrianglePrimaryX(gc);
        this.fillRoundRectangle(gc, positionX, positionY, textExtend.x, textExtend.y);
        this.drawText(gc, positionX + 4, positionY + 2, textValue);
    }

    private void drawSecondardMarkerX(GC gc, String textValue, Point textExtend) {
        int offsetX = textExtend.x / 2;
        int offsetY = textExtend.y / 2;
        int positionX = this.bounds.x + this.x - offsetX;
        int positionY = this.bounds.y - offsetY - 8;
        this.drawTriangleSecondaryX(gc);
        this.fillRoundRectangle(gc, positionX, positionY - 5, textExtend.x, textExtend.y);
        this.drawText(gc, positionX + 4, positionY - 5, textValue);
    }

    private void drawPrimaryMarkerY(GC gc, String textValue, Point textExtend) {
        int offsetY = textExtend.y / 2;
        int positionX = this.bounds.x - textExtend.x + 8;
        int positionY = this.bounds.y + this.y - offsetY - 2;
        this.drawTrianglePrimaryY(gc);
        this.fillRoundRectangle(gc, positionX - 2, positionY, textExtend.x - 4, textExtend.y);
        this.drawText(gc, positionX, positionY + 2, textValue);
    }

    private void drawSecondaryMarkerY(GC gc, String textValue, Point textExtend) {
        int offsetY = textExtend.y / 2;
        int positionX = this.bounds.x + 8;
        int positionY = this.bounds.y + this.y - offsetY - 2;
        this.drawTriangleSecondaryY(gc);
        this.fillRoundRectangle(gc, positionX, positionY, textExtend.x + 4, textExtend.y);
        this.drawText(gc, positionX + 4 + 3, positionY + 2, textValue);
    }

    private void drawTrianglePrimaryX(GC gc) {
        int positionX = this.bounds.x + this.x;
        int positionY = this.bounds.y;
        int x1 = positionX;
        int y1 = positionY;
        int x2 = positionX + 8 - 3;
        int y2 = positionY + 8;
        int x3 = positionX - 8 + 3;
        int y3 = positionY + 8;
        this.drawTriangle(gc, x1, y1, x2, y2, x3, y3);
    }

    private void drawTriangleSecondaryX(GC gc) {
        int positionX = this.bounds.x + this.x;
        int positionY = this.bounds.y - 5;
        int x1 = positionX + 8 - 3;
        int y1 = positionY;
        int x2 = positionX - 8 + 3;
        int y2 = positionY;
        int x3 = positionX;
        int y3 = positionY + 8;
        this.drawTriangle(gc, x1, y1, x2, y2, x3, y3);
    }

    private void drawTrianglePrimaryY(GC gc) {
        int positionX = this.bounds.x;
        int positionY = this.bounds.y + this.y - 2;
        int x1 = positionX;
        int y1 = positionY - 8 + 3;
        int x2 = positionX;
        int y2 = positionY + 8 - 3;
        int x3 = positionX + 8;
        int y3 = positionY;
        this.drawTriangle(gc, x1, y1, x2, y2, x3, y3);
    }

    private void drawTriangleSecondaryY(GC gc) {
        int positionX = this.bounds.x;
        int positionY = this.bounds.y + this.y - 2;
        int x1 = positionX + 8;
        int y1 = positionY - 8 + 3;
        int x2 = positionX + 8;
        int y2 = positionY + 8 - 3;
        int x3 = positionX;
        int y3 = positionY;
        this.drawTriangle(gc, x1, y1, x2, y2, x3, y3);
    }

    private void drawTriangle(GC gc, int x1, int y1, int x2, int y2, int x3, int y3) {
        gc.fillPolygon(new int[]{x1, y1, x2, y2, x3, y3});
    }

    private void fillRoundRectangle(GC gc, int x, int y, int width, int height) {
        gc.fillRoundRectangle(x, y, width, height, 5, 3);
    }

    private void drawText(GC gc, int x, int y, String text) {
        gc.drawText(text, x, y);
    }

    private String getTextValue(Format format, double value) {
        return format.format(value);
    }

    private Point getTextExtend(GC gc, String text) {
        Point point = gc.textExtent(text);
        point.x += 8;
        point.y += 2;
        return point;
    }

    private double getValueX() {
        return this.axis.getDataCoordinate(this.x);
    }

    private double getValueY() {
        return this.axis.getDataCoordinate(this.y);
    }
}

