/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsd.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;
import org.eclipse.xsd.XSDAnnotation;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDPackage;
import org.eclipse.xsd.impl.XSDComponentImpl;
import org.eclipse.xsd.util.XSDConstants;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class XSDAnnotationImpl
extends XSDComponentImpl
implements XSDAnnotation {
    protected EList<Element> applicationInformation;
    protected EList<Element> userInformation;
    protected EList<Attr> attributes;

    public static XSDAnnotation createAnnotation(Node node) {
        if (XSDConstants.nodeType(node) == 1) {
            XSDAnnotation xsdAnnotation = XSDFactory.eINSTANCE.createXSDAnnotation();
            xsdAnnotation.setElement((Element)node);
            return xsdAnnotation;
        }
        return null;
    }

    protected XSDAnnotationImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return XSDPackage.Literals.XSD_ANNOTATION;
    }

    @Override
    public EList<Element> getApplicationInformation() {
        if (this.applicationInformation == null) {
            this.applicationInformation = new EDataTypeUniqueEList(Element.class, (InternalEObject)this, 5);
        }
        return this.applicationInformation;
    }

    @Override
    public EList<Element> getUserInformation() {
        if (this.userInformation == null) {
            this.userInformation = new EDataTypeUniqueEList(Element.class, (InternalEObject)this, 6);
        }
        return this.userInformation;
    }

    @Override
    public EList<Attr> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new EDataTypeUniqueEList(Attr.class, (InternalEObject)this, 7);
        }
        return this.attributes;
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 5: {
                return this.getApplicationInformation();
            }
            case 6: {
                return this.getUserInformation();
            }
            case 7: {
                return this.getAttributes();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 5: {
                this.getApplicationInformation().clear();
                this.getApplicationInformation().addAll((Collection)newValue);
                return;
            }
            case 6: {
                this.getUserInformation().clear();
                this.getUserInformation().addAll((Collection)newValue);
                return;
            }
            case 7: {
                this.getAttributes().clear();
                this.getAttributes().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 5: {
                this.getApplicationInformation().clear();
                return;
            }
            case 6: {
                this.getUserInformation().clear();
                return;
            }
            case 7: {
                this.getAttributes().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 5: {
                return this.applicationInformation != null && !this.applicationInformation.isEmpty();
            }
            case 6: {
                return this.userInformation != null && !this.userInformation.isEmpty();
            }
            case 7: {
                return this.attributes != null && !this.attributes.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuilder result = new StringBuilder(super.toString());
        result.append(" (applicationInformation: ");
        result.append(this.applicationInformation);
        result.append(", userInformation: ");
        result.append(this.userInformation);
        result.append(", attributes: ");
        result.append(this.attributes);
        result.append(')');
        return result.toString();
    }

    @Override
    public Element createElement() {
        Element newElement = this.createElement(1);
        this.setElement(newElement);
        return newElement;
    }

    @Override
    public void validate() {
        super.validate();
        Element theElement = this.getElement();
        if (theElement != null) {
            this.checkElementComplexContent("annotation", "http://www.w3.org/TR/xmlschema-1/", "element-annotation", theElement);
        }
    }

    @Override
    protected void reconcileAttributes(Element changedElement) {
        super.reconcileAttributes(changedElement);
        Element theElement = this.getElement();
        if (changedElement == theElement || changedElement.getParentNode() == theElement) {
            XSDConcreteComponent container = this.getContainer();
            ArrayList<Attr> newAttributes = new ArrayList<Attr>();
            Node theNode = theElement;
            while (theNode != null) {
                NamedNodeMap attributes = theNode.getAttributes();
                int i = 0;
                int size = attributes.getLength();
                while (i < size) {
                    Attr attr = (Attr)attributes.item(i);
                    String attrName = attr.getNodeName();
                    int index = attrName.lastIndexOf(":");
                    if (index != -1) {
                        newAttributes.add(attr);
                    }
                    ++i;
                }
                if (container == null || container.getElement() == theNode) break;
                theNode = theNode.getParentNode();
            }
            EList<Attr> theAttributes = this.getAttributes();
            ArrayList<Attr> remainingAttributes = new ArrayList<Attr>((Collection<Attr>)theAttributes);
            remainingAttributes.removeAll(newAttributes);
            if (!remainingAttributes.isEmpty()) {
                theAttributes.removeAll(remainingAttributes);
            }
            XSDAnnotationImpl.setListContentAndOrder(theAttributes, newAttributes);
        }
    }

    @Override
    protected void reconcileContents(Element changedElement) {
        Element theElement = this.getElement();
        if (changedElement == theElement || changedElement.getParentNode() == theElement) {
            ArrayList<Element> newApplicationInformation = new ArrayList<Element>();
            ArrayList<Element> newUserInformation = new ArrayList<Element>();
            Node child = theElement.getFirstChild();
            while (child != null) {
                switch (XSDConstants.nodeType(child)) {
                    case 4: {
                        newApplicationInformation.add((Element)child);
                        break;
                    }
                    case 10: {
                        newUserInformation.add((Element)child);
                    }
                }
                child = child.getNextSibling();
            }
            EList<Element> theApplicationInformation = this.getApplicationInformation();
            ArrayList<Element> remainingApplicationInformation = new ArrayList<Element>((Collection<Element>)theApplicationInformation);
            remainingApplicationInformation.removeAll(newApplicationInformation);
            if (!remainingApplicationInformation.isEmpty()) {
                theApplicationInformation.removeAll(remainingApplicationInformation);
            }
            XSDAnnotationImpl.setListContentAndOrder(theApplicationInformation, newApplicationInformation);
            EList<Element> theUserInformation = this.getUserInformation();
            ArrayList<Element> remainingUserInformation = new ArrayList<Element>((Collection<Element>)theUserInformation);
            remainingUserInformation.removeAll(newUserInformation);
            if (!remainingUserInformation.isEmpty()) {
                remainingUserInformation.removeAll(newUserInformation);
            }
            theUserInformation.removeAll(remainingUserInformation);
            XSDAnnotationImpl.setListContentAndOrder(theUserInformation, newUserInformation);
        }
    }

    @Override
    public Element createApplicationInformation(String sourceURI) {
        if (this.getElement() == null) {
            this.updateElement();
        }
        Element result = this.createElement(4);
        if (sourceURI != null && result != null) {
            result.setAttributeNS(null, "source", sourceURI);
        }
        return result;
    }

    @Override
    public Element createUserInformation(String sourceURI) {
        if (this.getElement() == null) {
            this.updateElement();
        }
        Element result = this.createElement(10);
        if (sourceURI != null && result != null) {
            result.setAttributeNS(null, "source", sourceURI);
        }
        return result;
    }

    @Override
    public EList<Element> getApplicationInformation(String sourceURI) {
        BasicEList result = new BasicEList();
        for (Element appinfo : this.getApplicationInformation()) {
            if (!(sourceURI == null ? !appinfo.hasAttributeNS(null, "source") : appinfo.getAttributeNS(null, "source").equals(sourceURI))) continue;
            result.add((Object)appinfo);
        }
        return result;
    }

    @Override
    public EList<Element> getUserInformation(String sourceURI) {
        BasicEList result = new BasicEList();
        for (Element documentation : this.getUserInformation()) {
            if (!(sourceURI == null ? !documentation.hasAttributeNS(null, "source") : documentation.getAttributeNS(null, "source").equals(sourceURI))) continue;
            result.add((Object)documentation);
        }
        return result;
    }

    @Override
    public Set<String> getApplicationInformationSources() {
        HashSet<String> result = new HashSet<String>();
        for (Element appinfo : this.getApplicationInformation()) {
            result.add(appinfo.hasAttributeNS(null, "source") ? appinfo.getAttributeNS(null, "source") : null);
        }
        return result;
    }

    @Override
    public Set<String> getUserInformationSources() {
        HashSet<String> result = new HashSet<String>();
        for (Element documentation : this.getUserInformation()) {
            result.add(documentation.hasAttributeNS(null, "source") ? documentation.getAttributeNS(null, "source") : null);
        }
        return result;
    }

    @Override
    protected void getComponentsWithInformation(Collection<XSDConcreteComponent> result, int nodeType, String sourceURI) {
        for (Element childElement : nodeType == 4 ? this.getApplicationInformation() : this.getUserInformation()) {
            if (!(sourceURI == null ? !childElement.hasAttributeNS(null, "source") : childElement.getAttributeNS(null, "source").equals(sourceURI))) continue;
            result.add(this.getContainer());
            break;
        }
    }

    @Override
    public XSDConcreteComponent cloneConcreteComponent(boolean deep, boolean shareDOM) {
        XSDAnnotationImpl clonedAnnotation = (XSDAnnotationImpl)this.getXSDFactory().createXSDAnnotation();
        clonedAnnotation.isReconciling = true;
        if (shareDOM) {
            Element element = this.getElement();
            if (element != null) {
                clonedAnnotation.setElement(element);
            }
            clonedAnnotation.getApplicationInformation().addAll(this.getApplicationInformation());
            clonedAnnotation.getUserInformation().addAll(this.getUserInformation());
            clonedAnnotation.getAttributes().addAll(this.getAttributes());
        }
        clonedAnnotation.isReconciling = shareDOM;
        return clonedAnnotation;
    }
}

