/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.project.wizards;

import java.net.URI;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectRegistry;
import org.eclipse.tracecompass.tmf.ui.project.wizards.Messages;
import org.eclipse.tracecompass.tmf.ui.project.wizards.NewTmfProjectMainWizardPage;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

public class NewTmfProjectWizard
extends Wizard
implements INewWizard,
IExecutableExtension {
    public static final String ID = "org.eclipse.linuxtools.tmf.ui.views.ui.wizards.newProject";
    private final String fTtitle;
    private final String fDescription;
    protected NewTmfProjectMainWizardPage fMainPage;
    protected String fProjectName;
    protected URI fProjectLocation;
    protected IConfigurationElement fConfigElement;
    protected IProject fProject;

    public NewTmfProjectWizard() {
        this(Messages.NewProjectWizard_DialogHeader, Messages.NewProjectWizard_DialogMessage);
    }

    public NewTmfProjectWizard(String title, String desc) {
        this.setDialogSettings(Activator.getDefault().getDialogSettings());
        this.setNeedsProgressMonitor(true);
        this.setForcePreviousAndNextButtons(true);
        this.setWindowTitle(title);
        this.fTtitle = title;
        this.fDescription = desc;
    }

    public void addPages() {
        this.fMainPage = new NewTmfProjectMainWizardPage(Messages.NewProjectWizard_DialogHeader);
        this.fMainPage.setTitle(this.fTtitle);
        this.fMainPage.setDescription(this.fDescription);
        this.addPage((IWizardPage)this.fMainPage);
    }

    public boolean performCancel() {
        return true;
    }

    public boolean performFinish() {
        this.fProjectName = this.fMainPage.getProjectName();
        this.fProjectLocation = this.fMainPage.useDefaults() ? null : this.fMainPage.getLocationURI();
        this.fProject = TmfProjectRegistry.createProject(this.fProjectName, this.fProjectLocation, (IProgressMonitor)new NullProgressMonitor());
        BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.fConfigElement);
        return true;
    }

    public void init(IWorkbench iworkbench, IStructuredSelection istructuredselection) {
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.fConfigElement = config;
    }
}

