/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.contentmodel.util;

import java.util.Hashtable;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAnyElement;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMContent;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDataType;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMGroup;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNamedNodeMap;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNodeList;
import org.eclipse.wst.xml.core.internal.contentmodel.ContentModelManager;
import org.eclipse.wst.xml.core.internal.contentmodel.internal.util.CMDataTypeValueHelper;
import org.eclipse.wst.xml.core.internal.contentmodel.util.CMVisitor;
import org.eclipse.wst.xml.core.internal.contentmodel.util.DOMContentBuilder;
import org.eclipse.wst.xml.core.internal.contentmodel.util.DOMNamespaceHelper;
import org.eclipse.wst.xml.core.internal.contentmodel.util.DOMNamespaceInfoManager;
import org.eclipse.wst.xml.core.internal.contentmodel.util.DOMWriter;
import org.eclipse.wst.xml.core.internal.contentmodel.util.NamespaceInfo;
import org.eclipse.wst.xml.core.internal.contentmodel.util.NamespaceTable;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class DOMContentBuilderImpl
extends CMVisitor
implements DOMContentBuilder {
    protected int buildPolicy = 15;
    protected Hashtable propertyTable = new Hashtable();
    protected boolean alwaysVisit = false;
    protected List resultList;
    protected Document document;
    protected Node currentParent;
    protected Node topParent;
    protected Vector visitedCMElementDeclarationList = new Vector();
    protected boolean attachNodesToParent = true;
    protected NamespaceTable namespaceTable;
    protected List namespaceInfoList;
    protected Element rootElement;
    protected ExternalCMDocumentSupport externalCMDocumentSupport;
    public boolean supressCreationOfDoctypeAndXMLDeclaration;
    protected CMDataTypeValueHelper valueHelper = new CMDataTypeValueHelper();
    protected int numOfRepeatableElements = 1;
    protected Stack cmGroupStack = new Stack();
    protected int depthLimit = -1;
    protected int domLevel;
    private int originalBuildPolicy;
    static int count = 0;

    public void setExternalCMDocumentSupport(ExternalCMDocumentSupport externalCMDocumentSupport) {
        this.externalCMDocumentSupport = externalCMDocumentSupport;
    }

    public DOMContentBuilderImpl(Document document) {
        this.document = document;
        this.namespaceTable = new NamespaceTable(document);
    }

    @Override
    public void setBuildPolicy(int buildPolicy) {
        this.buildPolicy = buildPolicy;
    }

    @Override
    public int getBuildPolicy() {
        return this.buildPolicy;
    }

    protected boolean buildAllContent(int policy) {
        return (policy & 0xF) == 15;
    }

    protected boolean buildOptionalElements(int policy) {
        return (policy & 2) == 2;
    }

    protected boolean buildOptionalAttributes(int policy) {
        return (policy & 1) == 1;
    }

    protected boolean buildFirstChoice(int policy) {
        return (policy & 4) == 4;
    }

    protected boolean buildTextNodes(int policy) {
        return (policy & 8) == 8;
    }

    protected boolean buildFirstSubstitution(int policy) {
        return (policy & 0x10) == 16;
    }

    @Override
    public List getResult() {
        return this.resultList;
    }

    @Override
    public void setProperty(String propertyName, Object value) {
        this.propertyTable.put(propertyName, value);
    }

    @Override
    public Object getProperty(String propertyName) {
        return this.propertyTable.get(propertyName);
    }

    @Override
    public void build(Node parent, CMNode child) {
        this.resultList = new Vector();
        this.topParent = parent;
        this.currentParent = parent;
        if (parent instanceof Element) {
            this.namespaceTable.addElementLineage((Element)parent);
        }
        this.attachNodesToParent = false;
        this.alwaysVisit = true;
        this.visitCMNode(child);
    }

    @Override
    public void createDefaultRootContent(CMDocument cmDocument, CMElementDeclaration rootCMElementDeclaration, List namespaceInfoList) throws Exception {
        this.namespaceInfoList = namespaceInfoList;
        this.createDefaultRootContent(cmDocument, rootCMElementDeclaration);
    }

    @Override
    public void createDefaultRootContent(CMDocument cmDocument, CMElementDeclaration rootCMElementDeclaration) throws Exception {
        String grammarFileName = cmDocument.getNodeName();
        if (!this.supressCreationOfDoctypeAndXMLDeclaration) {
            Object piValue = "version=\"1.0\"";
            String encoding = "UTF-8";
            piValue = (String)piValue + " encoding=\"" + encoding + "\"";
            ProcessingInstruction pi = this.document.createProcessingInstruction("xml", (String)piValue);
            this.document.appendChild(pi);
            if (grammarFileName != null && grammarFileName.endsWith("dtd")) {
                DOMImplementation domImpl = this.document.getImplementation();
                DocumentType documentType = domImpl.createDocumentType(rootCMElementDeclaration.getElementName(), grammarFileName, grammarFileName);
                this.document.appendChild(documentType);
            }
        }
        if (grammarFileName != null && grammarFileName.endsWith("xsd") && this.namespaceInfoList != null) {
            DOMNamespaceInfoManager manager = new DOMNamespaceInfoManager();
            Object name = rootCMElementDeclaration.getNodeName();
            if (this.namespaceInfoList.size() > 0) {
                NamespaceInfo info = (NamespaceInfo)this.namespaceInfoList.get(0);
                if (info.prefix != null && info.prefix.length() > 0) {
                    name = info.prefix + ":" + (String)name;
                }
            }
            this.rootElement = this.createElement(rootCMElementDeclaration, (String)name, this.document);
            manager.addNamespaceInfo(this.rootElement, this.namespaceInfoList, true);
        }
        this.createDefaultContent(this.document, rootCMElementDeclaration);
    }

    @Override
    public void createDefaultContent(Node parent, CMElementDeclaration ed) {
        this.currentParent = parent;
        this.alwaysVisit = true;
        this.originalBuildPolicy = this.buildPolicy;
        this.visitCMElementDeclaration(ed);
    }

    public String computeName(CMNode cmNode, Node parent) {
        String prefix = null;
        return DOMNamespaceHelper.computeName(cmNode, parent, prefix, this.namespaceTable);
    }

    protected Element createElement(CMElementDeclaration ed, String name, Node parent) {
        return this.document.createElement(name);
    }

    protected Attr createAttribute(CMAttributeDeclaration ad, String name, Node parent) {
        return this.document.createAttribute(name);
    }

    protected Text createTextNode(CMDataType dataType, String value, Node parent) {
        return this.document.createTextNode(value);
    }

    protected void handlePushParent(Element parent, CMElementDeclaration ed) {
        ++this.domLevel;
    }

    protected void handlePopParent(Element element, CMElementDeclaration ed) {
        --this.domLevel;
    }

    public void setNumOfRepeatableElements(int i) {
        this.numOfRepeatableElements = i;
    }

    protected int getNumOfRepeatableElements() {
        return this.numOfRepeatableElements;
    }

    @Override
    public void visitCMElementDeclaration(CMElementDeclaration ed) {
        int max;
        int forcedMin = this.buildOptionalElements(this.buildPolicy) || this.alwaysVisit ? 1 : 0;
        int min = Math.max(ed.getMinOccur(), forcedMin);
        if (!this.cmGroupStack.isEmpty()) {
            CMGroup group = (CMGroup)this.cmGroupStack.peek();
            int gmin = group.getMinOccur();
            if (gmin == 0) {
                if (!this.buildOptionalElements(this.buildPolicy)) {
                    min *= gmin;
                }
            } else {
                min *= gmin;
            }
        }
        if ((max = Math.min(ed.getMaxOccur(), this.getNumOfRepeatableElements())) < min) {
            max = min;
        }
        this.alwaysVisit = false;
        if (this.buildFirstSubstitution(this.buildPolicy) || this.isAbstract(ed)) {
            ed = this.getSubstitution(ed);
        }
        if (min > 0 && !this.visitedCMElementDeclarationList.contains(ed)) {
            this.visitedCMElementDeclarationList.add(ed);
            int i = 1;
            while (i <= max) {
                CMDataType dataType;
                Element element = null;
                if (this.rootElement != null) {
                    element = this.rootElement;
                    this.rootElement = null;
                } else {
                    element = this.createElement(ed, this.computeName(ed, this.currentParent), this.currentParent);
                }
                Node oldParent = this.currentParent;
                this.currentParent = element;
                this.handlePushParent(element, ed);
                this.namespaceTable.addElement(element);
                boolean oldAttachNodesToParent = this.attachNodesToParent;
                this.attachNodesToParent = true;
                CMNamedNodeMap nodeMap = ed.getAttributes();
                int size = nodeMap.getLength();
                int j = 0;
                while (j < size) {
                    this.visitCMNode(nodeMap.item(j));
                    ++j;
                }
                CMContent content = ed.getContent();
                if (content != null) {
                    this.visitCMNode(content);
                }
                if (ed.getContentType() == 4 && (dataType = ed.getDataType()) != null) {
                    this.visitCMDataType(dataType);
                }
                this.attachNodesToParent = oldAttachNodesToParent;
                this.handlePopParent(element, ed);
                this.currentParent = oldParent;
                this.linkNode(element);
                ++i;
            }
            int size = this.visitedCMElementDeclarationList.size();
            this.visitedCMElementDeclarationList.remove(size - 1);
        }
    }

    @Override
    public void visitCMDataType(CMDataType dataType) {
        Text text = null;
        String value = null;
        if (this.getProperty("buildBlankTextNodes") != null && this.getProperty("buildBlankTextNodes").equals("true")) {
            this.buildPolicy ^= 8;
        }
        if (this.buildTextNodes(this.buildPolicy)) {
            value = this.valueHelper.getValue(dataType);
            if (value == null) {
                value = this.currentParent != null && this.currentParent.getNodeType() == 1 ? this.currentParent.getNodeName() : "pcdata";
            }
        } else {
            value = "";
        }
        text = this.createTextNode(dataType, value, this.currentParent);
        this.linkNode(text);
    }

    @Override
    public void visitCMNode(CMNode node) {
        if (this.depthLimit != -1) {
            this.buildPolicy = this.domLevel > this.depthLimit ? (this.buildPolicy &= 0xFFFFFFFD) : this.originalBuildPolicy;
        }
        super.visitCMNode(node);
    }

    @Override
    public void visitCMGroup(CMGroup e) {
        this.cmGroupStack.push(e);
        int forcedMin = this.buildOptionalElements(this.buildPolicy) || this.alwaysVisit ? 1 : 0;
        int min = Math.max(e.getMinOccur(), forcedMin);
        int max = 0;
        max = e.getMaxOccur() == -1 ? this.getNumOfRepeatableElements() : Math.min(e.getMaxOccur(), this.getNumOfRepeatableElements());
        if (max < min) {
            max = min;
        }
        this.alwaysVisit = false;
        int i = 1;
        while (i <= max) {
            if (e.getOperator() == 2 && this.buildFirstChoice(this.buildPolicy)) {
                CMNodeList nodeList;
                CMElementDeclaration ed;
                Object contentHint;
                CMNode hintNode = null;
                int listSize = this.visitedCMElementDeclarationList.size();
                if (listSize > 0 && (contentHint = (ed = (CMElementDeclaration)this.visitedCMElementDeclarationList.get(listSize - 1)).getProperty("contentHint")) instanceof CMNode) {
                    hintNode = (CMNode)contentHint;
                }
                CMNode cmNode = null;
                if (hintNode != null) {
                    nodeList = e.getChildNodes();
                    int nodeListLength = nodeList.getLength();
                    int j = 0;
                    while (j < nodeListLength) {
                        if (hintNode == nodeList.item(j)) {
                            cmNode = hintNode;
                        }
                        ++j;
                    }
                }
                if (cmNode == null && (nodeList = e.getChildNodes()).getLength() > 0) {
                    cmNode = nodeList.item(0);
                }
                if (cmNode != null && (cmNode.getNodeType() != 7 || min <= 0)) {
                    this.visitCMNode(cmNode);
                }
            } else if (e.getOperator() == 3 || e.getOperator() == 1) {
                super.visitCMGroup(e);
            }
            ++i;
        }
        this.cmGroupStack.pop();
    }

    @Override
    public void visitCMAttributeDeclaration(CMAttributeDeclaration ad) {
        if (this.alwaysVisit || this.buildOptionalAttributes(this.buildPolicy) || ad.getUsage() == 2) {
            this.alwaysVisit = false;
            String name = this.computeName(ad, this.currentParent);
            String value = this.valueHelper.getValue(ad, this.namespaceTable);
            Attr attr = this.createAttribute(ad, name, this.currentParent);
            attr.setValue(value != null ? value : "");
            this.linkNode(attr);
        }
    }

    protected boolean isAbstract(CMNode ed) {
        boolean result = false;
        if (ed != null) {
            Object value = ed.getProperty("Abstract");
            result = value == Boolean.TRUE;
        }
        return result;
    }

    protected CMElementDeclaration getSubstitution(CMElementDeclaration ed) {
        CMElementDeclaration result = ed;
        CMNodeList l = (CMNodeList)ed.getProperty("SubstitutionGroup");
        if (l != null) {
            int i = 0;
            while (i < l.getLength()) {
                CMNode candidate = l.item(i);
                if (!this.isAbstract(candidate) && candidate instanceof CMElementDeclaration) {
                    result = (CMElementDeclaration)candidate;
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    protected CMElementDeclaration getParentCMElementDeclaration() {
        CMElementDeclaration ed = null;
        int listSize = this.visitedCMElementDeclarationList.size();
        if (listSize > 0) {
            ed = (CMElementDeclaration)this.visitedCMElementDeclarationList.get(listSize - 1);
        }
        return ed;
    }

    @Override
    public void visitCMAnyElement(CMAnyElement anyElement) {
        CMDocument externalCMDocument;
        int forcedMin = this.alwaysVisit ? 1 : 0;
        int min = Math.max(anyElement.getMinOccur(), forcedMin);
        this.alwaysVisit = false;
        String uri = anyElement.getNamespaceURI();
        String targetNSProperty = "http://org.eclipse.wst/cm/properties/targetNamespaceURI";
        CMDocument parentCMDocument = (CMDocument)anyElement.getProperty("CMDocument");
        CMElementDeclaration ed = null;
        if (parentCMDocument != null && (uri == null || uri.startsWith("##") || uri.equals(parentCMDocument.getProperty(targetNSProperty)))) {
            ed = this.getSuitableElement(this.getParentCMElementDeclaration(), parentCMDocument);
        }
        if (ed == null && this.externalCMDocumentSupport != null && uri != null && !uri.startsWith("##") && this.currentParent instanceof Element && (externalCMDocument = this.externalCMDocumentSupport.getCMDocument((Element)this.currentParent, uri)) != null) {
            ed = this.getSuitableElement(null, externalCMDocument);
        }
        int i = 1;
        while (i <= min) {
            if (ed != null) {
                this.visitCMElementDeclaration(ed);
            } else {
                Element element = this.document.createElement("ANY-ELEMENT");
                this.linkNode(element);
            }
            ++i;
        }
    }

    protected CMElementDeclaration getSuitableElement(CMNamedNodeMap nameNodeMap) {
        CMElementDeclaration result = null;
        int size = nameNodeMap.getLength();
        int i = 0;
        while (i < size) {
            CMElementDeclaration candidate = (CMElementDeclaration)nameNodeMap.item(i);
            if (!this.visitedCMElementDeclarationList.contains(candidate)) {
                result = candidate;
                break;
            }
            ++i;
        }
        return result;
    }

    protected CMElementDeclaration getSuitableElement(CMElementDeclaration ed, CMDocument cmDocument) {
        CMElementDeclaration result = null;
        if (ed != null) {
            result = this.getSuitableElement(ed.getLocalElements());
        }
        if (result == null && cmDocument != null) {
            result = this.getSuitableElement(cmDocument.getElements());
        }
        return result;
    }

    public void linkNode(Node node) {
        if (this.attachNodesToParent && this.currentParent != null) {
            if (node.getNodeType() == 2) {
                ((Element)this.currentParent).setAttributeNode((Attr)node);
            } else {
                this.currentParent.appendChild(node);
            }
        } else if (this.resultList != null) {
            this.resultList.add(node);
        }
    }

    public static void testPopulateDocumentFromGrammarFile(Document document, String grammarFileName, String rootElementName, boolean hack) {
        try {
            CMDocument cmDocument = ContentModelManager.getInstance().createCMDocument(grammarFileName, null);
            CMNamedNodeMap elementMap = cmDocument.getElements();
            CMElementDeclaration element = (CMElementDeclaration)elementMap.getNamedItem(rootElementName);
            DOMContentBuilderImpl contentBuilder = new DOMContentBuilderImpl(document);
            contentBuilder.supressCreationOfDoctypeAndXMLDeclaration = hack;
            contentBuilder.createDefaultRootContent(cmDocument, element);
            System.out.println();
            System.out.println("-----------------------------");
            DOMWriter writer = new DOMWriter();
            if (hack) {
                writer.print(document, grammarFileName);
            } else {
                writer.print(document);
            }
            System.out.println("-----------------------------");
        }
        catch (Exception e) {
            System.out.println("Error: " + String.valueOf(e));
            e.printStackTrace();
        }
    }

    public void setOptionalElementDepthLimit(int depth) {
        this.depthLimit = depth;
    }

    public static interface ExternalCMDocumentSupport {
        public CMDocument getCMDocument(Element var1, String var2);
    }
}

