/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.engine;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.equinox.internal.p2.engine.ProfileXMLConstants;
import org.eclipse.equinox.internal.p2.metadata.repository.io.MetadataWriter;
import org.eclipse.equinox.internal.p2.persistence.XMLWriter;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.query.QueryUtil;

public class ProfileWriter
extends MetadataWriter
implements ProfileXMLConstants {
    public ProfileWriter(OutputStream output, XMLWriter.ProcessingInstruction[] processingInstructions) {
        super(output, processingInstructions);
    }

    public void writeProfile(IProfile profile) {
        this.start("profile");
        this.attribute("id", profile.getProfileId());
        this.attribute("timestamp", Long.toString(profile.getTimestamp()));
        this.writeProperties(profile.getProperties());
        ArrayList ius = new ArrayList(profile.query(QueryUtil.createIUAnyQuery(), null).toUnmodifiableSet());
        ius.sort((iu1, iu2) -> {
            int IdCompare = iu1.getId().compareTo(iu2.getId());
            if (IdCompare != 0) {
                return IdCompare;
            }
            return iu1.getVersion().compareTo((Object)iu2.getVersion());
        });
        this.writeInstallableUnits(ius.iterator(), ius.size());
        this.writeInstallableUnitsProperties(ius.iterator(), ius.size(), profile);
        this.end("profile");
        this.flush();
    }

    private void writeInstallableUnitsProperties(Iterator<IInstallableUnit> it, int size, IProfile profile) {
        if (size == 0) {
            return;
        }
        this.start("iusProperties");
        this.attribute("size", size);
        while (it.hasNext()) {
            IInstallableUnit iu = it.next();
            Map<String, String> properties = profile.getInstallableUnitProperties(iu);
            if (properties.isEmpty()) continue;
            this.start("iuProperties");
            this.attribute("id", iu.getId());
            this.attribute("version", iu.getVersion().toString());
            this.writeProperties(properties);
            this.end("iuProperties");
        }
        this.end("iusProperties");
    }
}

