/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.plugin;

import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.plugin.RegistryReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DynamicPackageRegistryReader
extends RegistryReader {
    static final String TAG_RESOURCE = "resource";
    static final String ATT_URI = "uri";
    static final String ATT_LOCATION = "location";
    protected Map<String, URI> ePackageNsURIToDynamicModelLocationMap;

    public DynamicPackageRegistryReader() {
        super(RegistryFactory.getRegistry(), EcorePlugin.INSTANCE.getSymbolicName(), "dynamic_package");
    }

    public DynamicPackageRegistryReader(Map<String, URI> ePackageNsURIToDynamicModelLocationMap) {
        this();
        this.ePackageNsURIToDynamicModelLocationMap = ePackageNsURIToDynamicModelLocationMap;
    }

    @Override
    protected boolean readElement(IConfigurationElement element, boolean add) {
        if (element.getName().equals(TAG_RESOURCE)) {
            String packageURI = element.getAttribute(ATT_URI);
            if (packageURI == null) {
                this.logMissingAttribute(element, ATT_URI);
            } else if (element.getAttribute(ATT_LOCATION) == null) {
                this.logMissingAttribute(element, ATT_LOCATION);
            } else {
                if (add) {
                    String dynamicModel;
                    RegistryReader.EPackageDescriptor.Dynamic previous = EPackage.Registry.INSTANCE.put(packageURI, new RegistryReader.EPackageDescriptor.Dynamic(element, ATT_LOCATION));
                    if (previous instanceof RegistryReader.PluginClassDescriptor) {
                        RegistryReader.PluginClassDescriptor descriptor = previous;
                        EcorePlugin.INSTANCE.log("Both '" + descriptor.element.getContributor().getName() + "' and '" + element.getContributor().getName() + "' register a package for '" + packageURI + "'");
                    }
                    if (this.ePackageNsURIToDynamicModelLocationMap != null && (dynamicModel = element.getAttribute(ATT_LOCATION)) != null) {
                        URI dynamicModelURI = URI.createURI((String)dynamicModel);
                        if (dynamicModelURI.isRelative()) {
                            dynamicModelURI = URI.createPlatformPluginURI((String)(String.valueOf(element.getDeclaringExtension().getContributor().getName()) + "/" + dynamicModel), (boolean)true);
                        }
                        this.ePackageNsURIToDynamicModelLocationMap.put(packageURI, dynamicModelURI);
                    }
                    return true;
                }
                EPackage.Registry.INSTANCE.remove(packageURI);
                if (this.ePackageNsURIToDynamicModelLocationMap != null) {
                    this.ePackageNsURIToDynamicModelLocationMap.remove(packageURI);
                }
                return true;
            }
        }
        return false;
    }
}

