/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.jetty.util.Attributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface ComplianceViolation {
    public String getName();

    public String getURL();

    public String getDescription();

    default public boolean isAllowedBy(Mode mode) {
        return mode.allows(this);
    }

    public static interface Mode {
        public String getName();

        public boolean allows(ComplianceViolation var1);

        public Set<? extends ComplianceViolation> getKnown();

        public Set<? extends ComplianceViolation> getAllowed();
    }

    public static class CapturingListener
    implements Listener {
        public static final String VIOLATIONS_ATTR_KEY = "org.eclipse.jetty.http.compliance.violations";
        private final List<Event> events;

        public CapturingListener() {
            this(null);
        }

        private CapturingListener(List<Event> events) {
            this.events = events;
        }

        @Override
        public Listener initialize() {
            return new CapturingListener(new ArrayList<Event>());
        }

        @Override
        public void onRequestBegin(Attributes request) {
            if (request != null) {
                request.setAttribute(VIOLATIONS_ATTR_KEY, this.events);
            }
        }

        @Override
        public void onComplianceViolation(Event event) {
            this.events.add(event);
        }
    }

    public static class LoggingListener
    implements Listener {
        private static final Logger LOG = LoggerFactory.getLogger(ComplianceViolation.class);

        @Override
        public void onComplianceViolation(Event event) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(event.toString());
            }
        }
    }

    public static interface Listener {
        public static final Listener NOOP = new Listener(){};

        default public Listener initialize() {
            return this;
        }

        default public void onRequestBegin(Attributes request) {
        }

        default public void onRequestEnd(Attributes request) {
        }

        default public void onComplianceViolation(Event event) {
            this.onComplianceViolation(event.mode, event.violation, event.details);
        }

        @Deprecated(since="12.0.6", forRemoval=true)
        default public void onComplianceViolation(Mode mode, ComplianceViolation violation, String details) {
        }
    }

    public record Event(Mode mode, ComplianceViolation violation, String details) {
        @Override
        public String toString() {
            return String.format("%s (see %s) in mode %s for %s", this.violation.getDescription(), this.violation.getURL(), this.mode, this.details);
        }
    }
}

