/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.project.wizards;

import java.util.ArrayList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfExperimentElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfNavigatorContentProvider;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfNavigatorLabelProvider;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.tracecompass.tmf.ui.project.wizards.Messages;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;

public class SelectRootNodeWizardPage
extends WizardPage {
    private final TmfExperimentElement fExperiment;
    private CheckboxTreeViewer fCheckboxTreeViewer;
    private TmfNavigatorContentProvider fContentProvider;
    private TmfNavigatorLabelProvider fLabelProvider;
    private TmfTraceElement rootNode;

    protected SelectRootNodeWizardPage(TmfExperimentElement experiment) {
        super("");
        this.fExperiment = experiment;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        this.setControl((Control)container);
        this.setTitle(Messages.SelectRootNodeWizardPage_WindowTitle);
        this.setDescription(Messages.SelectRootNodeWizardPage_Description);
        new FilteredTree(container, 2818, new PatternFilter(), true){

            protected TreeViewer doCreateTreeViewer(Composite aparent, int style) {
                return SelectRootNodeWizardPage.this.doCreateTreeViewer(aparent);
            }
        };
    }

    private TreeViewer doCreateTreeViewer(Composite parent) {
        this.fCheckboxTreeViewer = new CheckboxTreeViewer(parent, 2048);
        this.fCheckboxTreeViewer.setUseHashlookup(true);
        this.fContentProvider = new TmfNavigatorContentProvider(){

            @Override
            public Object[] getElements(Object inputElement) {
                return this.getChildren(inputElement);
            }

            @Override
            public synchronized Object[] getChildren(Object parentElement) {
                if (parentElement instanceof TmfExperimentElement) {
                    return ((TmfExperimentElement)parentElement).getTraces().toArray();
                }
                return null;
            }

            @Override
            public boolean hasChildren(Object element) {
                if (element instanceof TmfExperimentElement) {
                    return !((TmfExperimentElement)element).getTraces().isEmpty();
                }
                return false;
            }
        };
        this.fCheckboxTreeViewer.setContentProvider((IContentProvider)this.fContentProvider);
        this.fLabelProvider = new TmfNavigatorLabelProvider();
        this.fCheckboxTreeViewer.setLabelProvider((IBaseLabelProvider)this.fLabelProvider);
        this.fCheckboxTreeViewer.setComparator(new ViewerComparator());
        Tree tree = this.fCheckboxTreeViewer.getTree();
        GridData gd = new GridData(4, 4, true, true);
        tree.setLayoutData((Object)gd);
        tree.setHeaderVisible(true);
        TreeViewerColumn column = new TreeViewerColumn((TreeViewer)this.fCheckboxTreeViewer, 0);
        column.getColumn().setText(Messages.SelectRootNodeWizardPage_TraceColumnHeader);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return SelectRootNodeWizardPage.this.fLabelProvider.getText(element);
            }

            public Image getImage(Object element) {
                return SelectRootNodeWizardPage.this.fLabelProvider.getImage(element);
            }
        });
        this.fCheckboxTreeViewer.setInput((Object)this.fExperiment);
        column.getColumn().pack();
        this.fCheckboxTreeViewer.addCheckStateListener(event -> {
            Object element = event.getElement();
            Object[] objectArray = this.fCheckboxTreeViewer.getCheckedElements();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object checkedElement = objectArray[n2];
                this.fCheckboxTreeViewer.setChecked(checkedElement, false);
                ++n2;
            }
            this.fCheckboxTreeViewer.setChecked(element, event.getChecked());
            this.setPageComplete(event.getChecked());
        });
        this.setPageComplete(true);
        this.fCheckboxTreeViewer.getTree().getItem(0).setChecked(true);
        return this.fCheckboxTreeViewer;
    }

    public boolean performFinish() {
        TmfTraceElement[] selection = this.getSelection();
        if (selection.length > 0 && selection[0] != null) {
            this.setRootNode(selection[0]);
        }
        return true;
    }

    private @NonNull TmfTraceElement[] getSelection() {
        Object[] selection;
        ArrayList<TmfTraceElement> traces = new ArrayList<TmfTraceElement>();
        Object[] objectArray = selection = this.fCheckboxTreeViewer.getCheckedElements();
        int n = selection.length;
        int n2 = 0;
        while (n2 < n) {
            Object sel = objectArray[n2];
            if (sel instanceof TmfTraceElement) {
                traces.add((TmfTraceElement)sel);
            }
            ++n2;
        }
        return traces.toArray(new TmfTraceElement[0]);
    }

    public TmfTraceElement getRootNode() {
        return this.rootNode;
    }

    private void setRootNode(TmfTraceElement rootNode) {
        this.rootNode = rootNode;
    }
}

