/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTToken;
import org.eclipse.cdt.core.dom.ast.IASTTokenList;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;

public class ASTTokenList
extends ASTNode
implements IASTTokenList {
    private IASTToken[] tokens = IASTToken.EMPTY_TOKEN_ARRAY;

    @Override
    public ASTTokenList copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public ASTTokenList copy(IASTNode.CopyStyle style) {
        ASTTokenList copy = new ASTTokenList();
        IASTToken[] iASTTokenArray = this.tokens;
        int n = this.tokens.length;
        int n2 = 0;
        while (n2 < n) {
            IASTToken token = iASTTokenArray[n2];
            if (token == null) break;
            copy.addToken(token.copy(style));
            ++n2;
        }
        return this.copy(copy, style);
    }

    @Override
    public IASTToken[] getTokens() {
        this.tokens = ArrayUtil.trim(this.tokens);
        return this.tokens;
    }

    @Override
    public void addToken(IASTToken token) {
        this.tokens = ArrayUtil.append(this.tokens, token);
    }

    @Override
    public int getTokenType() {
        IASTToken[] tok = this.getTokens();
        return tok != null && tok.length == 1 ? tok[0].getTokenType() : 0;
    }

    @Override
    public char[] getTokenCharImage() {
        IASTToken[] tok = this.getTokens();
        return tok != null && tok.length == 1 ? tok[0].getTokenCharImage() : null;
    }

    @Override
    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitTokens) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        IASTToken[] iASTTokenArray = this.tokens;
        int n = this.tokens.length;
        int n2 = 0;
        while (n2 < n) {
            IASTToken token = iASTTokenArray[n2];
            if (token == null) break;
            if (!token.accept(action)) {
                return false;
            }
            ++n2;
        }
        return !action.shouldVisitTokens || action.leave(this) != 2;
    }
}

