/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.provisional.analysis.lami.core.types;

import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.types.LamiData;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.types.LamiTimestamp;

public class LamiTimeRange
extends LamiData {
    private final LamiTimestamp fBegin;
    private final LamiTimestamp fEnd;
    private final @Nullable Long fDuration;

    public LamiTimeRange(LamiTimestamp begin, LamiTimestamp end) {
        this.fBegin = begin;
        this.fEnd = end;
        Long beginLong = this.fBegin.getValue();
        Long endLong = this.fEnd.getValue();
        this.fDuration = beginLong != null && endLong != null ? Long.valueOf(endLong - beginLong) : null;
    }

    public LamiTimestamp getBegin() {
        return this.fBegin;
    }

    public LamiTimestamp getEnd() {
        return this.fEnd;
    }

    public @Nullable Long getDuration() {
        return this.fDuration;
    }

    @Override
    public @Nullable String toString() {
        Long startValue = this.fBegin.getValue();
        Long endValue = this.fEnd.getValue();
        if (startValue != null && endValue != null) {
            return "[" + String.valueOf(this.fBegin) + " - " + String.valueOf(this.fEnd) + "]";
        }
        return null;
    }

    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        LamiTimeRange timeRange = (LamiTimeRange)object;
        return this.fBegin.equals(timeRange.fBegin) && this.fEnd.equals(timeRange.fEnd);
    }

    public int hashCode() {
        return Objects.hash(this.fBegin, this.fEnd);
    }
}

