/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.provisional.analysis.lami.core.aspect;

import java.util.Comparator;
import java.util.function.Function;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.module.LamiTableEntry;

final class LamiComparators {
    private LamiComparators() {
    }

    public static Comparator<LamiTableEntry> getLongComparator(Function<LamiTableEntry, @Nullable Number> resolveNumber) {
        return (o1, o2) -> {
            Number leftNumber = (Number)resolveNumber.apply((LamiTableEntry)o1);
            Number rightNumber = (Number)resolveNumber.apply((LamiTableEntry)o2);
            if (leftNumber == null && rightNumber == null) {
                return 0;
            }
            if (leftNumber == null) {
                return 1;
            }
            if (rightNumber == null) {
                return -1;
            }
            return Long.compare(leftNumber.longValue(), rightNumber.longValue());
        };
    }

    public static Comparator<LamiTableEntry> getDoubleComparator(Function<LamiTableEntry, @Nullable Number> resolveNumber) {
        return (o1, o2) -> {
            Number leftNumber = (Number)resolveNumber.apply((LamiTableEntry)o1);
            Number rightNumber = (Number)resolveNumber.apply((LamiTableEntry)o2);
            if (leftNumber == null && rightNumber == null) {
                return 0;
            }
            if (leftNumber == null) {
                return 1;
            }
            if (rightNumber == null) {
                return -1;
            }
            return Double.compare(leftNumber.doubleValue(), rightNumber.doubleValue());
        };
    }

    public static Comparator<LamiTableEntry> getStringComparator(Function<LamiTableEntry, @Nullable String> resolveString) {
        return (o1, o2) -> {
            String leftString = (String)resolveString.apply((LamiTableEntry)o1);
            String rightString = (String)resolveString.apply((LamiTableEntry)o2);
            if (leftString == null && rightString == null) {
                return 0;
            }
            if (leftString == null) {
                return 1;
            }
            if (rightString == null) {
                return -1;
            }
            return leftString.compareTo(rightString);
        };
    }
}

