/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.internal.core.dom.parser.ISerializableType;
import org.eclipse.cdt.internal.core.dom.parser.ITypeMarshalBuffer;
import org.eclipse.core.runtime.CoreException;

public class CPPPlaceholderType
implements ISerializableType,
IType {
    private final PlaceholderKind fPlaceholderKind;

    public CPPPlaceholderType(PlaceholderKind placeholderKind) {
        this.fPlaceholderKind = placeholderKind;
    }

    public PlaceholderKind getPlaceholderKind() {
        return this.fPlaceholderKind;
    }

    @Override
    public void marshal(ITypeMarshalBuffer buffer) throws CoreException {
        short firstBytes = 20;
        if (this.fPlaceholderKind == PlaceholderKind.DecltypeAuto) {
            firstBytes = (short)(firstBytes | 0x20);
        }
        buffer.putShort(firstBytes);
    }

    @Override
    public boolean isSameType(IType type) {
        if (type instanceof CPPPlaceholderType) {
            return this.fPlaceholderKind == ((CPPPlaceholderType)type).fPlaceholderKind;
        }
        return false;
    }

    @Override
    public Object clone() {
        IType t = null;
        try {
            t = (IType)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return t;
    }

    public static IType unmarshal(short firstBytes, ITypeMarshalBuffer buffer) {
        PlaceholderKind kind = (firstBytes & 0x20) != 0 ? PlaceholderKind.DecltypeAuto : PlaceholderKind.Auto;
        return new CPPPlaceholderType(kind);
    }

    public static enum PlaceholderKind {
        Auto,
        DecltypeAuto;

    }
}

