/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.model.tree;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.TableColumnDescriptor;
import org.eclipse.tracecompass.tmf.core.dataprovider.DataType;
import org.eclipse.tracecompass.tmf.core.model.ITableColumnDescriptor;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeModel;
import org.eclipse.tracecompass.tmf.tests.stubs.model.tree.TmfTreeDataModelStub;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

@NonNullByDefault
public class TmfTreeModelTest {
    private static final int NB_COLUMNS = 4;
    private static final int NB_ROWS = 5;
    private static final long PARENT_ID = 100L;
    private static final DataType DATA_TYPE = DataType.STRING;
    private static final String HEADER_PREFIX = "header";
    private static final String TOOLTIP_PREFIX = "tooltip";
    private static final String LABEL_PREFIX = "label";
    private static final String TEST_SCOPE = "scope";
    private static final int ALL_LEVELS = -1;
    private static final int TEST_LEVEL = 1;
    private static List<ITmfTreeDataModel> fTestEntries = new ArrayList<ITmfTreeDataModel>();
    private static List<String> fTestHeaders = new ArrayList<String>();
    private static List<String> fExpectedEmptyTooltips = new ArrayList<String>();
    private static List<String> fExpectedTooltips = new ArrayList<String>();
    private static List<ITableColumnDescriptor> fTestDescriptors = new ArrayList<ITableColumnDescriptor>();

    @BeforeClass
    public static void initClass() {
        int i = 0;
        while (i < 4) {
            String headerText = HEADER_PREFIX + String.valueOf(i);
            String headerTooltip = TOOLTIP_PREFIX + String.valueOf(i);
            fTestHeaders.add(headerText);
            fExpectedEmptyTooltips.add("");
            fExpectedTooltips.add(headerTooltip);
            TableColumnDescriptor.Builder descBuilder = new TableColumnDescriptor.Builder();
            descBuilder.setText(headerText);
            descBuilder.setTooltip(headerTooltip);
            fTestDescriptors.add((ITableColumnDescriptor)descBuilder.build());
            ++i;
        }
        int k = 0;
        while (k < 5) {
            ArrayList<String> labels = new ArrayList<String>();
            int i2 = 0;
            while (i2 < 4) {
                labels.add(LABEL_PREFIX + String.valueOf(i2));
                ++i2;
            }
            TmfTreeDataModelStub dataModel = new TmfTreeDataModelStub(k, 100L, labels, DATA_TYPE);
            fTestEntries.add(dataModel);
            ++k;
        }
    }

    @Test
    public void testTmfTreeModelConstructor() {
        TmfTreeModel testInstance = new TmfTreeModel(fTestHeaders, fTestEntries);
        TmfTreeModelTest.verifyInstance((TmfTreeModel<ITmfTreeDataModel>)testInstance, fExpectedEmptyTooltips, null, -1);
        testInstance = new TmfTreeModel(fTestHeaders, fTestEntries, TEST_SCOPE);
        TmfTreeModelTest.verifyInstance((TmfTreeModel<ITmfTreeDataModel>)testInstance, fExpectedEmptyTooltips, TEST_SCOPE, -1);
    }

    private static void verifyInstance(TmfTreeModel<ITmfTreeDataModel> testInstance, List<String> tooltips, @Nullable String scope, int autoExpandLevel) {
        Assert.assertEquals((String)"Incorrect list of entries", fTestEntries, (Object)testInstance.getEntries());
        Assert.assertEquals((String)"Incorrect list of entries", fTestHeaders, (Object)testInstance.getHeaders());
        List columnDescriptors = testInstance.getColumnDescriptors();
        Assert.assertEquals((String)"Incorrect number of column descriptors", (long)fTestHeaders.size(), (long)columnDescriptors.size());
        Assert.assertEquals((String)"Incorrect number of column descriptors", (long)tooltips.size(), (long)columnDescriptors.size());
        int i = 0;
        while (i < fTestHeaders.size()) {
            Assert.assertEquals((String)"Incorrect Collumn descriptor header text", (Object)fTestHeaders.get(i), (Object)((ITableColumnDescriptor)columnDescriptors.get(i)).getText());
            Assert.assertEquals((String)"Incorrect Collumn descriptor header tooltip", (Object)tooltips.get(i), (Object)((ITableColumnDescriptor)columnDescriptors.get(i)).getTooltip());
            ++i;
        }
        Assert.assertEquals((String)"Incorrect scope", (Object)scope, (Object)testInstance.getScope());
        Assert.assertEquals((String)"Incorrect autoExpandLevel", (long)autoExpandLevel, (long)testInstance.getAutoExpandLevel());
    }

    @Test
    public void testTmfTreeModelConstructor2() {
        TmfTreeModel.Builder builder = new TmfTreeModel.Builder();
        builder.setColumnDescriptors(fTestDescriptors).setEntries(fTestEntries);
        TmfTreeModel testInstance = builder.build();
        TmfTreeModelTest.verifyInstance((TmfTreeModel<ITmfTreeDataModel>)testInstance, fExpectedTooltips, null, -1);
        builder = new TmfTreeModel.Builder();
        builder.setColumnDescriptors(fTestDescriptors).setEntries(fTestEntries).setScope(TEST_SCOPE);
        testInstance = builder.build();
        TmfTreeModelTest.verifyInstance((TmfTreeModel<ITmfTreeDataModel>)testInstance, fExpectedTooltips, TEST_SCOPE, -1);
        builder = new TmfTreeModel.Builder();
        builder.setColumnDescriptors(fTestDescriptors).setEntries(fTestEntries).setScope(TEST_SCOPE).setAutoExpandLevel(1);
        testInstance = builder.build();
        TmfTreeModelTest.verifyInstance((TmfTreeModel<ITmfTreeDataModel>)testInstance, fExpectedTooltips, TEST_SCOPE, 1);
        builder = new TmfTreeModel.Builder();
        testInstance = builder.build();
        Assert.assertTrue((String)"Entry list not empty", (boolean)testInstance.getEntries().isEmpty());
        Assert.assertTrue((String)"Column descriptor list not empty", (boolean)testInstance.getColumnDescriptors().isEmpty());
    }
}

