/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.profiling.core.tests.flamechart;

import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.analysis.profiling.core.tests.CallStackTestBase;
import org.eclipse.tracecompass.analysis.profiling.core.tests.data.TestDataSmallCallStack;
import org.eclipse.tracecompass.analysis.profiling.core.tests.stubs.CallStackAnalysisStub;
import org.eclipse.tracecompass.segmentstore.core.ISegmentStore;
import org.junit.Assert;
import org.junit.Test;

public class CallStackSegmentStoreTest
extends CallStackTestBase {
    public CallStackSegmentStoreTest() {
        super(new TestDataSmallCallStack());
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testSeriesSegmentStoreIterator() {
        CallStackAnalysisStub module = this.getModule();
        Assert.assertNotNull((Object)((Object)module));
        @NonNull ISegmentStore segmentStore = module.getSegmentStore();
        Assert.assertNotNull((Object)segmentStore);
        @NonNull Iterator iterator = segmentStore.iterator();
        Assert.assertEquals((String)"Segment store iterator count", (long)21L, (long)Iterators.size((Iterator)iterator));
        Assert.assertEquals((String)"Segment store size", (long)21L, (long)segmentStore.size());
        Assert.assertFalse((boolean)segmentStore.isEmpty());
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testIntersectingSegmentStore() {
        CallStackAnalysisStub module = this.getModule();
        Assert.assertNotNull((Object)((Object)module));
        @NonNull ISegmentStore segmentStore = module.getSegmentStore();
        Assert.assertNotNull((Object)segmentStore);
        @NonNull Iterable elements = segmentStore.getIntersectingElements(10L);
        Assert.assertEquals((String)"Intersecting 10", (long)9L, (long)Iterables.size((Iterable)elements));
        elements = segmentStore.getIntersectingElements(10L, 15L);
        Assert.assertEquals((String)"Between 10 and 15", (long)12L, (long)Iterables.size((Iterable)elements));
    }
}

