/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.console.commands;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.felix.service.command.CommandSession;
import org.apache.felix.service.command.Converter;
import org.apache.felix.service.command.Descriptor;
import org.apache.felix.service.command.Parameter;
import org.eclipse.equinox.console.command.adapter.Activator;
import org.eclipse.equinox.console.commands.ConsoleMsg;
import org.eclipse.equinox.console.commands.EquinoxCommandsConverter;
import org.eclipse.equinox.console.commands.Util;
import org.eclipse.osgi.report.resolution.ResolutionReport;
import org.eclipse.osgi.service.environment.EnvironmentInfo;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.framework.hooks.resolver.ResolverHook;
import org.osgi.framework.hooks.resolver.ResolverHookFactory;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleRevisions;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.framework.wiring.FrameworkWiring;
import org.osgi.resource.Resource;
import org.osgi.service.condpermadmin.ConditionalPermissionAdmin;
import org.osgi.service.condpermadmin.ConditionalPermissionInfo;
import org.osgi.service.condpermadmin.ConditionalPermissionUpdate;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.permissionadmin.PermissionAdmin;

public class EquinoxCommandProvider
implements SynchronousBundleListener {
    private final BundleContext context;
    private ServiceRegistration<?> providerReg;
    private ServiceRegistration<?> converterReg;
    private static final String tab = "\t";
    private static final String newline = "\r\n";
    private final List<Bundle> lazyActivation = new ArrayList<Bundle>();
    private Activator activator;
    private static final String[] functions = new String[]{"exit", "shutdown", "sta", "start", "sto", "stop", "i", "install", "up", "up", "up", "update", "update", "update", "un", "uninstall", "s", "status", "se", "services", "p", "p", "packages", "packages", "bundles", "b", "bundle", "gc", "init", "close", "r", "refresh", "exec", "fork", "h", "headers", "pr", "props", "setp", "setprop", "ss", "t", "threads", "sl", "setfwsl", "setbsl", "setibsl", "requiredBundles", "classSpaces", "profilelog", "getPackages", "getprop", "diag", "enableBundle", "disableBundle", "disabledBundles"};

    public EquinoxCommandProvider(BundleContext context, Activator activator) {
        this.context = context;
        this.activator = activator;
    }

    public void startService() {
        EquinoxCommandsConverter converter = new EquinoxCommandsConverter(this.context);
        this.converterReg = this.context.registerService(Converter.class.getName(), (Object)converter, null);
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put("service.ranking", Integer.MAX_VALUE);
        ((Dictionary)props).put("osgi.command.scope", "equinox");
        ((Dictionary)props).put("osgi.command.function", functions);
        this.providerReg = this.context.registerService(EquinoxCommandProvider.class.getName(), (Object)this, props);
        this.context.addBundleListener((BundleListener)this);
    }

    public void stopService() {
        if (this.converterReg != null) {
            this.converterReg.unregister();
        }
        this.context.removeBundleListener((BundleListener)this);
        if (this.providerReg != null) {
            this.providerReg.unregister();
        }
    }

    @Descriptor(value="exit immediately (System.exit)")
    public void exit(CommandSession session) throws Exception {
        if (this.confirmStop(session)) {
            System.out.println();
            System.exit(0);
        }
    }

    @Descriptor(value="shutdown the OSGi Framework")
    public void shutdown() throws Exception {
        this.context.getBundle(0L).stop();
    }

    @Descriptor(value="start the specified bundle(s)")
    public void sta(@Descriptor(value="bundle(s) to start") Bundle[] bundles) throws Exception {
        this.start(bundles);
    }

    @Descriptor(value="start the specified bundle(s)")
    public void start(@Descriptor(value="bundle(s) to start") Bundle[] bundles) throws Exception {
        if (bundles == null) {
            System.out.println(ConsoleMsg.CONSOLE_NO_BUNDLE_SPECIFIED_ERROR);
            return;
        }
        if (bundles.length == 0) {
            System.out.println(ConsoleMsg.CONSOLE_NO_BUNDLE_SPECIFIED_ERROR);
            return;
        }
        Bundle[] bundleArray = bundles;
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            bundle.start();
            ++n2;
        }
    }

    @Descriptor(value="stop the specified bundle(s)")
    public void sto(@Descriptor(value="bundle(s) to stop") Bundle[] bundles) throws Exception {
        this.stop(bundles);
    }

    @Descriptor(value="stop the specified bundle(s)")
    public void stop(@Descriptor(value="bundle(s) to stop") Bundle[] bundles) throws Exception {
        if (bundles == null) {
            System.out.println(ConsoleMsg.CONSOLE_NO_BUNDLE_SPECIFIED_ERROR);
            return;
        }
        if (bundles.length == 0) {
            System.out.println(ConsoleMsg.CONSOLE_NO_BUNDLE_SPECIFIED_ERROR);
            return;
        }
        Bundle[] bundleArray = bundles;
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            bundle.stop();
            ++n2;
        }
    }

    @Descriptor(value="install and optionally start bundle from the given URL")
    public void i(@Descriptor(value="specify if the bundle should be started after installation") @Parameter(absentValue="false", presentValue="true", names={"-start"}) boolean shouldStart, @Descriptor(value="Location of bundle to install") String url) throws Exception {
        this.install(shouldStart, url);
    }

    @Descriptor(value="install and optionally start bundle from the given URL")
    public Bundle install(@Descriptor(value="specify if the bundle should be started after installation") @Parameter(absentValue="false", presentValue="true", names={"-start"}) boolean shouldStart, @Descriptor(value="Location of bundle to install") String url) throws Exception {
        if (url == null) {
            System.out.println(ConsoleMsg.CONSOLE_NOTHING_TO_INSTALL_ERROR);
            return null;
        }
        Bundle bundle = this.context.installBundle(url);
        System.out.print(ConsoleMsg.CONSOLE_BUNDLE_ID_MESSAGE);
        System.out.println(bundle.getBundleId());
        if (shouldStart) {
            bundle.start();
        }
        return bundle;
    }

    @Descriptor(value="update the specified bundle(s)")
    public void up(@Descriptor(value="bundle(s) to update") Bundle[] bundles) throws Exception {
        this.update(bundles);
    }

    @Descriptor(value="Update the specified bundle from the specified location")
    public void up(@Descriptor(value="Bundle to update") Bundle bundle, @Descriptor(value="Location of the new bundle content") URL source) throws Exception {
        this.update(bundle, source);
    }

    @Descriptor(value="update the specified bundle(s)")
    public void update(@Descriptor(value="bundle(s) to update") Bundle[] bundles) throws Exception {
        if (bundles == null) {
            System.out.println(ConsoleMsg.CONSOLE_NO_BUNDLE_SPECIFIED_ERROR);
            return;
        }
        if (bundles.length == 0) {
            System.out.println(ConsoleMsg.CONSOLE_NO_BUNDLE_SPECIFIED_ERROR);
            return;
        }
        Bundle[] bundleArray = bundles;
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            bundle.update();
            ++n2;
        }
    }

    @Descriptor(value="Update the specified bundle from the specified location")
    public void update(@Descriptor(value="Bundle to update") Bundle bundle, @Descriptor(value="Location of the new bundle content") URL source) throws Exception {
        bundle.update(source.openStream());
    }

    @Descriptor(value="uninstall the specified bundle(s)")
    public void un(@Descriptor(value="bundle(s) to uninstall") Bundle[] bundles) throws Exception {
        this.uninstall(bundles);
    }

    @Descriptor(value="uninstall the specified bundle(s)")
    public void uninstall(@Descriptor(value="bundle(s) to uninstall") Bundle[] bundles) throws Exception {
        if (bundles == null) {
            System.out.println(ConsoleMsg.CONSOLE_NO_BUNDLE_SPECIFIED_ERROR);
            return;
        }
        if (bundles.length == 0) {
            System.out.println(ConsoleMsg.CONSOLE_NO_BUNDLE_SPECIFIED_ERROR);
            return;
        }
        Bundle[] bundleArray = bundles;
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            bundle.uninstall();
            ++n2;
        }
    }

    private int getStatesFromConstants(String states) throws IllegalArgumentException {
        int stateFilter = -1;
        if (!states.equals("")) {
            StringTokenizer tokens = new StringTokenizer(states, ",");
            while (tokens.hasMoreElements()) {
                String desiredState = (String)tokens.nextElement();
                Field match = null;
                try {
                    match = Bundle.class.getField(desiredState.toUpperCase());
                    if (stateFilter == -1) {
                        stateFilter = 0;
                    }
                    stateFilter |= match.getInt(match);
                }
                catch (IllegalAccessException | NoSuchFieldException e) {
                    System.out.println(String.valueOf(ConsoleMsg.CONSOLE_INVALID_INPUT) + ": " + desiredState);
                    throw new IllegalArgumentException();
                }
            }
        }
        return stateFilter;
    }

    @Descriptor(value="display installed bundles and registered services")
    public void s(String ... arguments) throws Exception {
        this.status(arguments);
    }

    @Descriptor(value="display installed bundles and registered services")
    public void status(String ... arguments) throws Exception {
        int stateFilter;
        if (this.context.getBundle(0L).getState() == 32) {
            System.out.println(ConsoleMsg.CONSOLE_FRAMEWORK_IS_LAUNCHED_MESSAGE);
        } else {
            System.out.println(ConsoleMsg.CONSOLE_FRAMEWORK_IS_SHUTDOWN_MESSAGE);
        }
        System.out.println();
        String states = "";
        String[] bsnSegments = null;
        if (arguments != null && arguments.length > 0) {
            if (arguments[0].equals("-s")) {
                if (arguments.length > 1) {
                    states = arguments[1];
                    if (arguments.length > 2) {
                        bsnSegments = new String[arguments.length - 2];
                        System.arraycopy(arguments, 2, bsnSegments, 0, bsnSegments.length);
                    }
                }
            } else {
                bsnSegments = arguments;
            }
        }
        try {
            stateFilter = this.getStatesFromConstants(states);
        }
        catch (IllegalArgumentException e) {
            return;
        }
        Bundle[] bundles = this.context.getBundles();
        int size = bundles.length;
        if (size == 0) {
            System.out.println(ConsoleMsg.CONSOLE_NO_INSTALLED_BUNDLES_ERROR);
            return;
        }
        System.out.print(ConsoleMsg.CONSOLE_ID);
        System.out.print(tab);
        System.out.println(ConsoleMsg.CONSOLE_BUNDLE_LOCATION_MESSAGE);
        System.out.println(ConsoleMsg.CONSOLE_STATE_BUNDLE_FILE_NAME_HEADER);
        int i = 0;
        while (i < size) {
            Bundle bundle = bundles[i];
            if (this.match(bundle, bsnSegments, stateFilter)) {
                System.out.print(bundle.getBundleId());
                System.out.print(tab);
                System.out.println(bundle.getLocation());
                System.out.print("  ");
                System.out.print(this.getStateName(bundle));
                System.out.println(bundle.toString());
            }
            ++i;
        }
        ServiceReference[] services = this.context.getServiceReferences(null, null);
        if (services != null) {
            System.out.println(ConsoleMsg.CONSOLE_REGISTERED_SERVICES_MESSAGE);
            ServiceReference[] serviceReferenceArray = services;
            int n = services.length;
            int n2 = 0;
            while (n2 < n) {
                ServiceReference service = serviceReferenceArray[n2];
                System.out.println(service);
                ++n2;
            }
        }
    }

    @Descriptor(value="display registered service details. Examples for [filter]: (objectClass=com.xyz.Person); (&(objectClass=com.xyz.Person)(sn=Jensen)); passing only com.xyz.Person is a shortcut for (objectClass=com.xyz.Person). The filter syntax specification is available at http://www.ietf.org/rfc/rfc1960.txt")
    public void se(String ... filters) throws Exception {
        this.services(filters);
    }

    @Descriptor(value="display registered service details. Examples for [filter]: (objectClass=com.xyz.Person); (&(objectClass=com.xyz.Person)(sn=Jensen)); passing only com.xyz.Person is a shortcut for (objectClass=com.xyz.Person). The filter syntax specification is available at http://www.ietf.org/rfc/rfc1960.txt")
    public void services(String ... filters) throws Exception {
        int size;
        String filter = null;
        if (filters != null && filters.length > 0) {
            StringBuilder buf = new StringBuilder();
            String[] stringArray = filters;
            int n = filters.length;
            int n2 = 0;
            while (n2 < n) {
                String singleFilter = stringArray[n2];
                buf.append(' ');
                buf.append(singleFilter);
                ++n2;
            }
            filter = buf.toString();
        }
        InvalidSyntaxException originalException = null;
        ServiceReference[] services = null;
        try {
            services = this.context.getServiceReferences(null, filter);
        }
        catch (InvalidSyntaxException e) {
            originalException = e;
        }
        if (filter != null) {
            filter = filter.trim();
        }
        if (originalException != null && !filter.startsWith("(") && !filter.contains(" ")) {
            try {
                filter = "(objectClass=" + filter + ")";
                services = this.context.getServiceReferences(null, filter);
            }
            catch (InvalidSyntaxException e) {
                throw originalException;
            }
        } else if (originalException != null) {
            throw originalException;
        }
        if (services != null && (size = services.length) > 0) {
            int j = 0;
            while (j < size) {
                ServiceReference service = services[j];
                System.out.println(service);
                System.out.print("  ");
                System.out.print(ConsoleMsg.CONSOLE_REGISTERED_BY_BUNDLE_MESSAGE);
                System.out.print(" ");
                System.out.println(service.getBundle());
                Bundle[] users = service.getUsingBundles();
                if (users != null) {
                    System.out.print("  ");
                    System.out.println(ConsoleMsg.CONSOLE_BUNDLES_USING_SERVICE_MESSAGE);
                    Bundle[] bundleArray = users;
                    int n = users.length;
                    int n3 = 0;
                    while (n3 < n) {
                        Bundle user = bundleArray[n3];
                        System.out.print("    ");
                        System.out.println(user);
                        ++n3;
                    }
                } else {
                    System.out.print("  ");
                    System.out.println(ConsoleMsg.CONSOLE_NO_BUNDLES_USING_SERVICE_MESSAGE);
                }
                ++j;
            }
            return;
        }
        System.out.println(ConsoleMsg.CONSOLE_NO_REGISTERED_SERVICES_MESSAGE);
    }

    @Descriptor(value="display imported/exported package details")
    public void p(Bundle ... bundle) throws Exception {
        this.packages(bundle);
    }

    @Descriptor(value="display imported/exported package details")
    public void p(@Descriptor(value="Package name of the package to display") String packageName) throws Exception {
        this.packages(packageName);
    }

    @Descriptor(value="display imported/exported package details")
    public void packages(Bundle ... bundle) throws Exception {
        if (this.activator.getPackageAdmin() != null) {
            ExportedPackage[] exportedPackages = bundle != null && bundle.length > 0 ? this.activator.getPackageAdmin().getExportedPackages(bundle[0]) : this.activator.getPackageAdmin().getExportedPackages(null);
            this.getPackages(exportedPackages);
        } else {
            System.out.println(ConsoleMsg.CONSOLE_NO_EXPORTED_PACKAGES_NO_PACKAGE_ADMIN_MESSAGE);
        }
    }

    @Descriptor(value="display imported/exported package details")
    public void packages(@Descriptor(value="Package name of the package to display") String packageName) throws Exception {
        if (this.activator.getPackageAdmin() != null) {
            ExportedPackage[] exportedPackages = this.activator.getPackageAdmin().getExportedPackages(packageName);
            this.getPackages(exportedPackages);
        } else {
            System.out.println(ConsoleMsg.CONSOLE_NO_EXPORTED_PACKAGES_NO_PACKAGE_ADMIN_MESSAGE);
        }
    }

    private void getPackages(ExportedPackage[] packages) throws Exception {
        if (packages == null) {
            System.out.println(ConsoleMsg.CONSOLE_NO_EXPORTED_PACKAGES_MESSAGE);
            return;
        }
        ExportedPackage[] exportedPackageArray = packages;
        int n = packages.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle exporter;
            ExportedPackage pkg = exportedPackageArray[n2];
            System.out.print(pkg);
            boolean removalPending = pkg.isRemovalPending();
            if (removalPending) {
                System.out.print("(");
                System.out.print(ConsoleMsg.CONSOLE_REMOVAL_PENDING_MESSAGE);
                System.out.println(")");
            }
            if ((exporter = pkg.getExportingBundle()) != null) {
                Bundle[] importers;
                System.out.print("<");
                System.out.print(exporter);
                System.out.println(">");
                Bundle[] bundleArray = importers = pkg.getImportingBundles();
                int n3 = importers.length;
                int n4 = 0;
                while (n4 < n3) {
                    Bundle importer = bundleArray[n4];
                    System.out.print("  ");
                    System.out.print(importer);
                    System.out.print(" ");
                    System.out.println(ConsoleMsg.CONSOLE_IMPORTS_MESSAGE);
                    ++n4;
                }
            } else {
                System.out.print("<");
                System.out.print(ConsoleMsg.CONSOLE_STALE_MESSAGE);
                System.out.println(">");
            }
            ++n2;
        }
    }

    @Descriptor(value="display details for all installed bundles")
    public void bundles(String ... arguments) throws Exception {
        int stateFilter;
        String states = "";
        String[] bsnSegments = null;
        if (arguments != null && arguments.length > 0) {
            if (arguments[0].equals("-s")) {
                if (arguments.length > 1) {
                    states = arguments[1];
                    if (arguments.length > 2) {
                        bsnSegments = new String[arguments.length - 2];
                        System.arraycopy(arguments, 2, bsnSegments, 0, bsnSegments.length);
                    }
                }
            } else {
                bsnSegments = arguments;
            }
        }
        try {
            stateFilter = this.getStatesFromConstants(states);
        }
        catch (IllegalArgumentException e) {
            return;
        }
        Bundle[] bundles = this.context.getBundles();
        int size = bundles.length;
        if (size == 0) {
            System.out.println(ConsoleMsg.CONSOLE_NO_INSTALLED_BUNDLES_ERROR);
            return;
        }
        int i = 0;
        while (i < size) {
            Bundle bundle = bundles[i];
            if (this.match(bundle, bsnSegments, stateFilter)) {
                ServiceReference service;
                int n;
                int n2;
                ServiceReference[] serviceReferenceArray;
                long id = bundle.getBundleId();
                System.out.println(bundle);
                System.out.print("  ");
                System.out.print(NLS.bind((String)ConsoleMsg.CONSOLE_ID_MESSAGE, (Object)String.valueOf(id)));
                System.out.print(", ");
                System.out.print(NLS.bind((String)ConsoleMsg.CONSOLE_STATUS_MESSAGE, (Object)this.getStateName(bundle)));
                if (id != 0L) {
                    File dataRoot = bundle.getDataFile("");
                    String root = dataRoot == null ? null : dataRoot.getAbsolutePath();
                    System.out.print(NLS.bind((String)ConsoleMsg.CONSOLE_DATA_ROOT_MESSAGE, (Object)root));
                } else {
                    System.out.println();
                }
                ServiceReference[] services = bundle.getRegisteredServices();
                if (services != null) {
                    System.out.print("  ");
                    System.out.println(ConsoleMsg.CONSOLE_REGISTERED_SERVICES_MESSAGE);
                    serviceReferenceArray = services;
                    n2 = services.length;
                    n = 0;
                    while (n < n2) {
                        service = serviceReferenceArray[n];
                        System.out.print("    ");
                        System.out.println(service);
                        ++n;
                    }
                } else {
                    System.out.print("  ");
                    System.out.println(ConsoleMsg.CONSOLE_NO_REGISTERED_SERVICES_MESSAGE);
                }
                services = bundle.getServicesInUse();
                if (services != null) {
                    System.out.print("  ");
                    System.out.println(ConsoleMsg.CONSOLE_SERVICES_IN_USE_MESSAGE);
                    serviceReferenceArray = services;
                    n2 = services.length;
                    n = 0;
                    while (n < n2) {
                        service = serviceReferenceArray[n];
                        System.out.print("    ");
                        System.out.println(service);
                        ++n;
                    }
                } else {
                    System.out.print("  ");
                    System.out.println(ConsoleMsg.CONSOLE_NO_SERVICES_IN_USE_MESSAGE);
                }
            }
            ++i;
        }
    }

    @Descriptor(value="display details for the specified bundle(s)")
    public void b(@Descriptor(value="(<id>|<location>)") Bundle[] bundles) throws Exception {
        this.bundle(bundles);
    }

    @Descriptor(value="display details for the specified bundle(s)")
    public void bundle(@Descriptor(value="(<id>|<location>)") Bundle[] bundles) throws Exception {
        if (bundles.length == 0) {
            System.out.println(ConsoleMsg.CONSOLE_NO_BUNDLE_SPECIFIED_ERROR);
            return;
        }
        Bundle[] bundleArray = bundles;
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            BundleWiring wiring;
            ServiceReference service;
            int n3;
            int n4;
            ServiceReference[] serviceReferenceArray;
            Bundle bundle = bundleArray[n2];
            long id = bundle.getBundleId();
            System.out.println(bundle);
            System.out.print("  ");
            System.out.print(NLS.bind((String)ConsoleMsg.CONSOLE_ID_MESSAGE, (Object)String.valueOf(id)));
            System.out.print(", ");
            System.out.print(NLS.bind((String)ConsoleMsg.CONSOLE_STATUS_MESSAGE, (Object)this.getStateName(bundle)));
            if (id != 0L) {
                File dataRoot = bundle.getDataFile("");
                String root = dataRoot == null ? null : dataRoot.getAbsolutePath();
                System.out.print(NLS.bind((String)ConsoleMsg.CONSOLE_DATA_ROOT_MESSAGE, (Object)root));
                System.out.println();
            } else {
                System.out.println();
            }
            ServiceReference[] services = bundle.getRegisteredServices();
            if (services != null) {
                System.out.print("  ");
                System.out.println(ConsoleMsg.CONSOLE_REGISTERED_SERVICES_MESSAGE);
                serviceReferenceArray = services;
                n4 = services.length;
                n3 = 0;
                while (n3 < n4) {
                    service = serviceReferenceArray[n3];
                    System.out.print("    ");
                    System.out.println(service);
                    ++n3;
                }
            } else {
                System.out.print("  ");
                System.out.println(ConsoleMsg.CONSOLE_NO_REGISTERED_SERVICES_MESSAGE);
            }
            services = bundle.getServicesInUse();
            if (services != null) {
                System.out.print("  ");
                System.out.println(ConsoleMsg.CONSOLE_SERVICES_IN_USE_MESSAGE);
                serviceReferenceArray = services;
                n4 = services.length;
                n3 = 0;
                while (n3 < n4) {
                    service = serviceReferenceArray[n3];
                    System.out.print("    ");
                    System.out.println(service);
                    ++n3;
                }
            } else {
                System.out.print("  ");
                System.out.println(ConsoleMsg.CONSOLE_NO_SERVICES_IN_USE_MESSAGE);
            }
            BundleRevision revision = (BundleRevision)bundle.adapt(BundleRevision.class);
            if (revision != null && (wiring = revision.getWiring()) != null) {
                boolean title = true;
                List exports = wiring.getCapabilities("osgi.wiring.package");
                if (exports.isEmpty()) {
                    System.out.print("  ");
                    System.out.println(ConsoleMsg.CONSOLE_NO_EXPORTED_PACKAGES_MESSAGE);
                } else {
                    title = true;
                    for (BundleCapability export : exports) {
                        if (title) {
                            System.out.print("  ");
                            System.out.println(ConsoleMsg.CONSOLE_EXPORTED_PACKAGES_MESSAGE);
                            title = false;
                        }
                        Map exportAttrs = export.getAttributes();
                        System.out.print("    ");
                        System.out.print(exportAttrs.get("osgi.wiring.package"));
                        System.out.print("; version=\"");
                        System.out.print(exportAttrs.get("version"));
                        System.out.print("\"");
                        if (!wiring.isCurrent()) {
                            System.out.println(ConsoleMsg.CONSOLE_EXPORTED_REMOVAL_PENDING_MESSAGE);
                            continue;
                        }
                        System.out.println(ConsoleMsg.CONSOLE_EXPORTED_MESSAGE);
                    }
                    if (title) {
                        System.out.print("  ");
                        System.out.println(ConsoleMsg.CONSOLE_NO_EXPORTED_PACKAGES_MESSAGE);
                    }
                }
                title = true;
                Map<String, Set<PackageSource>> packages = this.getPackagesInternal(wiring);
                List<BundleRequirement> unresolvedImports = this.getUnresolvedImports(packages, wiring);
                title = this.printImportedPackages(packages, title);
                title = this.printUnwiredDynamicImports(unresolvedImports, title);
                if (title) {
                    System.out.print("  ");
                    System.out.println(ConsoleMsg.CONSOLE_NO_IMPORTED_PACKAGES_MESSAGE);
                }
                System.out.print("  ");
                if ((revision.getTypes() & 1) != 0) {
                    List hostWires = wiring.getRequiredWires("osgi.wiring.host");
                    if (hostWires.isEmpty()) {
                        System.out.println(ConsoleMsg.CONSOLE_NO_HOST_MESSAGE);
                    } else {
                        System.out.println(ConsoleMsg.CONSOLE_HOST_MESSAGE);
                        for (BundleWire hostWire : hostWires) {
                            System.out.print("    ");
                            System.out.println(hostWire.getProvider().getBundle());
                        }
                    }
                } else {
                    List fragmentWires = wiring.getProvidedWires("osgi.wiring.host");
                    if (fragmentWires.isEmpty()) {
                        System.out.println(ConsoleMsg.CONSOLE_NO_FRAGMENT_MESSAGE);
                    } else {
                        System.out.println(ConsoleMsg.CONSOLE_FRAGMENT_MESSAGE);
                        for (BundleWire fragmentWire : fragmentWires) {
                            System.out.print("    ");
                            System.out.println(fragmentWire.getRequirer().getBundle());
                        }
                    }
                    List requiredBundles = wiring.getRequiredWires("osgi.wiring.bundle");
                    title = true;
                    for (BundleWire requiredBundle : requiredBundles) {
                        if (title) {
                            System.out.print("  ");
                            System.out.println(ConsoleMsg.CONSOLE_REQUIRED_BUNDLES_MESSAGE);
                            title = false;
                        }
                        System.out.print("    ");
                        System.out.println(requiredBundle.getProvider());
                    }
                    if (title) {
                        System.out.print("  ");
                        System.out.println(ConsoleMsg.CONSOLE_NO_REQUIRED_BUNDLES_MESSAGE);
                    }
                }
                System.out.println();
                System.out.println();
            }
            ++n2;
        }
    }

    private List<BundleRequirement> getUnresolvedImports(Map<String, Set<PackageSource>> packages, BundleWiring wiring) {
        return Collections.emptyList();
    }

    private boolean printImportedPackages(Map<String, Set<PackageSource>> packages, boolean title) {
        for (Set<PackageSource> packageList : packages.values()) {
            for (PackageSource packageSource : packageList) {
                if (title) {
                    System.out.print("  ");
                    System.out.println(ConsoleMsg.CONSOLE_IMPORTED_PACKAGES_MESSAGE);
                    title = false;
                }
                this.printCapability("    ", packageSource.getCapability(), packageSource.getWire(), "version");
            }
        }
        return title;
    }

    private void printCapability(String prepend, BundleCapability capability, BundleWire wire, String versionKey) {
        Bundle exporter;
        Map exportAttrs = capability.getAttributes();
        System.out.print(prepend);
        System.out.print(exportAttrs.get(capability.getNamespace()));
        if (versionKey != null) {
            System.out.print("; " + versionKey + "=\"");
            System.out.print(exportAttrs.get(versionKey));
            System.out.print("\"");
        }
        Bundle bundle = exporter = wire == null ? capability.getRevision().getBundle() : wire.getProvider().getBundle();
        if (exporter != null) {
            System.out.print(" <");
            System.out.print(exporter);
            System.out.println(">");
        } else {
            System.out.print(" <");
            System.out.print(ConsoleMsg.CONSOLE_STALE_MESSAGE);
            System.out.println(">");
        }
    }

    private boolean printUnwiredDynamicImports(List<BundleRequirement> dynamicImports, boolean title) {
        for (BundleRequirement importReq : dynamicImports) {
            if (title) {
                System.out.print("  ");
                System.out.println(ConsoleMsg.CONSOLE_IMPORTED_PACKAGES_MESSAGE);
                title = false;
            }
            System.out.print("    ");
            System.out.print(importReq);
            System.out.print(";<");
            System.out.print("unwired");
            System.out.print(">");
            System.out.print("<");
            System.out.print((String)importReq.getDirectives().get("resolution"));
            System.out.println(">");
        }
        return title;
    }

    @Descriptor(value="perform a garbage collection")
    public void gc() throws Exception {
        long before = Runtime.getRuntime().freeMemory();
        System.gc();
        System.gc();
        System.runFinalization();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        long after = Runtime.getRuntime().freeMemory();
        System.out.print(ConsoleMsg.CONSOLE_TOTAL_MEMORY_MESSAGE);
        System.out.println(String.valueOf(Runtime.getRuntime().totalMemory()));
        System.out.print(ConsoleMsg.CONSOLE_FREE_MEMORY_BEFORE_GARBAGE_COLLECTION_MESSAGE);
        System.out.println(String.valueOf(before));
        System.out.print(ConsoleMsg.CONSOLE_FREE_MEMORY_AFTER_GARBAGE_COLLECTION_MESSAGE);
        System.out.println(String.valueOf(after));
        System.out.print(ConsoleMsg.CONSOLE_MEMORY_GAINED_WITH_GARBAGE_COLLECTION_MESSAGE);
        System.out.println(String.valueOf(after - before));
    }

    @Descriptor(value="uninstall all bundles")
    public void init() throws Exception {
        if (this.context.getBundle(0L).getState() == 32) {
            System.out.print(newline);
            System.out.println(ConsoleMsg.CONSOLE_FRAMEWORK_LAUNCHED_PLEASE_SHUTDOWN_MESSAGE);
            return;
        }
        Bundle[] bundles = this.context.getBundles();
        int size = bundles.length;
        if (size > 0) {
            int i = 0;
            while (i < size) {
                Bundle bundle = bundles[i];
                if (bundle.getBundleId() != 0L) {
                    try {
                        bundle.uninstall();
                    }
                    catch (BundleException e) {
                        e.printStackTrace();
                    }
                }
                ++i;
            }
        } else {
            System.out.println(ConsoleMsg.CONSOLE_NO_INSTALLED_BUNDLES_ERROR);
        }
        PermissionAdmin securityAdmin = this.activator.getPermissionAdmin();
        ConditionalPermissionAdmin condPermAdmin = this.activator.getConditionalPermissionAdmin();
        if (securityAdmin != null) {
            securityAdmin.setDefaultPermissions(null);
            String[] permLocations = securityAdmin.getLocations();
            if (permLocations != null) {
                String[] stringArray = permLocations;
                int n = permLocations.length;
                int n2 = 0;
                while (n2 < n) {
                    String permLocation = stringArray[n2];
                    securityAdmin.setPermissions(permLocation, null);
                    ++n2;
                }
            }
            ConditionalPermissionUpdate update = condPermAdmin.newConditionalPermissionUpdate();
            update.getConditionalPermissionInfos().clear();
            update.commit();
        }
        if (securityAdmin != null) {
            Enumeration infos = condPermAdmin.getConditionalPermissionInfos();
            while (infos.hasMoreElements()) {
                ((ConditionalPermissionInfo)infos.nextElement()).delete();
            }
        }
    }

    @Descriptor(value="shutdown and exit")
    public void close(CommandSession session) throws Exception {
        if (this.confirmStop(session)) {
            this.context.getBundle(0L).stop();
        }
    }

    @Descriptor(value="refresh the packages of the specified bundles; if -all option is specified refresh packages of all installed bundles")
    public void r(@Descriptor(value="specify to refresh the packages of all installed bundles") @Parameter(absentValue="false", presentValue="true", names={"-all"}) boolean shouldRefreshAll, Bundle ... bundles) throws Exception {
        this.refresh(shouldRefreshAll, bundles);
    }

    @Descriptor(value="refresh the packages of the specified bundles; if -all option is specified refresh packages of all installed bundles")
    public void refresh(@Descriptor(value="specify to refresh the packages of all installed bundles") @Parameter(absentValue="false", presentValue="true", names={"-all"}) boolean shouldRefreshAll, Bundle ... bundles) throws Exception {
        FrameworkWiring frameworkWiring = (FrameworkWiring)this.context.getBundle("System Bundle").adapt(FrameworkWiring.class);
        if (bundles != null && bundles.length > 0) {
            frameworkWiring.refreshBundles(Arrays.asList(bundles), new FrameworkListener[0]);
        } else if (shouldRefreshAll) {
            frameworkWiring.refreshBundles(Arrays.asList(this.context.getBundles()), new FrameworkListener[0]);
        } else {
            frameworkWiring.refreshBundles(null, new FrameworkListener[0]);
        }
    }

    @Descriptor(value="execute a command in a separate process and wait")
    public void exec(@Descriptor(value="command to be executed") String command) throws Exception {
        if (command == null) {
            System.out.println(ConsoleMsg.CONSOLE_NO_COMMAND_SPECIFIED_ERROR);
            return;
        }
        Process p = Runtime.getRuntime().exec(command);
        System.out.println(NLS.bind((String)ConsoleMsg.CONSOLE_STARTED_IN_MESSAGE, (Object)command, (Object)String.valueOf(p)));
        int result = p.waitFor();
        System.out.println(NLS.bind((String)ConsoleMsg.CONSOLE_EXECUTED_RESULT_CODE_MESSAGE, (Object)command, (Object)String.valueOf(result)));
    }

    @Descriptor(value="execute a command in a separate process")
    public void fork(@Descriptor(value="command to be executed") String command) throws Exception {
        if (command == null) {
            System.out.println(ConsoleMsg.CONSOLE_NO_COMMAND_SPECIFIED_ERROR);
            return;
        }
        Process p = Runtime.getRuntime().exec(command);
        System.out.println(NLS.bind((String)ConsoleMsg.CONSOLE_STARTED_IN_MESSAGE, (Object)command, (Object)String.valueOf(p)));
    }

    @Descriptor(value="print bundle headers")
    public List<Dictionary<String, String>> h(Bundle ... bundles) throws Exception {
        return this.headers(bundles);
    }

    @Descriptor(value="print bundle headers")
    public List<Dictionary<String, String>> headers(Bundle ... bundles) throws Exception {
        ArrayList<Dictionary<String, String>> headers = new ArrayList<Dictionary<String, String>>();
        if (bundles == null || bundles.length == 0) {
            System.out.println(ConsoleMsg.CONSOLE_NO_BUNDLE_SPECIFIED_ERROR);
            return headers;
        }
        Bundle[] bundleArray = bundles;
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            headers.add(bundle.getHeaders());
            ++n2;
        }
        return headers;
    }

    @Descriptor(value="Display system properties")
    public Dictionary<?, ?> pr() throws Exception {
        return this.props();
    }

    @Descriptor(value="Display system properties")
    public Dictionary<?, ?> props() throws Exception {
        System.out.println(ConsoleMsg.CONSOLE_SYSTEM_PROPERTIES_TITLE);
        return System.getProperties();
    }

    @Descriptor(value="set OSGi properties")
    public void setp(@Descriptor(value="list of properties with values to be set; the format is <key>=<value> and the pairs are separated with space if more than one") String[] arguments) throws Exception {
        this.setprop(arguments);
    }

    @Descriptor(value="set OSGi properties")
    public void setprop(@Descriptor(value="list of properties with values to be set; the format is <key>=<value> and the pairs are separated with space if more than one") String[] arguments) throws Exception {
        if (arguments == null) {
            System.out.println(ConsoleMsg.CONSOLE_NO_PARAMETERS_SPECIFIED_TITLE);
            this.props();
        } else {
            ServiceReference envInfoRef = this.context.getServiceReference(EnvironmentInfo.class);
            if (envInfoRef != null) {
                EnvironmentInfo envInfo = (EnvironmentInfo)this.context.getService(envInfoRef);
                if (envInfo != null) {
                    System.out.println(ConsoleMsg.CONSOLE_SETTING_PROPERTIES_TITLE);
                    String[] stringArray = arguments;
                    int n = arguments.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String argument = stringArray[n2];
                        int index = argument.indexOf(61);
                        if (index > -1) {
                            String key = argument.substring(0, index);
                            String value = argument.substring(index + 1, argument.length());
                            envInfo.setProperty(key, value);
                            System.out.println(tab + key + " = " + value);
                        }
                        ++n2;
                    }
                } else {
                    System.out.print("  ");
                    System.out.println(ConsoleMsg.CONSOLE_CANNOT_ACCESS_SYSTEM_PROPERTIES);
                }
            }
        }
    }

    @Descriptor(value="display installed bundles (short status)")
    public void ss(String ... arguments) throws Exception {
        int stateFilter;
        if (this.context.getBundle(0L).getState() == 32) {
            System.out.println(ConsoleMsg.CONSOLE_FRAMEWORK_IS_LAUNCHED_MESSAGE);
        } else {
            System.out.println(ConsoleMsg.CONSOLE_FRAMEWORK_IS_SHUTDOWN_MESSAGE);
        }
        System.out.println();
        String states = "";
        String[] bsnSegments = null;
        if (arguments != null && arguments.length > 0) {
            if (arguments[0].equals("-s")) {
                if (arguments.length > 1) {
                    states = arguments[1];
                    if (arguments.length > 2) {
                        bsnSegments = new String[arguments.length - 2];
                        System.arraycopy(arguments, 2, bsnSegments, 0, bsnSegments.length);
                    }
                }
            } else {
                bsnSegments = arguments;
            }
        }
        try {
            stateFilter = this.getStatesFromConstants(states);
        }
        catch (IllegalArgumentException e) {
            return;
        }
        Bundle[] bundles = this.context.getBundles();
        int size = bundles.length;
        if (size == 0) {
            System.out.println(ConsoleMsg.CONSOLE_NO_INSTALLED_BUNDLES_ERROR);
            return;
        }
        System.out.print(newline);
        System.out.print(ConsoleMsg.CONSOLE_ID);
        System.out.print(tab);
        System.out.println(ConsoleMsg.CONSOLE_STATE_BUNDLE_TITLE);
        Bundle[] bundleArray = bundles;
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle b = bundleArray[n2];
            if (this.match(b, bsnSegments, stateFilter)) {
                String label = b.getSymbolicName();
                label = label == null || label.length() == 0 ? b.toString() : String.valueOf(label) + "_" + b.getVersion();
                System.out.println(String.valueOf(b.getBundleId()) + tab + this.getStateName(b) + label);
                BundleRevision revision = (BundleRevision)b.adapt(BundleRevision.class);
                BundleWiring wiring = (BundleWiring)b.adapt(BundleWiring.class);
                if (revision != null && wiring != null) {
                    if ((revision.getTypes() & 1) != 0) {
                        for (BundleWire hostWire : wiring.getRequiredWires("osgi.wiring.host")) {
                            System.out.println("\t            Master=" + hostWire.getProvider().getBundle().getBundleId());
                        }
                    } else {
                        List fragWires = wiring.getProvidedWires("osgi.wiring.host");
                        if (!fragWires.isEmpty()) {
                            System.out.print("\t            Fragments=");
                            Iterator<BundleWire> itr = fragWires.iterator();
                            System.out.print(((BundleWire)itr.next()).getRequirer().getBundle().getBundleId());
                            itr.forEachRemaining(w -> System.out.print(", " + w.getRequirer().getBundle().getBundleId()));
                            System.out.println();
                        }
                    }
                }
            }
            ++n2;
        }
    }

    private boolean match(Bundle toFilter, String[] searchedName, int searchedState) {
        if ((toFilter.getState() & searchedState) == 0) {
            return false;
        }
        return searchedName == null || searchedName.length <= 0 || toFilter.getSymbolicName() == null || toFilter.getSymbolicName().contains(searchedName[0]);
    }

    @Descriptor(value="display threads and thread groups")
    public void t() throws Exception {
        this.t(null, null);
    }

    @Descriptor(value="stop the named thread with an IllegalStateException")
    public void t(@Descriptor(value="stop") String action, @Descriptor(value="the thread on which to perform the action") String thread) throws Exception {
        this.t(action, thread, null);
    }

    @Descriptor(value="stop the named thread with the provided throwable")
    public void t(@Descriptor(value="stop") String action, @Descriptor(value="the thread on which to perform the action") String thread, @Descriptor(value="the class of the throwable to throw (default = java.lang.IllegalStateException)") Class<? extends Throwable> throwable) throws Exception {
        this.threads(action, thread, throwable);
    }

    @Descriptor(value="display threads and thread groups")
    public void threads() throws Exception {
        this.threads(null, null);
    }

    @Descriptor(value="stop the named thread with an IllegalStateException")
    public void threads(@Descriptor(value="stop") String action, @Descriptor(value="the thread on which to perform the action") String thread) throws Exception {
        this.threads(action, thread, null);
    }

    @Descriptor(value="stop the named thread with the provided throwable")
    public void threads(@Descriptor(value="stop") String action, @Descriptor(value="the thread on which to perform the action") String thread, @Descriptor(value="the class of the throwable to throw (default = java.lang.IllegalStateException)") Class<? extends Throwable> throwable) throws Exception {
        Object[] threadGroups = this.getThreadGroups();
        Util.sortByString(threadGroups);
        Object tg = this.getTopThreadGroup();
        Object[] threads = new Thread[((ThreadGroup)tg).activeCount()];
        int count = ((ThreadGroup)tg).enumerate((Thread[])threads, true);
        if (action != null) {
            if ("stop".equals(action)) {
                Throwable toThrow;
                Object t = null;
                Object[] objectArray = threads;
                int n = threads.length;
                int n2 = 0;
                while (n2 < n) {
                    Object namedthread = objectArray[n2];
                    if (((Thread)namedthread).getName().equals(thread)) {
                        t = namedthread;
                        break;
                    }
                    ++n2;
                }
                if (t == null) {
                    System.out.println(NLS.bind((String)ConsoleMsg.THREADS_THREAD_DOES_NOT_EXIST, (Object)thread));
                    return;
                }
                String message = NLS.bind((String)ConsoleMsg.THREADS_THREAD_STOPPED_BY_CONSOLE, (Object)((Thread)t).getName());
                if (throwable == null) {
                    toThrow = new IllegalStateException(message);
                } else {
                    try {
                        toThrow = throwable.getConstructor(String.class).newInstance(message);
                    }
                    catch (Exception e) {
                        toThrow = throwable.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                }
                toThrow.initCause(new RuntimeException(message));
                toThrow.setStackTrace(((Thread)t).getStackTrace());
                Method stop0 = Thread.class.getDeclaredMethod("stop0", Object.class);
                stop0.setAccessible(true);
                stop0.invoke(t, toThrow);
                return;
            }
            System.out.println(ConsoleMsg.THREADS_UNRECOGNIZED_ACTION);
            return;
        }
        Util.sortByString(threads);
        StringBuilder sb = new StringBuilder(120);
        System.out.println();
        System.out.println(ConsoleMsg.CONSOLE_THREADGROUP_TITLE);
        Object[] objectArray = threadGroups;
        int n = threadGroups.length;
        int toThrow = 0;
        while (toThrow < n) {
            Object threadGroup;
            tg = threadGroup = objectArray[toThrow];
            int all = ((ThreadGroup)tg).activeCount();
            int local = ((ThreadGroup)tg).enumerate(new Thread[all], false);
            ThreadGroup p = ((ThreadGroup)tg).getParent();
            String parent = p == null ? "-none-" : p.getName();
            sb.setLength(0);
            sb.append(Util.toString(this.simpleClassName(tg), 18)).append(" ").append(Util.toString(((ThreadGroup)tg).getName(), 21)).append(" ").append(Util.toString(parent, 16)).append(Util.toString(((ThreadGroup)tg).getMaxPriority(), 3)).append(Util.toString(local, 4)).append("/").append(Util.toString(String.valueOf(all), 6));
            System.out.println(sb.toString());
            ++toThrow;
        }
        System.out.print(newline);
        System.out.println(ConsoleMsg.CONSOLE_THREADTYPE_TITLE);
        int j = 0;
        while (j < count) {
            Object t = threads[j];
            if (t != null) {
                sb.setLength(0);
                sb.append(Util.toString(this.simpleClassName(t), 18)).append(" ").append(Util.toString(((Thread)t).getName(), 21)).append(" ").append(Util.toString(((Thread)t).getThreadGroup().getName(), 16)).append(Util.toString(((Thread)t).getPriority(), 3));
                if (((Thread)t).isDaemon()) {
                    sb.append(" [daemon]");
                }
                System.out.println(sb.toString());
            }
            ++j;
        }
    }

    @Descriptor(value="display the start level for the specified bundle, or for the framework if no bundle specified")
    public void sl(Bundle ... bundle) throws Exception {
        int value = 0;
        if (bundle == null || bundle.length == 0) {
            value = this.activator.getStartLevel().getStartLevel();
            System.out.println(NLS.bind((String)ConsoleMsg.STARTLEVEL_FRAMEWORK_ACTIVE_STARTLEVEL, (Object)String.valueOf(value)));
        } else {
            value = ((BundleStartLevel)bundle[0].adapt(BundleStartLevel.class)).getStartLevel();
            System.out.println(NLS.bind((String)ConsoleMsg.STARTLEVEL_BUNDLE_STARTLEVEL, (Object)bundle[0].getBundleId(), (Object)value));
        }
    }

    @Descriptor(value="set the framework start level")
    public void setfwsl(@Descriptor(value="new start level") int newSL) throws Exception {
        try {
            this.activator.getStartLevel().setStartLevel(newSL, new FrameworkListener[0]);
            System.out.println(NLS.bind((String)ConsoleMsg.STARTLEVEL_FRAMEWORK_ACTIVE_STARTLEVEL, (Object)String.valueOf(newSL)));
        }
        catch (IllegalArgumentException e) {
            System.out.println(e.getMessage());
        }
    }

    @Descriptor(value="set the start level for the bundle(s)")
    public void setbsl(@Descriptor(value="new start level") int newSL, Bundle ... bundles) throws Exception {
        if (bundles == null) {
            System.out.println(ConsoleMsg.STARTLEVEL_NO_STARTLEVEL_OR_BUNDLE_GIVEN);
            return;
        }
        Bundle[] bundleArray = bundles;
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            try {
                ((BundleStartLevel)bundle.adapt(BundleStartLevel.class)).setStartLevel(newSL);
                System.out.println(NLS.bind((String)ConsoleMsg.STARTLEVEL_BUNDLE_STARTLEVEL, (Object)bundle.getBundleId(), (Object)newSL));
            }
            catch (IllegalArgumentException e) {
                System.out.println(e.getMessage());
            }
            ++n2;
        }
    }

    @Descriptor(value="set the initial bundle start level")
    public void setibsl(@Descriptor(value="new start level") int newInitialSL) throws Exception {
        try {
            this.activator.getStartLevel().setInitialBundleStartLevel(newInitialSL);
            System.out.println(NLS.bind((String)ConsoleMsg.STARTLEVEL_INITIAL_BUNDLE_STARTLEVEL, (Object)String.valueOf(newInitialSL)));
        }
        catch (IllegalArgumentException e) {
            System.out.println(e.getMessage());
        }
    }

    @Descriptor(value="lists required bundles having the specified symbolic name")
    public void requiredBundles(String ... symbolicName) {
        this.classSpaces(symbolicName);
    }

    @Descriptor(value="lists required bundles having the specified symbolic name")
    public void classSpaces(String ... symbolicName) {
        PackageAdmin packageAdmin = this.activator.getPackageAdmin();
        if (packageAdmin == null) {
            System.out.println(ConsoleMsg.CONSOLE_NO_EXPORTED_PACKAGES_NO_PACKAGE_ADMIN_MESSAGE);
            return;
        }
        String[] names = symbolicName == null || symbolicName.length == 0 ? null : symbolicName;
        ArrayList<Bundle> bundles = new ArrayList<Bundle>();
        if (names == null) {
            bundles.addAll(Arrays.asList(packageAdmin.getBundles(null, null)));
        } else {
            String[] stringArray = names;
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                Bundle[] sameName = packageAdmin.getBundles(name, null);
                if (sameName != null) {
                    bundles.addAll(Arrays.asList(sameName));
                }
                ++n2;
            }
        }
        if (bundles.isEmpty()) {
            System.out.println(ConsoleMsg.CONSOLE_NO_NAMED_CLASS_SPACES_MESSAGE);
        } else {
            for (Bundle bundle : bundles) {
                BundleRevisions revisions = (BundleRevisions)bundle.adapt(BundleRevisions.class);
                List revisionList = revisions.getRevisions();
                BundleRevision revision = revisionList.isEmpty() ? null : (BundleRevision)revisionList.get(0);
                BundleWiring wiring = revision == null ? null : revision.getWiring();
                System.out.print(revision);
                if (wiring == null) {
                    System.out.print("<");
                    System.out.print(ConsoleMsg.CONSOLE_STALE_MESSAGE);
                    System.out.println(">");
                } else if (!wiring.isCurrent()) {
                    System.out.print("<");
                    System.out.print(ConsoleMsg.CONSOLE_REMOVAL_PENDING_MESSAGE);
                    System.out.println(">");
                } else {
                    System.out.println();
                }
                if (wiring == null) continue;
                List requiring = wiring.getProvidedWires("osgi.wiring.bundle");
                for (BundleWire requiringWire : requiring) {
                    System.out.print("  ");
                    System.out.print(requiringWire.getRequirer().getBundle());
                    System.out.print(" ");
                    System.out.println(ConsoleMsg.CONSOLE_REQUIRES_MESSAGE);
                }
            }
        }
    }

    @Descriptor(value="Display & flush the profile log messages")
    public void profilelog() throws Exception {
        Class<?> profileClass = BundleContext.class.getClassLoader().loadClass("org.eclipse.osgi.internal.profile.Profile");
        Method getProfileLog = profileClass.getMethod("getProfileLog", null);
        System.out.println(getProfileLog.invoke(null, null));
    }

    @Descriptor(value="lists all packages visible from the specified bundle")
    public void getPackages(@Descriptor(value="bundle to list the visible packages") Bundle bundle) {
        BundleRevision revision = (BundleRevision)bundle.adapt(BundleRevision.class);
        if (revision == null) {
            System.out.println("Bundle is uninstalled.");
            return;
        }
        if ((revision.getTypes() & 1) != 0) {
            System.out.println("Bundle is a fragment.");
            return;
        }
        BundleWiring wiring = revision.getWiring();
        if (wiring == null) {
            System.out.println("Bundle is not resolved.");
            return;
        }
        Map<String, Set<PackageSource>> packages = this.getPackagesInternal(wiring);
        for (Set<PackageSource> packageSources : packages.values()) {
            for (PackageSource packageSource : packageSources) {
                this.printCapability("  ", packageSource.getCapability(), packageSource.getWire(), "version");
            }
        }
    }

    private Map<String, Set<PackageSource>> getPackagesInternal(BundleWiring wiring) {
        return this.getPackagesInternal0(wiring, null);
    }

    private Map<String, Set<PackageSource>> getPackagesInternal0(BundleWiring wiring, Map<BundleWiring, Map<String, Set<PackageSource>>> allSources) {
        Map<String, Set<PackageSource>> packages;
        if (allSources == null) {
            allSources = new HashMap<BundleWiring, Map<String, Set<PackageSource>>>();
        }
        if ((packages = allSources.get(wiring)) != null) {
            return packages;
        }
        packages = new TreeMap<String, Set<PackageSource>>();
        allSources.put(wiring, packages);
        List packageWires = wiring.getRequiredWires("osgi.wiring.package");
        HashSet<String> importedPackageNames = new HashSet<String>();
        for (BundleWire packageWire : packageWires) {
            String packageName = (String)packageWire.getCapability().getAttributes().get("osgi.wiring.package");
            importedPackageNames.add(packageName);
            this.addAggregatePackageSource(packageWire.getCapability(), packageName, packageWire, packages, allSources);
        }
        for (BundleWire requiredWire : wiring.getRequiredWires("osgi.wiring.bundle")) {
            this.getRequiredBundlePackages(requiredWire, importedPackageNames, packages, allSources);
        }
        return packages;
    }

    private void addAggregatePackageSource(BundleCapability packageCap, String packageName, BundleWire wire, Map<String, Set<PackageSource>> packages, Map<BundleWiring, Map<String, Set<PackageSource>>> allSources) {
        Set<PackageSource> packageSources = packages.get(packageName);
        if (packageSources == null) {
            packageSources = new LinkedHashSet<PackageSource>();
            packages.put(packageName, packageSources);
        }
        packageSources.add(new PackageSource(packageCap, wire));
        Set<PackageSource> providerSource = this.getPackagesInternal0(wire.getProviderWiring(), allSources).get(packageName);
        if (providerSource != null) {
            packageSources.addAll(providerSource);
        }
    }

    private void getRequiredBundlePackages(BundleWire requiredWire, Set<String> importedPackageNames, Map<String, Set<PackageSource>> packages, Map<BundleWiring, Map<String, Set<PackageSource>>> allSources) {
        BundleWiring providerWiring = requiredWire.getProviderWiring();
        for (BundleCapability packageCapability : providerWiring.getCapabilities("osgi.wiring.package")) {
            String packageName = (String)packageCapability.getAttributes().get("osgi.wiring.package");
            if (importedPackageNames.contains(packageName)) continue;
            this.addAggregatePackageSource(packageCapability, packageName, requiredWire, packages, allSources);
        }
        HashSet<String> declaredPackageNames = new HashSet<String>();
        for (BundleCapability declaredPackage : providerWiring.getRevision().getDeclaredCapabilities("osgi.wiring.package")) {
            declaredPackageNames.add((String)declaredPackage.getAttributes().get("osgi.wiring.package"));
        }
        for (BundleWire fragmentWire : providerWiring.getProvidedWires("osgi.wiring.host")) {
            for (BundleCapability declaredPackage : fragmentWire.getRequirer().getDeclaredCapabilities("osgi.wiring.package")) {
                declaredPackageNames.add((String)declaredPackage.getAttributes().get("osgi.wiring.package"));
            }
        }
        for (BundleWire packageWire : providerWiring.getRequiredWires("osgi.wiring.package")) {
            String packageName = (String)packageWire.getCapability().getAttributes().get("osgi.wiring.package");
            if (importedPackageNames.contains(packageName) || !declaredPackageNames.contains(packageName)) continue;
            this.addAggregatePackageSource(packageWire.getCapability(), packageName, packageWire, packages, allSources);
        }
        for (BundleWire providerBundleWire : providerWiring.getRequiredWires("osgi.wiring.bundle")) {
            String visibilityDirective = (String)providerBundleWire.getRequirement().getDirectives().get("visibility");
            if (!"reexport".equals(visibilityDirective)) continue;
            this.getRequiredBundlePackages(providerBundleWire, importedPackageNames, packages, allSources);
        }
    }

    protected int getStartLevelFromToken(String value) {
        int retval = -1;
        try {
            retval = Integer.parseInt(value);
            if (Integer.parseInt(value) <= 0) {
                System.out.println(ConsoleMsg.STARTLEVEL_POSITIVE_INTEGER);
            }
        }
        catch (NumberFormatException nfe) {
            System.out.println(ConsoleMsg.STARTLEVEL_POSITIVE_INTEGER);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String getStateName(Bundle bundle) {
        int state = bundle.getState();
        switch (state) {
            case 1: {
                return "UNINSTALLED ";
            }
            case 2: {
                return "INSTALLED   ";
            }
            case 4: {
                return "RESOLVED    ";
            }
            case 8: {
                List<Bundle> list = this.lazyActivation;
                synchronized (list) {
                    if (this.lazyActivation.contains(bundle)) {
                        return "<<LAZY>>    ";
                    }
                    return "STARTING    ";
                }
            }
            case 16: {
                return "STOPPING    ";
            }
            case 32: {
                return "ACTIVE      ";
            }
        }
        return Integer.toHexString(state);
    }

    protected ThreadGroup[] getThreadGroups() {
        ThreadGroup[] groups;
        ThreadGroup tg = this.getTopThreadGroup();
        int count = tg.enumerate(groups = new ThreadGroup[tg.activeGroupCount()], true);
        if (count == groups.length) {
            return groups;
        }
        ThreadGroup[] ngroups = new ThreadGroup[count];
        System.arraycopy(groups, 0, ngroups, 0, count);
        return ngroups;
    }

    protected ThreadGroup getTopThreadGroup() {
        ThreadGroup topGroup = Thread.currentThread().getThreadGroup();
        if (topGroup != null) {
            while (topGroup.getParent() != null) {
                topGroup = topGroup.getParent();
            }
        }
        return topGroup;
    }

    public String simpleClassName(Object o) {
        StringTokenizer t = new StringTokenizer(o.getClass().getName(), ".");
        int ct = t.countTokens();
        int i = 1;
        while (i < ct) {
            t.nextToken();
            ++i;
        }
        return t.nextToken();
    }

    @Descriptor(value="displays the system properties with the given name, or all of them")
    public void getprop(String ... propName) throws Exception {
        Properties allProperties = System.getProperties();
        for (String string : new TreeSet<Object>(allProperties.keySet())) {
            if (propName != null && propName.length != 0 && !string.startsWith(propName[0])) continue;
            System.out.println(String.valueOf(string) + '=' + allProperties.getProperty(string));
        }
    }

    @Descriptor(value="Displays unsatisfied constraints for the specified bundle(s)")
    public void diag(@Descriptor(value="IDs of bundle(s), for which to display unsatisfied constraints") Bundle[] bundles) throws Exception {
        int n;
        if (bundles.length == 0) {
            Bundle[] allBundles;
            ArrayList<Bundle> unresolved = new ArrayList<Bundle>();
            Bundle[] bundleArray = allBundles = this.context.getBundles();
            int n2 = allBundles.length;
            n = 0;
            while (n < n2) {
                Bundle bundle = bundleArray[n];
                BundleRevision revision = (BundleRevision)bundle.adapt(BundleRevision.class);
                if (revision != null && revision.getWiring() == null) {
                    unresolved.add(bundle);
                }
                ++n;
            }
            if (unresolved.isEmpty()) {
                System.out.println("No unresolved bundles.");
                return;
            }
            bundles = unresolved.toArray(new Bundle[unresolved.size()]);
        }
        ResolutionReport report = this.getResolutionReport(bundles);
        Bundle[] bundleArray = bundles;
        n = bundles.length;
        int n3 = 0;
        while (n3 < n) {
            Bundle bundle = bundleArray[n3];
            BundleRevision revision = (BundleRevision)bundle.adapt(BundleRevision.class);
            if (revision != null) {
                System.out.println(report.getResolutionReportMessage((Resource)revision));
            }
            ++n3;
        }
    }

    private ResolutionReport getResolutionReport(Bundle[] bundles) {
        DiagReportListener reportListener = new DiagReportListener(bundles);
        ServiceRegistration hookReg = this.context.registerService(ResolverHookFactory.class, (Object)reportListener, null);
        try {
            Bundle systemBundle = this.context.getBundle("System Bundle");
            FrameworkWiring frameworkWiring = (FrameworkWiring)systemBundle.adapt(FrameworkWiring.class);
            frameworkWiring.resolveBundles(Arrays.asList(bundles));
            ResolutionReport resolutionReport = reportListener.getReport();
            return resolutionReport;
        }
        finally {
            hookReg.unregister();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bundleChanged(BundleEvent event) {
        int type = event.getType();
        Bundle bundle = event.getBundle();
        List<Bundle> list = this.lazyActivation;
        synchronized (list) {
            switch (type) {
                case 512: {
                    if (this.lazyActivation.contains(bundle)) break;
                    this.lazyActivation.add(bundle);
                    break;
                }
                default: {
                    this.lazyActivation.remove(bundle);
                }
            }
        }
    }

    private boolean confirmStop(CommandSession session) {
        PrintStream consoleStream = session.getConsole();
        consoleStream.print(ConsoleMsg.CONSOLE_STOP_MESSAGE);
        consoleStream.flush();
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        String reply = null;
        try {
            reply = reader.readLine();
        }
        catch (IOException e) {
            consoleStream.println(ConsoleMsg.CONSOLE_STOP_ERROR_READ_CONFIRMATION);
        }
        return reply != null && (reply.toLowerCase().startsWith(ConsoleMsg.CONSOLE_STOP_CONFIRMATION_YES) || reply.length() == 0);
    }

    private static class DiagReportListener
    implements ResolverHookFactory {
        private final Collection<BundleRevision> targetTriggers = new ArrayList<BundleRevision>();
        volatile ResolutionReport report = null;

        public DiagReportListener(Bundle[] bundles) {
            Bundle[] bundleArray = bundles;
            int n = bundles.length;
            int n2 = 0;
            while (n2 < n) {
                Bundle bundle = bundleArray[n2];
                BundleRevision revision = (BundleRevision)bundle.adapt(BundleRevision.class);
                if (revision != null && revision.getWiring() == null) {
                    this.targetTriggers.add(revision);
                }
                ++n2;
            }
        }

        public ResolverHook begin(Collection<BundleRevision> triggers) {
            if (triggers.containsAll(this.targetTriggers)) {
                return new DiagResolverHook();
            }
            return null;
        }

        ResolutionReport getReport() {
            return this.report;
        }

        class DiagResolverHook
        implements ResolverHook,
        ResolutionReport.Listener {
            DiagResolverHook() {
            }

            public void handleResolutionReport(ResolutionReport report) {
                DiagReportListener.this.report = report;
            }

            public void filterResolvable(Collection<BundleRevision> candidates) {
            }

            public void filterSingletonCollisions(BundleCapability singleton, Collection<BundleCapability> collisionCandidates) {
            }

            public void filterMatches(BundleRequirement requirement, Collection<BundleCapability> candidates) {
            }

            public void end() {
            }
        }
    }

    class PackageSource {
        private final BundleCapability cap;
        private final BundleWire wire;

        PackageSource(BundleCapability cap, BundleWire wire) {
            this.cap = cap;
            this.wire = wire;
        }

        BundleCapability getCapability() {
            return this.cap;
        }

        BundleWire getWire() {
            return this.wire;
        }

        public boolean equals(Object o) {
            if (o instanceof PackageSource) {
                return Objects.equals(this.cap, ((PackageSource)o).cap) && Objects.equals(this.wire.getProvider(), ((PackageSource)o).wire.getProvider());
            }
            return false;
        }

        public int hashCode() {
            return this.cap.hashCode() ^ this.wire.getProvider().hashCode();
        }
    }
}

