/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.clipboard;

import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.ImageTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swtchart.extensions.clipboard.ImageArrayTransfer;
import org.eclipse.swtchart.extensions.clipboard.ImageSupplier;
import org.eclipse.swtchart.extensions.core.BaseChart;

public class ImageClipboardSupport {
    public static void transfer(Display display, BaseChart baseChart) {
        ImageSupplier imageSupplier = new ImageSupplier();
        ImageData imageData = imageSupplier.getImageData(baseChart);
        Clipboard clipboard = new Clipboard(display);
        try {
            if (ImageClipboardSupport.isWindows()) {
                clipboard.setContents(new Object[]{imageData, imageData}, new Transfer[]{ImageTransfer.getInstance(), ImageArrayTransfer.getInstanceWindows()});
            } else if (ImageClipboardSupport.isLinux()) {
                clipboard.setContents(new Object[]{imageData}, new Transfer[]{ImageArrayTransfer.getInstanceLinux()});
            } else if (ImageClipboardSupport.isMac() || ImageClipboardSupport.isUnix()) {
                clipboard.setContents(new Object[]{imageData}, new Transfer[]{ImageTransfer.getInstance()});
            }
        }
        finally {
            if (clipboard != null && !clipboard.isDisposed()) {
                clipboard.dispose();
            }
        }
    }

    private static boolean isWindows() {
        return ImageClipboardSupport.getOperatingSystem().indexOf("win") >= 0;
    }

    private static boolean isLinux() {
        return ImageClipboardSupport.getOperatingSystem().indexOf("linux") >= 0;
    }

    private static boolean isMac() {
        return ImageClipboardSupport.getOperatingSystem().indexOf("mac") >= 0;
    }

    private static boolean isUnix() {
        return ImageClipboardSupport.getOperatingSystem().indexOf("unix") >= 0;
    }

    private static String getOperatingSystem() {
        return System.getProperty("os.name").toLowerCase();
    }
}

