/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.scanner;

import org.eclipse.cdt.core.parser.ExtendedScannerInfo;
import org.eclipse.cdt.core.parser.IParserSettings;
import org.eclipse.cdt.core.parser.IParserSettings2;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.IToken;
import org.eclipse.cdt.core.parser.ParseError;
import org.eclipse.cdt.internal.core.parser.scanner.TokenUtil;

public class Token
implements IToken,
Cloneable {
    private int fKind;
    private int fOffset;
    private int fEndOffset;
    private IToken fNextToken;
    Object fSource;
    private static final Counter tokenCounter = new Counter();

    Token(int kind, Object source, int offset, int endOffset) {
        tokenCounter.inc();
        this.fKind = kind;
        this.fOffset = offset;
        this.fEndOffset = endOffset;
        this.fSource = source;
    }

    @Override
    public final int getType() {
        return this.fKind;
    }

    @Override
    public final int getOffset() {
        return this.fOffset;
    }

    @Override
    public final int getEndOffset() {
        return this.fEndOffset;
    }

    @Override
    public final int getLength() {
        return this.fEndOffset - this.fOffset;
    }

    @Override
    public final IToken getNext() {
        return this.fNextToken;
    }

    @Override
    public final void setType(int kind) {
        this.fKind = kind;
    }

    @Override
    public final void setNext(IToken t) {
        this.fNextToken = t;
    }

    public void setOffset(int offset, int endOffset) {
        this.fOffset = offset;
        this.fEndOffset = endOffset;
    }

    public void shiftOffset(int shift) {
        this.fOffset += shift;
        this.fEndOffset += shift;
    }

    @Override
    public char[] getCharImage() {
        return TokenUtil.getImage(this.getType());
    }

    public String toString() {
        return this.getImage();
    }

    @Override
    public final boolean isOperator() {
        return TokenUtil.isOperator(this.fKind);
    }

    @Override
    public String getImage() {
        return new String(this.getCharImage());
    }

    public final Token clone() {
        try {
            tokenCounter.inc();
            return (Token)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public static void resetCounterFor(IScannerInfo info) {
        tokenCounter.reset(info);
    }

    private static class Counter {
        public int count = 0;
        public int limit = -1;

        private Counter() {
        }

        public void reset(IScannerInfo info) {
            int maxTokens;
            IParserSettings2 parserSettings;
            IParserSettings settings;
            this.count = 0;
            this.limit = -1;
            if (info instanceof ExtendedScannerInfo && (settings = ((ExtendedScannerInfo)info).getParserSettings()) instanceof IParserSettings2 && (parserSettings = (IParserSettings2)settings).shouldLimitTokensPerTranslationUnit() && (maxTokens = parserSettings.getMaximumTokensPerTranslationUnit()) > 0) {
                this.limit = maxTokens;
            }
        }

        public void inc() throws ParseError {
            if (this.limit > 0 && ++this.count > this.limit) {
                throw new ParseError(Integer.toString(this.count) + " tokens", ParseError.ParseErrorKind.TOO_MANY_TOKENS);
            }
        }
    }
}

